/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.tools.table;

import de.p2tools.mtplayer.controller.config.ProgColorList;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkData;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import javafx.scene.control.TableRow;
import javafx.scene.control.Tooltip;

public class TableRowBookmark<T>
extends TableRow<T> {
    @Override
    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (item == null || empty) {
            this.setStyle("");
            this.setTooltip(null);
        } else {
            BookmarkData bookmarkData = (BookmarkData)item;
            FilmDataMTP film = bookmarkData.getFilmData();
            if (ProgConfig.BOOKMARK_DIALOG_SHOW_TABLE_TOOL_TIP.getValue().booleanValue()) {
                this.setTooltip(new Tooltip(bookmarkData.getTheme() + "\n" + bookmarkData.getTitle()));
            }
            if (bookmarkData.getFilmData() == null) {
                this.setStyle(ProgColorList.BOOKMARK_NO_FILM.getCssBackground());
            } else if (film != null && film.isShown()) {
                this.setStyle(ProgColorList.FILM_HISTORY.getCssBackground());
            } else {
                this.setStyle("");
            }
        }
    }
}

