/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.tools.table;

import de.p2tools.mtplayer.controller.config.ProgColorList;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkFactory;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.data.film.FilmPlayFactory;
import de.p2tools.mtplayer.controller.data.film.FilmSaveFactory;
import de.p2tools.p2lib.mediathek.film.FilmSize;
import de.p2tools.p2lib.tools.date.P2Date;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.HBox;

public class TableFilmFactory {
    private TableFilmFactory() {
    }

    public static void columnFactoryString(TableColumn<FilmDataMTP, String> column) {
        column.setCellFactory(c -> new TableCell<FilmDataMTP, String>(){

            @Override
            protected void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setText(null);
                    this.setStyle("");
                    return;
                }
                this.setText(item);
                FilmDataMTP film = (FilmDataMTP)this.getTableView().getItems().get(this.getIndex());
                TableFilmFactory.set(film, this);
            }
        });
    }

    public static void columnFactoryInteger(TableColumn<FilmDataMTP, Integer> column) {
        column.setCellFactory(c -> new TableCell<FilmDataMTP, Integer>(){

            @Override
            protected void updateItem(Integer item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                if (item == 0) {
                    this.setGraphic(null);
                    this.setText(null);
                } else {
                    this.setGraphic(null);
                    this.setText("" + item);
                }
                FilmDataMTP film = (FilmDataMTP)this.getTableView().getItems().get(this.getIndex());
                TableFilmFactory.set(film, this);
            }
        });
    }

    public static void columnFactoryBoolean(TableColumn<FilmDataMTP, Boolean> column) {
        column.setCellFactory(c -> new TableCell<FilmDataMTP, Boolean>(){

            @Override
            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                this.setAlignment(Pos.CENTER);
                CheckBox box = new CheckBox();
                box.setMaxHeight(6.0);
                box.setMinHeight(6.0);
                box.setPrefSize(6.0, 6.0);
                box.setDisable(true);
                box.getStyleClass().add("checkbox-table");
                box.setSelected(item);
                this.setGraphic(box);
                FilmDataMTP film = (FilmDataMTP)this.getTableView().getItems().get(this.getIndex());
                TableFilmFactory.set(film, this);
            }
        });
    }

    public static void columnFactoryP2Date(TableColumn<FilmDataMTP, P2Date> column) {
        column.setCellFactory(c -> new TableCell<FilmDataMTP, P2Date>(){

            @Override
            protected void updateItem(P2Date item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setText(null);
                    this.setStyle("");
                    return;
                }
                this.setText(item.toString());
                FilmDataMTP film = (FilmDataMTP)this.getTableView().getItems().get(this.getIndex());
                TableFilmFactory.set(film, this);
            }
        });
    }

    public static void columnFactoryFilmSize(TableColumn<FilmDataMTP, FilmSize> column) {
        column.setCellFactory(c -> new TableCell<FilmDataMTP, FilmSize>(){

            @Override
            protected void updateItem(FilmSize item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setText(null);
                    this.setStyle("");
                    return;
                }
                this.setText(item.toString());
                FilmDataMTP film = (FilmDataMTP)this.getTableView().getItems().get(this.getIndex());
                TableFilmFactory.set(film, this);
            }
        });
    }

    public static void columnFactoryButton(TableColumn<FilmDataMTP, String> column) {
        column.setCellFactory(c -> new TableCell<FilmDataMTP, String>(){

            @Override
            protected void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                FilmDataMTP film = (FilmDataMTP)this.getTableView().getItems().get(this.getIndex());
                HBox hbox = new HBox();
                hbox.setSpacing(4.0);
                hbox.setAlignment(Pos.CENTER);
                hbox.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
                Button btnPlay = new Button("");
                btnPlay.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                btnPlay.setGraphic(ProgIcons.IMAGE_TABLE_FILM_PLAY.getImageView());
                btnPlay.setOnAction(e -> {
                    this.getTableView().getSelectionModel().clearSelection();
                    this.getTableView().getSelectionModel().select(this.getIndex());
                    FilmPlayFactory.playFilm(false, film);
                    this.getTableView().refresh();
                    this.getTableView().requestFocus();
                });
                Button btnSave = new Button("");
                btnSave.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                btnSave.setGraphic(ProgIcons.IMAGE_TABLE_FILM_SAVE.getImageView());
                btnSave.setOnAction(e -> {
                    this.getTableView().getSelectionModel().clearSelection();
                    this.getTableView().getSelectionModel().select(this.getIndex());
                    FilmSaveFactory.saveFilm(false, film);
                    this.getTableView().refresh();
                    this.getTableView().requestFocus();
                });
                Button btnBookmark = new Button("");
                btnBookmark.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                if (film.isBookmark()) {
                    btnBookmark.setGraphic(ProgIcons.IMAGE_TABLE_BOOKMARK_DEL.getImageView());
                } else {
                    btnBookmark.setGraphic(ProgIcons.IMAGE_TABLE_BOOKMARK.getImageView());
                }
                btnBookmark.setOnAction(e -> {
                    this.getTableView().getSelectionModel().clearSelection();
                    this.getTableView().getSelectionModel().select(this.getIndex());
                    if (film.isBookmark()) {
                        BookmarkFactory.removeBookmark(film);
                    } else {
                        BookmarkFactory.addBookmark(false, film);
                    }
                    this.getTableView().refresh();
                    this.getTableView().requestFocus();
                });
                if (ProgConfig.SYSTEM_SMALL_TABLE_ROW_FILM.get()) {
                    btnPlay.setMaxHeight(18.0);
                    btnPlay.setMinHeight(18.0);
                    btnSave.setMaxHeight(18.0);
                    btnSave.setMinHeight(18.0);
                    btnBookmark.setMaxHeight(18.0);
                    btnBookmark.setMinHeight(18.0);
                }
                hbox.getChildren().addAll((Node[])new Node[]{btnPlay, btnSave, btnBookmark});
                this.setGraphic(hbox);
                TableFilmFactory.set(film, this);
            }
        });
    }

    public static void set(FilmDataMTP film, TableCell tableCell) {
        if (film.isLive()) {
            tableCell.setStyle(ProgColorList.FILM_LIVESTREAM.getCssFontBold());
        } else if (ProgConfig.SYSTEM_MARK_GEO.get() && film.isGeoBlocked()) {
            tableCell.setStyle(ProgColorList.FILM_GEOBLOCK.getCssFontBold());
        } else if (film.isNewFilm()) {
            tableCell.setStyle(ProgColorList.FILM_NEW.getCssFont());
        } else {
            tableCell.setStyle("");
        }
    }
}

