/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.tools.table;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgColorList;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.gui.tools.table.PTable;
import de.p2tools.mtplayer.gui.tools.table.Table;
import de.p2tools.mtplayer.gui.tools.table.TableFilmFactory;
import de.p2tools.p2lib.guitools.P2TableFactory;
import de.p2tools.p2lib.mediathek.film.FilmSize;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.date.P2Date;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;

public class TableFilm
extends PTable<FilmDataMTP> {
    public TableFilm(Table.TABLE_ENUM table_enum, ProgData progData) {
        super(table_enum);
        this.table_enum = table_enum;
        this.iniColumn();
    }

    @Override
    public Table.TABLE_ENUM getETable() {
        return this.table_enum;
    }

    public void resetTable() {
        this.iniColumn();
        Table.resetTable(this);
    }

    private void refreshTable() {
        P2TableFactory.refreshTable(this);
    }

    private void iniColumn() {
        this.getColumns().clear();
        this.setTableMenuButtonVisible(true);
        this.setEditable(false);
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        ProgColorList.FILM_LIVESTREAM.colorProperty().addListener((a, b, c) -> P2TableFactory.refreshTable(this));
        ProgColorList.FILM_GEOBLOCK.colorProperty().addListener((a, b, c) -> P2TableFactory.refreshTable(this));
        ProgColorList.FILM_NEW.colorProperty().addListener((a, b, c) -> P2TableFactory.refreshTable(this));
        ProgColorList.FILM_HISTORY.colorProperty().addListener((a, b, c) -> P2TableFactory.refreshTable(this));
        ProgColorList.BOOKMARK.colorProperty().addListener((a, b, c) -> P2TableFactory.refreshTable(this));
        ProgConfig.SYSTEM_SMALL_TABLE_ROW_FILM.addListener((observableValue, s, t1) -> P2TableFactory.refreshTable(this));
        ProgConfig.FILM_GUI_SHOW_TABLE_TOOL_TIP.addListener((observableValue, s, t1) -> P2TableFactory.refreshTable(this));
        ProgConfig.SYSTEM_THEME_CHANGED.addListener((u, o, n) -> P2TableFactory.refreshTable(this));
        ProgData.getInstance().pEventHandler.addListener(new P2Listener(PEvents.EVENT_REFRESH_TABLE){

            @Override
            public void pingGui() {
                TableFilm.this.refreshTable();
            }
        });
        ProgData.getInstance().pEventHandler.addListener(new P2Listener(PEvents.EVENT_HISTORY_CHANGED){

            @Override
            public void pingGui() {
                TableFilm.this.refreshTable();
            }
        });
        ProgData.getInstance().pEventHandler.addListener(new P2Listener(PEvents.EVENT_BLACKLIST_CHANGED){

            @Override
            public void pingGui() {
                TableFilm.this.refreshTable();
            }
        });
        ProgData.getInstance().pEventHandler.addListener(new P2Listener(PEvents.EVENT_BOOKMARK_CHANGED){

            @Override
            public void pingGui() {
                TableFilm.this.refreshTable();
            }
        });
        TableColumn<FilmDataMTP, Integer> nrColumn = new TableColumn<FilmDataMTP, Integer>("Nr");
        nrColumn.setCellValueFactory(new PropertyValueFactory("no"));
        nrColumn.getStyleClass().add("alignCenterRightPadding_10");
        TableFilmFactory.columnFactoryInteger(nrColumn);
        TableColumn<FilmDataMTP, String> channelColumn = new TableColumn<FilmDataMTP, String>("Sender");
        channelColumn.setCellValueFactory(new PropertyValueFactory("channel"));
        channelColumn.getStyleClass().add("alignCenter");
        TableFilmFactory.columnFactoryString(channelColumn);
        TableColumn<FilmDataMTP, String> themeColumn = new TableColumn<FilmDataMTP, String>("Thema");
        themeColumn.setCellValueFactory(new PropertyValueFactory("theme"));
        themeColumn.getStyleClass().add("alignCenterLeft");
        TableFilmFactory.columnFactoryString(themeColumn);
        TableColumn<FilmDataMTP, String> titleColumn = new TableColumn<FilmDataMTP, String>("Titel");
        titleColumn.setCellValueFactory(new PropertyValueFactory("title"));
        titleColumn.getStyleClass().add("alignCenterLeft");
        TableFilmFactory.columnFactoryString(titleColumn);
        TableColumn<FilmDataMTP, String> startColumn = new TableColumn<FilmDataMTP, String>("");
        startColumn.setCellValueFactory(new PropertyValueFactory("buttonDummy"));
        startColumn.getStyleClass().add("alignCenter");
        TableFilmFactory.columnFactoryButton(startColumn);
        TableColumn<FilmDataMTP, P2Date> dateColumn = new TableColumn<FilmDataMTP, P2Date>("Datum");
        dateColumn.setCellValueFactory(new PropertyValueFactory("date"));
        dateColumn.getStyleClass().add("alignCenter");
        TableFilmFactory.columnFactoryP2Date(dateColumn);
        TableColumn<FilmDataMTP, String> timeColumn = new TableColumn<FilmDataMTP, String>("Zeit");
        timeColumn.setCellValueFactory(new PropertyValueFactory("time"));
        timeColumn.getStyleClass().add("alignCenter");
        TableFilmFactory.columnFactoryString(timeColumn);
        TableColumn<FilmDataMTP, Integer> durationColumn = new TableColumn<FilmDataMTP, Integer>("Dauer [min]");
        durationColumn.setCellValueFactory(new PropertyValueFactory("durationMinute"));
        durationColumn.getStyleClass().add("alignCenterRightPadding_25");
        TableFilmFactory.columnFactoryInteger(durationColumn);
        TableColumn<FilmDataMTP, FilmSize> sizeColumn = new TableColumn<FilmDataMTP, FilmSize>("Gr\u00f6\u00dfe [MB]");
        sizeColumn.setCellValueFactory(new PropertyValueFactory("filmSize"));
        sizeColumn.getStyleClass().add("alignCenterRightPadding_25");
        TableFilmFactory.columnFactoryFilmSize(sizeColumn);
        TableColumn<FilmDataMTP, Boolean> hdColumn = new TableColumn<FilmDataMTP, Boolean>("HD");
        hdColumn.setCellValueFactory(new PropertyValueFactory("hd"));
        hdColumn.getStyleClass().add("alignCenter");
        TableFilmFactory.columnFactoryBoolean(hdColumn);
        TableColumn<FilmDataMTP, Boolean> utColumn = new TableColumn<FilmDataMTP, Boolean>("UT");
        utColumn.setCellValueFactory(new PropertyValueFactory("ut"));
        utColumn.getStyleClass().add("alignCenter");
        TableFilmFactory.columnFactoryBoolean(utColumn);
        TableColumn<FilmDataMTP, String> geoColumn = new TableColumn<FilmDataMTP, String>("Geo");
        geoColumn.setCellValueFactory(new PropertyValueFactory("geo"));
        geoColumn.getStyleClass().add("alignCenter");
        TableFilmFactory.columnFactoryString(geoColumn);
        TableColumn<FilmDataMTP, Boolean> doubleColumn = new TableColumn<FilmDataMTP, Boolean>("Doppelt");
        doubleColumn.setCellValueFactory(new PropertyValueFactory("doubleUrl"));
        doubleColumn.getStyleClass().add("alignCenter");
        TableFilmFactory.columnFactoryBoolean(doubleColumn);
        TableColumn<FilmDataMTP, String> urlColumn = new TableColumn<FilmDataMTP, String>("URL");
        urlColumn.setCellValueFactory(new PropertyValueFactory("url"));
        urlColumn.getStyleClass().add("alignCenterLeft");
        TableFilmFactory.columnFactoryString(urlColumn);
        TableColumn<FilmDataMTP, String> aboColumn = new TableColumn<FilmDataMTP, String>("Abo");
        aboColumn.setCellValueFactory(new PropertyValueFactory("aboName"));
        aboColumn.getStyleClass().add("alignCenterLeft");
        TableFilmFactory.columnFactoryString(aboColumn);
        TableColumn<FilmDataMTP, Boolean> bookmarkColumn = new TableColumn<FilmDataMTP, Boolean>("Bookmark");
        bookmarkColumn.setCellValueFactory(new PropertyValueFactory("bookmark"));
        bookmarkColumn.getStyleClass().add("alignCenter");
        TableFilmFactory.columnFactoryBoolean(bookmarkColumn);
        nrColumn.setPrefWidth(50.0);
        channelColumn.setPrefWidth(80.0);
        themeColumn.setPrefWidth(180.0);
        titleColumn.setPrefWidth(230.0);
        startColumn.setPrefWidth(150.0);
        this.getColumns().addAll(nrColumn, channelColumn, themeColumn, titleColumn, startColumn, dateColumn, timeColumn, durationColumn, sizeColumn, hdColumn, utColumn, bookmarkColumn, geoColumn, doubleColumn, aboColumn, urlColumn);
    }
}

