/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.tools.table;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgColorList;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkData;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkFactory;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.data.film.FilmPlayFactory;
import de.p2tools.mtplayer.controller.data.film.FilmSaveFactory;
import de.p2tools.p2lib.tools.date.P2Date;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.HBox;

public class TableBookmarkFactory {
    private TableBookmarkFactory() {
    }

    public static void columnFactoryList(TableColumn<BookmarkData, Boolean> column) {
        column.setCellFactory(c -> new TableCell<BookmarkData, Boolean>(){

            @Override
            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setText(null);
                    this.setStyle("");
                    return;
                }
                if (item.booleanValue()) {
                    this.setText("Audio");
                } else {
                    this.setText("Film");
                }
                BookmarkData bookmarkData = (BookmarkData)this.getTableView().getItems().get(this.getIndex());
                TableBookmarkFactory.set(bookmarkData, this);
            }
        });
    }

    public static void columnFactoryString(TableColumn<BookmarkData, String> column) {
        column.setCellFactory(c -> new TableCell<BookmarkData, String>(){

            @Override
            protected void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setText(null);
                    this.setStyle("");
                    return;
                }
                this.setText(item);
                BookmarkData bookmarkData = (BookmarkData)this.getTableView().getItems().get(this.getIndex());
                TableBookmarkFactory.set(bookmarkData, this);
            }
        });
    }

    public static void columnFactoryP2Date(TableColumn<BookmarkData, P2Date> column) {
        column.setCellFactory(c -> new TableCell<BookmarkData, P2Date>(){

            @Override
            protected void updateItem(P2Date item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setText(null);
                    this.setStyle("");
                    return;
                }
                this.setText(item.toString());
                BookmarkData bookmarkData = (BookmarkData)this.getTableView().getItems().get(this.getIndex());
                TableBookmarkFactory.set(bookmarkData, this);
            }
        });
    }

    public static void columnFactoryAge(TableColumn<BookmarkData, P2Date> column) {
        column.setCellFactory(c -> new TableCell<BookmarkData, P2Date>(){

            @Override
            protected void updateItem(P2Date item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setText(null);
                    this.setStyle("");
                    return;
                }
                int age = item.diffInDays();
                this.setText("" + age);
                BookmarkData bookmarkData = (BookmarkData)this.getTableView().getItems().get(this.getIndex());
                TableBookmarkFactory.set(bookmarkData, this);
            }
        });
    }

    public static void columnFactoryButton(TableColumn<BookmarkData, String> column) {
        column.setCellFactory(c -> new TableCell<BookmarkData, String>(){

            @Override
            protected void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                BookmarkData bookmarkData = (BookmarkData)this.getTableView().getItems().get(this.getIndex());
                FilmDataMTP filmDataMTP = bookmarkData.getFilmData();
                HBox hbox = new HBox();
                hbox.setSpacing(4.0);
                hbox.setAlignment(Pos.CENTER);
                hbox.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
                Button btnPlay = new Button("");
                btnPlay.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                btnPlay.setGraphic(ProgIcons.IMAGE_TABLE_FILM_PLAY.getImageView());
                Button btnSave = new Button("");
                btnSave.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                btnSave.setGraphic(ProgIcons.IMAGE_TABLE_FILM_SAVE.getImageView());
                Button btnBookmark = new Button("");
                btnBookmark.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                btnBookmark.setGraphic(ProgIcons.IMAGE_TABLE_BOOKMARK_DEL.getImageView());
                if (ProgConfig.BOOKMARK_DIALOG_SMALL_TABLE_ROW.get()) {
                    btnPlay.setMaxHeight(18.0);
                    btnPlay.setMinHeight(18.0);
                    btnSave.setMaxHeight(18.0);
                    btnSave.setMinHeight(18.0);
                    btnBookmark.setMaxHeight(18.0);
                    btnBookmark.setMinHeight(18.0);
                }
                btnPlay.setOnAction(e -> {
                    this.getTableView().getSelectionModel().clearSelection();
                    this.getTableView().getSelectionModel().select(this.getIndex());
                    if (bookmarkData.getFilmData() == null) {
                        FilmDataMTP filmData = new FilmDataMTP();
                        filmData.arr[3] = bookmarkData.getTitle();
                        filmData.arr[2] = bookmarkData.getTheme();
                        filmData.arr[14] = bookmarkData.getUrl();
                        FilmPlayFactory.playFilm(bookmarkData.isAudio(), filmData);
                    } else {
                        FilmPlayFactory.playFilm(bookmarkData.isAudio(), filmDataMTP);
                    }
                    this.getTableView().refresh();
                    this.getTableView().requestFocus();
                });
                btnSave.setOnAction(e -> {
                    this.getTableView().getSelectionModel().clearSelection();
                    this.getTableView().getSelectionModel().select(this.getIndex());
                    if (bookmarkData.getFilmData() == null) {
                        FilmDataMTP filmData = new FilmDataMTP();
                        filmData.arr[3] = bookmarkData.getTitle();
                        filmData.arr[2] = bookmarkData.getTheme();
                        filmData.arr[14] = bookmarkData.getUrl();
                        FilmSaveFactory.saveFilm(bookmarkData.isAudio(), filmData);
                    } else {
                        FilmSaveFactory.saveFilm(bookmarkData.isAudio(), filmDataMTP);
                    }
                    this.getTableView().refresh();
                    this.getTableView().requestFocus();
                });
                btnBookmark.setOnAction(e -> {
                    this.getTableView().getSelectionModel().clearSelection();
                    this.getTableView().getSelectionModel().select(this.getIndex());
                    BookmarkFactory.removeBookmark(bookmarkData);
                    this.getTableView().refresh();
                    this.getTableView().requestFocus();
                    ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_BOOKMARK_CHANGED);
                });
                hbox.getChildren().addAll((Node[])new Node[]{btnPlay, btnSave, btnBookmark});
                this.setGraphic(hbox);
                TableBookmarkFactory.set(bookmarkData, this);
            }
        });
    }

    public static void set(BookmarkData bookmarkData, TableCell tableCell) {
        if (bookmarkData.getFilmData() != null) {
            if (ProgConfig.SYSTEM_MARK_GEO.get() && bookmarkData.getFilmData().isGeoBlocked()) {
                tableCell.setStyle(ProgColorList.FILM_GEOBLOCK.getCssFontBold());
            } else if (bookmarkData.getFilmData().isNewFilm()) {
                tableCell.setStyle(ProgColorList.FILM_NEW.getCssFont());
            } else {
                tableCell.setStyle("");
            }
        }
    }
}

