/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.tools.table;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.data.blackdata.BlackData;
import de.p2tools.mtplayer.gui.tools.table.PTable;
import de.p2tools.mtplayer.gui.tools.table.Table;
import de.p2tools.mtplayer.gui.tools.table.TableBlackFactory;
import de.p2tools.p2lib.guitools.P2TableFactory;
import de.p2tools.p2lib.guitools.ptable.P2CellCheckBox;
import de.p2tools.p2lib.guitools.ptable.P2CellLocalDate;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;

public class TableBlacklist
extends PTable<BlackData> {
    public TableBlacklist(Table.TABLE_ENUM table_enum) {
        super(table_enum);
        this.table_enum = table_enum;
        this.initColumn();
    }

    @Override
    public Table.TABLE_ENUM getETable() {
        return this.table_enum;
    }

    public void resetTable() {
        this.initColumn();
        Table.resetTable(this);
    }

    private void initColumn() {
        this.getColumns().clear();
        this.setTableMenuButtonVisible(true);
        this.setEditable(false);
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        ProgConfig.SYSTEM_THEME_CHANGED.addListener((u, o, n) -> P2TableFactory.refreshTable(this));
        TableColumn nrColumn = new TableColumn("Nr");
        nrColumn.setCellValueFactory(new PropertyValueFactory("no"));
        nrColumn.getStyleClass().add("alignCenterRightPadding_10");
        TableColumn activeColumn = new TableColumn("Aktiv");
        activeColumn.setCellValueFactory(new PropertyValueFactory("active"));
        activeColumn.setCellFactory(new P2CellCheckBox<S, T>().cellFactory);
        TableColumn<BlackData, Integer> listColumn = new TableColumn<BlackData, Integer>("Liste");
        listColumn.setCellValueFactory(new PropertyValueFactory("list"));
        listColumn.getStyleClass().add("alignCenter");
        TableBlackFactory.columnFactoryList(listColumn);
        TableColumn hitsColumn = new TableColumn("Treffer");
        hitsColumn.setCellValueFactory(new PropertyValueFactory("countHits"));
        hitsColumn.getStyleClass().add("alignCenterRightPadding_10");
        TableColumn channelColumn = new TableColumn("Sender");
        channelColumn.setCellValueFactory(new PropertyValueFactory("channel"));
        channelColumn.getStyleClass().add("alignCenter");
        TableColumn themeColumn = new TableColumn("Thema");
        themeColumn.setCellValueFactory(new PropertyValueFactory("theme"));
        TableColumn themeExactColumn = new TableColumn("Thema exakt");
        themeExactColumn.setCellValueFactory(new PropertyValueFactory("themeExact"));
        themeExactColumn.setCellFactory(new P2CellCheckBox<S, T>().cellFactory);
        TableColumn titleColumn = new TableColumn("Titel");
        titleColumn.setCellValueFactory(new PropertyValueFactory("title"));
        TableColumn themeTitleColumn = new TableColumn("Thema-Titel");
        themeTitleColumn.setCellValueFactory(new PropertyValueFactory("themeTitle"));
        TableColumn dateColumn = new TableColumn("Erstelldatum");
        dateColumn.setCellValueFactory(new PropertyValueFactory("genDate"));
        dateColumn.setCellFactory(new P2CellLocalDate<S, T>().cellFactory);
        this.getColumns().addAll(nrColumn, activeColumn, listColumn, hitsColumn, channelColumn, themeColumn, themeExactColumn, titleColumn, themeTitleColumn, dateColumn);
    }
}

