/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.tools.table;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.gui.tools.table.PTable;
import de.p2tools.p2lib.configfile.pdata.P2DataSample;
import de.p2tools.p2lib.tools.log.P2Log;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;

public class Table {
    private static final String SORT_ASCENDING = "ASCENDING";
    private static final String SORT_DESCENDING = "DESCENDING";
    private static String width = "";
    private static String sort = "";
    private static String upDown = "";
    private static String vis = "";
    private static String order = "";
    private static int maxSpalten;
    private static double[] breite;
    private static boolean[] visAr;
    private static TableColumn[] tArray;
    private static StringProperty confWidth;
    private static StringProperty confSort;
    private static StringProperty confUpDown;
    private static StringProperty confVis;
    private static StringProperty confOrder;

    public static void setTable(PTable table) {
        try {
            int i;
            Table.initConf(table.getETable());
            Table.initColumn(table);
            maxSpalten = table.getColumns().size();
            breite = Table.getDoubleArray(maxSpalten);
            visAr = Table.getBoolArray(maxSpalten);
            if (!((String)confWidth.get()).isEmpty() && Table.arrLesen(width = (String)confWidth.get(), breite)) {
                for (i = 0; i < breite.length; ++i) {
                    ((TableColumn)table.getColumns().get(i)).setPrefWidth(breite[i]);
                }
            }
            if (!((String)confVis.get()).isEmpty() && Table.arrLesen(vis = (String)confVis.get(), visAr)) {
                for (i = 0; i < visAr.length; ++i) {
                    ((TableColumn)table.getColumns().get(i)).setVisible(visAr[i]);
                }
            }
            if (!((String)confSort.get()).isEmpty()) {
                String sort = (String)confSort.get();
                String[] arSort = sort.split(",");
                String sortUp = (String)confUpDown.get();
                String[] arSortUp = sortUp.split(",");
                for (int i2 = 0; i2 < arSort.length; ++i2) {
                    String s = arSort[i2];
                    ObservableList l = table.getColumns();
                    TableColumn co = l.stream().filter(c -> c.getText().equals(s)).findFirst().get();
                    table.getSortOrder().add(co);
                    if (arSort.length != arSortUp.length) continue;
                    co.setSortType(arSortUp[i2].equals(SORT_ASCENDING) ? TableColumn.SortType.ASCENDING : TableColumn.SortType.DESCENDING);
                }
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(642103218, ex.getMessage());
            Table.resetTable(table);
        }
    }

    public static void saveTable(TableView table, TABLE_ENUM table_enum) {
        Table.initConf(table_enum);
        maxSpalten = table.getColumns().size();
        width = "";
        sort = "";
        upDown = "";
        vis = "";
        order = "";
        ObservableList columns = table.getColumns();
        columns.stream().forEach(c -> {
            width = width + c.getWidth() + ",";
            vis = vis + String.valueOf(c.isVisible()) + ",";
        });
        ObservableList sortOrder = table.getSortOrder();
        sortOrder.stream().forEach(so -> {
            sort = sort + so.getText() + ",";
        });
        if (table.getSortOrder().size() > 0) {
            sortOrder.stream().forEach(so -> {
                upDown = upDown + (so.getSortType().equals((Object)TableColumn.SortType.ASCENDING) ? SORT_ASCENDING : SORT_DESCENDING) + ",";
            });
        }
        columns.stream().forEach(c -> {
            order = order + c.getText() + ",";
        });
        confWidth.set(width);
        confVis.set(vis);
        confSort.set(sort);
        confUpDown.set(upDown);
        confOrder.set(order);
    }

    public static void resetTable(PTable ta) {
        Table.initConf(ta.getETable());
        Table.reset(ta);
        Table.setTable(ta);
    }

    private static void initConf(TABLE_ENUM table_enum) {
        switch (table_enum) {
            case FILM: {
                confWidth = ProgConfig.FILM_GUI_TABLE_WIDTH;
                confSort = ProgConfig.FILM_GUI_TABLE_SORT;
                confUpDown = ProgConfig.FILM_GUI_TABLE_UP_DOWN;
                confVis = ProgConfig.FILM_GUI_TABLE_VIS;
                confOrder = ProgConfig.FILM_GUI_TABLE_ORDER;
                break;
            }
            case AUDIO: {
                confWidth = ProgConfig.AUDIO_GUI_TABLE_WIDTH;
                confSort = ProgConfig.AUDIO_GUI_TABLE_SORT;
                confUpDown = ProgConfig.AUDIO_GUI_TABLE_UP_DOWN;
                confVis = ProgConfig.AUDIO_GUI_TABLE_VIS;
                confOrder = ProgConfig.AUDIO_GUI_TABLE_ORDER;
                break;
            }
            case LIVE_FILM: {
                confWidth = ProgConfig.LIVE_FILM_GUI_TABLE_WIDTH;
                confSort = ProgConfig.LIVE_FILM_GUI_TABLE_SORT;
                confUpDown = ProgConfig.LIVE_FILM_GUI_TABLE_UP_DOWN;
                confVis = ProgConfig.LIVE_FILM_GUI_TABLE_VIS;
                confOrder = ProgConfig.LIVE_FILM_GUI_TABLE_ORDER;
                break;
            }
            case DOWNLOAD: {
                confWidth = ProgConfig.DOWNLOAD_GUI_TABLE_WIDTH;
                confSort = ProgConfig.DOWNLOAD_GUI_TABLE_SORT;
                confUpDown = ProgConfig.DOWNLOAD_GUI_TABLE_UP_DOWN;
                confVis = ProgConfig.DOWNLOAD_GUI_TABLE_VIS;
                confOrder = ProgConfig.DOWNLOAD_GUI_TABLE_ORDER;
                break;
            }
            case ABO: {
                confWidth = ProgConfig.ABO_GUI_TABLE_WIDTH;
                confSort = ProgConfig.ABO_GUI_TABLE_SORT;
                confUpDown = ProgConfig.ABO_GUI_TABLE_UP_DOWN;
                confVis = ProgConfig.ABO_GUI_TABLE_VIS;
                confOrder = ProgConfig.ABO_GUI_TABLE_ORDER;
                break;
            }
            case BLACKLIST: {
                confWidth = ProgConfig.BLACKLIST_TABLE_WIDTH;
                confSort = ProgConfig.BLACKLIST_TABLE_SORT;
                confUpDown = ProgConfig.BLACKLIST_TABLE_UP_DOWN;
                confVis = ProgConfig.BLACKLIST_TABLE_VIS;
                confOrder = ProgConfig.BLACKLIST_TABLE_ORDER;
                break;
            }
            case FILMFILTER: {
                confWidth = ProgConfig.FILMFILTER_TABLE_WIDTH;
                confSort = ProgConfig.FILMFILTER_TABLE_SORT;
                confUpDown = ProgConfig.FILMFILTER_TABLE_UP_DOWN;
                confVis = ProgConfig.FILMFILTER_TABLE_VIS;
                confOrder = ProgConfig.FILMFILTER_TABLE_ORDER;
                break;
            }
            case BOOKMARK: {
                confWidth = ProgConfig.BOOKMARK_TABLE_WIDTH;
                confSort = ProgConfig.BOOKMARK_TABLE_SORT;
                confUpDown = ProgConfig.BOOKMARK_TABLE_UP_DOWN;
                confVis = ProgConfig.BOOKMARK_TABLE_VIS;
                confOrder = ProgConfig.BOOKMARK_TABLE_ORDER;
            }
        }
    }

    private static void initColumn(TableView<P2DataSample> table) {
        tArray = (TableColumn[])table.getColumns().toArray(TableColumn[]::new);
        table.getColumns().clear();
        String order = (String)confOrder.get();
        String[] arOrder = order.split(",");
        if (((String)confOrder.get()).isEmpty() || arOrder.length != tArray.length) {
            for (TableColumn tc : tArray) {
                table.getColumns().add(tc);
            }
        } else {
            for (int i = 0; i < arOrder.length; ++i) {
                String s = arOrder[i];
                for (TableColumn tc : tArray) {
                    if (!s.equals(tc.getText()) || table.getColumns().contains(tc)) continue;
                    table.getColumns().add(tc);
                }
            }
        }
        table.getColumns().stream().forEach(c -> c.setSortable(true));
        table.getColumns().stream().forEach(c -> c.setVisible(true));
    }

    private static void reset(TableView ta) {
        maxSpalten = ta.getColumns().size();
        Object set = "";
        for (int i = 0; i < maxSpalten; ++i) {
            set = (String)set + Boolean.TRUE + ",";
        }
        confVis.set(set);
        confWidth.set("");
        confSort.set("");
        confUpDown.set("");
        confOrder.set("");
    }

    private static boolean arrLesen(String s, double[] arr) {
        String[] sarr = s.split(",");
        if (maxSpalten != sarr.length) {
            return false;
        }
        for (int i = 0; i < maxSpalten; ++i) {
            try {
                arr[i] = Double.parseDouble(sarr[i]);
                continue;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    private static boolean arrLesen(String s, boolean[] arr) {
        String[] sarr = s.split(",");
        if (maxSpalten != sarr.length) {
            return false;
        }
        for (int i = 0; i < maxSpalten; ++i) {
            try {
                arr[i] = Boolean.parseBoolean(sarr[i]);
                continue;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    private static boolean arrLesen(String s, String[] arr) {
        arr = s.split(",");
        return maxSpalten == arr.length;
    }

    private static int countString(String s) {
        int ret = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != ',') continue;
            ++ret;
        }
        return ++ret;
    }

    private static double[] getDoubleArray(int anzahl) {
        double[] arr = new double[anzahl];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = -1.0;
        }
        return arr;
    }

    private static boolean[] getBoolArray(int anzahl) {
        boolean[] arr = new boolean[anzahl];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = true;
        }
        return arr;
    }

    public static enum TABLE_ENUM {
        FILM,
        AUDIO,
        LIVE_FILM,
        DOWNLOAD,
        ABO,
        BLACKLIST,
        FILMFILTER,
        BOOKMARK;

    }
}

