/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.tools.table;

import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.p2lib.tools.date.P2DateConst;
import de.p2tools.p2lib.tools.date.P2LDateTimeFactory;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class CellDownloadStartTime<S, T>
extends TableCell<S, T> {
    public final Callback<TableColumn<DownloadData, String>, TableCell<DownloadData, String>> cellFactory = param -> {
        TableCell<DownloadData, String> cell = new TableCell<DownloadData, String>(){

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                if (!item.isEmpty()) {
                    LocalDateTime ldt = P2LDateTimeFactory.fromString(item);
                    if (ldt.equals(LocalDateTime.MIN)) {
                        this.setText("");
                    } else {
                        LocalDateTime ldtTomorrow = LocalDate.now().atStartOfDay().plusDays(1L);
                        if (ldt.isEqual(ldtTomorrow) || ldt.isAfter(ldtTomorrow)) {
                            this.setText("Morgen, " + ldt.format(P2DateConst.DT_FORMATTER_HH__mm));
                        } else {
                            this.setText(ldt.format(P2DateConst.DT_FORMATTER_HH__mm));
                        }
                    }
                }
            }
        };
        return cell;
    };
}

