/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.tools.table;

import de.p2tools.mtplayer.controller.config.ProgColorList;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.data.download.DownloadConstants;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.cell.ProgressBarTableCell;
import javafx.util.Callback;

public class CellDownloadProgress<S, T>
extends TableCell<S, T> {
    public final Callback<TableColumn<DownloadData, Double>, TableCell<DownloadData, Double>> cellFactory = param -> {
        ProgressBarTableCell<DownloadData> cell = new ProgressBarTableCell<DownloadData>(){

            @Override
            public void updateItem(Double item, boolean empty) {
                super.updateItem(item, empty);
                if (item != null) {
                    DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                    if (download.isProgramDownloadmanager()) {
                        String text = DownloadConstants.getTextProgress(true, download.getState(), item);
                        Label label = new Label(text);
                        this.setGraphic(label);
                    } else if (item <= 0.001 || item >= 1.0) {
                        String text = DownloadConstants.getTextProgress(false, download.getState(), item);
                        Label label = new Label(text);
                        if (ProgConfig.SYSTEM_MARK_GEO.get() && download.getGeoBlocked()) {
                            label.setStyle(ProgColorList.FILM_GEOBLOCK.getCssFontBold());
                        }
                        this.setGraphic(label);
                    }
                }
            }
        };
        return cell;
    };
}

