/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.tools.table;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.download.DownloadFactoryStopDownload;
import de.p2tools.p2lib.guitools.P2Open;
import de.p2tools.p2lib.tools.P2GetList;
import java.util.ArrayList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.util.Callback;

public class CellDownloadButton<S, T>
extends TableCell<S, T> {
    public final Callback<TableColumn<DownloadData, Integer>, TableCell<DownloadData, Integer>> cellFactory = param -> {
        TableCell<DownloadData, Integer> cell = new TableCell<DownloadData, Integer>(){

            @Override
            public void updateItem(Integer item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                HBox hbox = new HBox();
                hbox.setSpacing(5.0);
                hbox.setAlignment(Pos.CENTER);
                hbox.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
                if (item <= 1) {
                    Button btnDownStart = new Button("");
                    btnDownStart.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnDownStart.setTooltip(new Tooltip("Download starten"));
                    btnDownStart.setGraphic(ProgIcons.IMAGE_TABLE_DOWNLOAD_START.getImageView());
                    btnDownStart.setOnAction(event -> {
                        this.getTableView().getSelectionModel().clearSelection();
                        this.getTableView().getSelectionModel().select(this.getIndex());
                        DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                        ProgData.getInstance().downloadList.startDownloads(download);
                        this.getTableView().refresh();
                        this.getTableView().requestFocus();
                    });
                    Button btnDownDel = new Button("");
                    btnDownDel.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnDownDel.setTooltip(new Tooltip("Download l\u00f6schen"));
                    btnDownDel.setGraphic(ProgIcons.IMAGE_TABLE_DOWNLOAD_DEL.getImageView());
                    btnDownDel.setOnAction(event -> {
                        this.getTableView().getSelectionModel().clearSelection();
                        this.getTableView().getSelectionModel().select(this.getIndex());
                        DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                        ProgData.getInstance().downloadList.delDownloads(download);
                        this.getTableView().refresh();
                        this.getTableView().requestFocus();
                    });
                    if (ProgConfig.SYSTEM_SMALL_TABLE_ROW_DOWNLOAD.get()) {
                        btnDownStart.setMinHeight(18.0);
                        btnDownStart.setMaxHeight(18.0);
                        btnDownDel.setMinHeight(18.0);
                        btnDownDel.setMaxHeight(18.0);
                    }
                    hbox.getChildren().addAll((Node[])new Node[]{btnDownStart, btnDownDel});
                    this.setGraphic(hbox);
                } else if (item < 4) {
                    Button btnDownStop = new Button("");
                    btnDownStop.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnDownStop.setTooltip(new Tooltip("Download stoppen"));
                    btnDownStop.setGraphic(ProgIcons.IMAGE_TABLE_DOWNLOAD_STOP.getImageView());
                    btnDownStop.setOnAction(event -> {
                        this.getTableView().getSelectionModel().clearSelection();
                        this.getTableView().getSelectionModel().select(this.getIndex());
                        DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                        DownloadFactoryStopDownload.stopDownloads(new P2GetList<DownloadData>().getArrayList(download));
                        this.getTableView().refresh();
                        this.getTableView().requestFocus();
                    });
                    Button btnDownDel = new Button("");
                    btnDownDel.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnDownDel.setTooltip(new Tooltip("Download l\u00f6schen"));
                    btnDownDel.setGraphic(ProgIcons.IMAGE_TABLE_DOWNLOAD_DEL.getImageView());
                    btnDownDel.setOnAction(event -> {
                        this.getTableView().getSelectionModel().clearSelection();
                        this.getTableView().getSelectionModel().select(this.getIndex());
                        DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                        ProgData.getInstance().downloadList.delDownloads(download);
                        this.getTableView().refresh();
                        this.getTableView().requestFocus();
                    });
                    if (ProgConfig.SYSTEM_SMALL_TABLE_ROW_DOWNLOAD.get()) {
                        btnDownStop.setMinHeight(18.0);
                        btnDownStop.setMaxHeight(18.0);
                        btnDownDel.setMinHeight(18.0);
                        btnDownDel.setMaxHeight(18.0);
                    }
                    hbox.getChildren().addAll((Node[])new Node[]{btnDownStop, btnDownDel});
                    this.setGraphic(hbox);
                } else if (item == 4) {
                    Button btnFilmStart = new Button("");
                    btnFilmStart.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnFilmStart.setTooltip(new Tooltip("Gespeicherten Film abspielen"));
                    btnFilmStart.setGraphic(ProgIcons.IMAGE_TABLE_FILM_PLAY.getImageView());
                    btnFilmStart.setOnAction(event -> {
                        this.getTableView().getSelectionModel().clearSelection();
                        this.getTableView().getSelectionModel().select(this.getIndex());
                        DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                        P2Open.playStoredFilm(download.getDestPathFile(), ProgConfig.SYSTEM_PROG_PLAY_FILME, ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
                        this.getTableView().refresh();
                        this.getTableView().requestFocus();
                    });
                    Button btnOpenDirectory = new Button();
                    btnOpenDirectory.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnOpenDirectory.setTooltip(new Tooltip("Ordner mit gespeichertem Film \u00f6ffnen"));
                    btnOpenDirectory.setGraphic(ProgIcons.IMAGE_TABLE_DOWNLOAD_OPEN_DIR.getImageView());
                    btnOpenDirectory.setOnAction(event -> {
                        this.getTableView().getSelectionModel().clearSelection();
                        this.getTableView().getSelectionModel().select(this.getIndex());
                        DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                        P2Open.openDir(download.getDestPath(), ProgConfig.SYSTEM_PROG_OPEN_DIR, ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
                        this.getTableView().refresh();
                        this.getTableView().requestFocus();
                    });
                    if (ProgConfig.SYSTEM_SMALL_TABLE_ROW_DOWNLOAD.get()) {
                        btnFilmStart.setMinHeight(18.0);
                        btnFilmStart.setMaxHeight(18.0);
                        btnOpenDirectory.setMinHeight(18.0);
                        btnOpenDirectory.setMaxHeight(18.0);
                    }
                    hbox.getChildren().addAll((Node[])new Node[]{btnFilmStart, btnOpenDirectory});
                    this.setGraphic(hbox);
                } else if (item == 5) {
                    Button btnDownStart = new Button("");
                    btnDownStart.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnDownStart.setTooltip(new Tooltip("Download wieder starten"));
                    btnDownStart.setGraphic(ProgIcons.IMAGE_TABLE_DOWNLOAD_START.getImageView());
                    btnDownStart.setOnAction(event -> {
                        this.getTableView().getSelectionModel().clearSelection();
                        this.getTableView().getSelectionModel().select(this.getIndex());
                        DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                        ArrayList<DownloadData> list = new ArrayList<DownloadData>();
                        list.add(download);
                        ProgData.getInstance().downloadList.startDownloads(list, true);
                        this.getTableView().refresh();
                        this.getTableView().requestFocus();
                    });
                    Button btnDownDel = new Button("");
                    btnDownDel.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnDownDel.setTooltip(new Tooltip("Download l\u00f6schen"));
                    btnDownDel.setGraphic(ProgIcons.IMAGE_TABLE_DOWNLOAD_DEL.getImageView());
                    btnDownDel.setOnAction(event -> {
                        this.getTableView().getSelectionModel().clearSelection();
                        this.getTableView().getSelectionModel().select(this.getIndex());
                        DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                        ProgData.getInstance().downloadList.delDownloads(download);
                        this.getTableView().refresh();
                        this.getTableView().requestFocus();
                    });
                    if (ProgConfig.SYSTEM_SMALL_TABLE_ROW_DOWNLOAD.get()) {
                        btnDownStart.setMinHeight(18.0);
                        btnDownStart.setMaxHeight(18.0);
                        btnDownDel.setMinHeight(18.0);
                        btnDownDel.setMaxHeight(18.0);
                    }
                    hbox.getChildren().addAll((Node[])new Node[]{btnDownStart, btnDownDel});
                    this.setGraphic(hbox);
                } else {
                    this.setGraphic(null);
                    this.setText(null);
                }
            }
        };
        return cell;
    };
}

