/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.tools;

import de.p2tools.mtplayer.controller.ProgQuit;
import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadInfosFactory;
import de.p2tools.mtplayer.gui.configdialog.ConfigDialogController;
import de.p2tools.mtplayer.gui.dialog.AboutDialogController;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.p2event.P2Events;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.P2InfoFactory;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2lib.tools.log.P2Logger;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.stream.Stream;
import javafx.application.Platform;

public class ProgTray {
    private final ProgData progData;
    private SystemTray systemTray = null;
    private boolean stopTimer = false;

    public ProgTray(ProgData progData) {
        this.progData = progData;
    }

    public void initProgTray() {
        ProgConfig.SYSTEM_TRAY.addListener((observableValue, aBoolean, t1) -> Platform.runLater(() -> this.setTray()));
        ProgConfig.SYSTEM_TRAY_USE_OWN_ICON.addListener((observableValue, aBoolean, t1) -> Platform.runLater(() -> this.setTray()));
        ProgConfig.SYSTEM_TRAY_ICON_PATH.addListener((observableValue, aBoolean, t1) -> Platform.runLater(() -> this.setTray()));
        ProgData.getInstance().pEventHandler.addListener(new P2Listener(P2Events.EVENT_TIMER_SECOND){

            @Override
            public void pingGui() {
                try {
                    if (!ProgTray.this.stopTimer) {
                        String toolTip = DownloadInfosFactory.getTrayInfo();
                        if (ProgTray.this.systemTray != null) {
                            ((Stream)Arrays.stream(ProgTray.this.systemTray.getTrayIcons()).sequential()).forEach(e -> e.setToolTip(toolTip));
                        }
                    }
                }
                catch (Exception ex) {
                    P2Log.errorLog(936251087, ex);
                }
            }
        });
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILMLIST_LOAD_START){

            @Override
            public void ping() {
                ProgTray.this.stopTimer = true;
            }
        });
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILMLIST_LOAD_FINISHED){

            @Override
            public void ping() {
                ProgTray.this.stopTimer = false;
            }
        });
        this.setTray();
    }

    public SystemTray getSystemTray() {
        return this.systemTray;
    }

    private void removeTray() {
        if (this.systemTray != null) {
            ((Stream)Arrays.stream(this.systemTray.getTrayIcons()).sequential()).forEach(e -> this.systemTray.remove((TrayIcon)e));
            this.systemTray = null;
        }
    }

    private void setTray() {
        if (!SystemTray.isSupported()) {
            return;
        }
        if (!ProgConfig.SYSTEM_TRAY.get()) {
            this.removeTray();
            return;
        }
        if (this.systemTray == null) {
            this.systemTray = SystemTray.getSystemTray();
        }
        this.setIcon();
    }

    private void setIcon() {
        File file;
        if (this.systemTray == null) {
            return;
        }
        for (TrayIcon tr : this.systemTray.getTrayIcons()) {
            this.systemTray.remove(tr);
        }
        Image image = null;
        if (ProgConfig.SYSTEM_TRAY_USE_OWN_ICON.getValue().booleanValue() && !ProgConfig.SYSTEM_TRAY_ICON_PATH.getValueSafe().isEmpty() && (file = new File(ProgConfig.SYSTEM_TRAY_ICON_PATH.getValueSafe())).exists()) {
            String resource = ProgConfig.SYSTEM_TRAY_ICON_PATH.getValueSafe();
            image = Toolkit.getDefaultToolkit().getImage(resource);
        }
        if (image == null) {
            URL res = ClassLoader.getSystemResource("de/p2tools/mtplayer/res/p2_logo_32.png");
            image = Toolkit.getDefaultToolkit().getImage(res);
        }
        TrayIcon trayicon = new TrayIcon(image, "MTPlayer");
        this.addMenu(trayicon);
        trayicon.setImageAutoSize(true);
        trayicon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    ProgTray.this.maxMin();
                }
            }
        });
        try {
            this.systemTray.add(trayicon);
        }
        catch (AWTException exception) {
            P2Log.errorLog(912547030, exception.getMessage());
        }
    }

    private void addMenu(TrayIcon trayicon) {
        MenuItem miMaxMin = new MenuItem("Programm maximieren/minimieren");
        MenuItem miConfig = new MenuItem("Einstellungen \u00f6ffnen");
        MenuItem miLogfile = new MenuItem("LogDatei \u00f6ffnen");
        MenuItem miTray = new MenuItem("Tray-Icon ausblenden");
        MenuItem miAbout = new MenuItem("\u00fcber dieses Programm");
        MenuItem miQuit = new MenuItem("Programm Beenden");
        miMaxMin.addActionListener(e -> Platform.runLater(() -> this.maxMin()));
        miConfig.addActionListener(e -> Platform.runLater(() -> new ConfigDialogController(ProgData.getInstance())));
        miConfig.setEnabled(ConfigDialogController.dialogIsRunning.getValue() == false);
        ConfigDialogController.dialogIsRunning.addListener((o, u, n) -> miConfig.setEnabled(ConfigDialogController.dialogIsRunning.getValue() == false));
        miLogfile.addActionListener(e -> Platform.runLater(() -> P2Logger.openLogFile()));
        miTray.addActionListener(e -> Platform.runLater(() -> this.closeTray()));
        miAbout.addActionListener(e -> Platform.runLater(() -> new AboutDialogController(this.progData).showDialog()));
        miQuit.addActionListener(e -> Platform.runLater(() -> ProgQuit.quit(false)));
        PopupMenu popupMenu = new PopupMenu();
        popupMenu.add(miMaxMin);
        popupMenu.add(miConfig);
        popupMenu.add(miLogfile);
        if (!P2InfoFactory.getOs().equals((Object)P2InfoFactory.OperatingSystemType.MAC)) {
            popupMenu.add(miTray);
        }
        popupMenu.addSeparator();
        popupMenu.add(miAbout);
        if (!P2InfoFactory.getOs().equals((Object)P2InfoFactory.OperatingSystemType.MAC)) {
            popupMenu.addSeparator();
            popupMenu.add(miQuit);
        }
        trayicon.setPopupMenu(popupMenu);
    }

    private void closeTray() {
        this.showDialog();
        ProgConfig.SYSTEM_TRAY.setValue(false);
    }

    private synchronized void maxMin() {
        if (this.progData.primaryStage.isShowing()) {
            this.hideDialog();
        } else {
            this.showDialog();
        }
    }

    public void hideDialog() {
        Platform.runLater(() -> this.progData.primaryStage.hide());
        P2DialogExtra.hideAllDialog();
    }

    private void showDialog() {
        Platform.runLater(() -> this.progData.primaryStage.show());
        P2DialogExtra.showAllDialog();
    }
}

