/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.tools;

import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.mediathek.filmdata.FilmDataXml;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class MTInfoFile {
    public static void writeInfoFile(DownloadData download) {
        if (download.getDestPath().isEmpty()) {
            P2Alert.showErrorAlert("Info File anlegen", "Kann die Info-Datei nicht anlegen.");
            return;
        }
        P2Log.sysLog(new String[]{"Infofile schreiben nach: ", download.getDestPath()});
        new File(download.getDestPath()).mkdirs();
        Path path = MTInfoFile.getInfoFilePath(download);
        if (path == null) {
            return;
        }
        try (DataOutputStream dos = new DataOutputStream(Files.newOutputStream(path, new OpenOption[0]));
             OutputStreamWriter osw = new OutputStreamWriter(dos);
             BufferedWriter br = new BufferedWriter(osw);){
            br.write(FilmDataXml.COLUMN_NAMES[1] + ":        " + download.getChannel());
            br.write(P2LibConst.LINE_SEPARATOR);
            br.write(FilmDataXml.COLUMN_NAMES[2] + ":         " + download.getTheme());
            br.write(P2LibConst.LINE_SEPARATORx2);
            br.write(FilmDataXml.COLUMN_NAMES[3] + ":         " + download.getTitle());
            br.write(P2LibConst.LINE_SEPARATORx2);
            br.write(FilmDataXml.COLUMN_NAMES[6] + ":         " + download.getFilmDate().toString());
            br.write(P2LibConst.LINE_SEPARATOR);
            br.write(FilmDataXml.COLUMN_NAMES[7] + ":          " + download.getFilmTime());
            br.write(P2LibConst.LINE_SEPARATOR);
            br.write(FilmDataXml.COLUMN_NAMES[8] + ":   " + download.getDurationMinute());
            if (!download.getDownloadSize().toString().isEmpty()) {
                br.write(P2LibConst.LINE_SEPARATOR);
                br.write("Gr\u00f6\u00dfe [MB]:    " + String.valueOf(download.getDownloadSize()));
            }
            br.write(P2LibConst.LINE_SEPARATORx2);
            br.write(FilmDataXml.COLUMN_NAMES[15] + P2LibConst.LINE_SEPARATOR);
            br.write(download.getUrlWebsite());
            br.write(P2LibConst.LINE_SEPARATORx2);
            br.write("Url" + P2LibConst.LINE_SEPARATOR);
            br.write(download.getUrl());
            br.write(P2LibConst.LINE_SEPARATORx2);
            int anz = 0;
            for (String s : download.getDescription().split(" ")) {
                br.write(s + " ");
                if ((anz += s.length()) <= 50) continue;
                br.write(P2LibConst.LINE_SEPARATOR);
                anz = 0;
            }
            br.write(P2LibConst.LINE_SEPARATORx2);
            br.flush();
            P2Log.sysLog(new String[]{"Infofile", "  geschrieben"});
        }
        catch (IOException ex) {
            P2Log.errorLog(975410369, download.getDestPathFile());
        }
    }

    private static String getInfoFileStr(DownloadData download) {
        return download.getPathFileNameWithoutSuffix() + ".txt";
    }

    public static Path getInfoFilePath(DownloadData download) {
        Path path;
        try {
            path = Paths.get(MTInfoFile.getInfoFileStr(download), new String[0]);
        }
        catch (Exception ex) {
            path = null;
            P2Log.errorLog(987451202, "InfofilePath");
        }
        return path;
    }
}

