/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.startdialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.p2lib.dialogs.dialog.P2Dialog;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class StartPaneUpdate {
    private final P2Dialog pDialog;
    private final P2ToggleSwitch tglSearch = new P2ToggleSwitch("einmal am Tag nach einer neuen Programmversion suchen");

    public StartPaneUpdate(P2Dialog pDialog) {
        this.pDialog = pDialog;
    }

    public void close() {
        this.tglSearch.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_SEARCH_UPDATE);
    }

    public TitledPane makeStart() {
        VBox vBox = new VBox(10.0);
        HBox hBox = new HBox();
        hBox.getStyleClass().add("extra-pane");
        hBox.setPadding(new Insets(10.0));
        hBox.setMaxWidth(Double.MAX_VALUE);
        hBox.setMinHeight(Double.NEGATIVE_INFINITY);
        Label lbl = new Label("Das Programm kann einmal t\u00e4glich nach einem Update suchen. Gibt es eins, wird dar\u00fcber informiert und es kann geladen werden. Es wird nichts automatisch ge\u00e4ndert.");
        lbl.setWrapText(true);
        lbl.setPrefWidth(500.0);
        hBox.getChildren().add(lbl);
        vBox.getChildren().addAll((Node[])new Node[]{P2GuiTools.getVDistance(5), hBox, P2GuiTools.getVDistance(20)});
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        this.tglSearch.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_SEARCH_UPDATE);
        Button btnHelp = P2Button.helpButton(this.pDialog.getStage(), "Programmupdate suchen", "Beim Programmstart wird gepr\u00fcft, ob es eine neue Version des Programms gibt. Wenn es eine neue Version gibt, wird das mit einer Nachricht mitgeteilt. Es wird nicht automatisch das Programm ver\u00e4ndert.");
        gridPane.add(this.tglSearch, 0, 0);
        gridPane.add(btnHelp, 1, 0);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        vBox.getChildren().add(gridPane);
        return new TitledPane("Programmupdate", vBox);
    }
}

