/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.startdialog;

import de.p2tools.mtplayer.controller.config.ProgColorList;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.setdata.SetFactory;
import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.P2Hyperlink;
import de.p2tools.p2lib.tools.P2InfoFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.StringProperty;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class StartPanePath {
    private final GridPane gridPane = new GridPane();
    private int row = 0;
    private final Stage stage;
    private final List<UnBind> unbindList = new ArrayList<UnBind>();

    public StartPanePath(Stage stage) {
        this.stage = stage;
    }

    public void close() {
        this.unbindList.forEach(UnBind::unbind);
    }

    public TitledPane makePath() {
        VBox vBox = new VBox(10.0);
        HBox hBox = new HBox();
        hBox.getStyleClass().add("extra-pane");
        hBox.setPadding(new Insets(10.0));
        hBox.setMaxWidth(Double.MAX_VALUE);
        hBox.setMinHeight(Double.NEGATIVE_INFINITY);
        Label lbl = new Label("Diese Programme werden zum Abspielen der Filme und zum Download der Filme gebraucht. Wird der Pfad nicht automatisch erkannt, muss er hier ausgew\u00e4hlt werden.");
        lbl.setWrapText(true);
        lbl.setPrefWidth(500.0);
        hBox.getChildren().add(lbl);
        vBox.getChildren().addAll((Node[])new Node[]{P2GuiTools.getVDistance(5), hBox, P2GuiTools.getVDistance(20)});
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        switch (P2InfoFactory.getOs()) {
            case WIN32: 
            case WIN64: {
                this.addPlayer(PLAYER.VLC);
                break;
            }
            default: {
                this.addPlayer(PLAYER.VLC);
                this.gridPane.add(new Label(" "), 0, ++this.row);
                ++this.row;
                this.addPlayer(PLAYER.FFMPEG);
            }
        }
        Button btnHelp = P2Button.helpButton(this.stage, "Videoplayer", "Hier k\u00f6nnen Standardprogramme zum Ansehen und Aufzeichnen der Filme eingetragen werden.\n\nEs m\u00fcssen mindestens diese Programme installiert sein:\nVLC -- zum Ansehen der Filme\nffmpeg -- zum Aufzeichnen von Playlisten (URL endet mit 'm3u8')\n\nWenn die Pfade nicht automatisch erkannt wurden kann man sie auch per Hand ausw\u00e4hlen.\n\nInstallation unter Linux:\nAm einfachsten \u00fcber die Paketverwaltung.\n\nInstallation unter Windows:\nMTPlayer enth\u00e4lt bereits ffmpeg, es kann aber auch separat installiert werden.\nVLC muss aus dem Internet geladen werden.\n\nDownloadquellen:\nhttp://www.videolan.org\nhttp://ffmpeg.org\n");
        this.gridPane.add(btnHelp, 2, ++this.row);
        GridPane.setHalignment(btnHelp, HPos.RIGHT);
        vBox.getChildren().add(this.gridPane);
        return new TitledPane("Programmpfade", vBox);
    }

    private void addPlayer(PLAYER player) {
        StringProperty property;
        Text text;
        TextField txtPlayer = new TextField();
        Button btnFind = new Button("suchen");
        P2Hyperlink hyperlink = switch (player) {
            case PLAYER.FFMPEG -> {
                text = new Text("Pfad zum ffmpeg-Player ausw\u00e4hlen");
                text.getStyleClass().add("downloadGuiMediaText");
                property = ProgConfig.SYSTEM_PATH_FFMPEG;
                btnFind.setOnAction(event -> {
                    ProgConfig.SYSTEM_PATH_FFMPEG.setValue("");
                    txtPlayer.setText(SetFactory.getTemplatePathFFmpeg());
                });
                yield new P2Hyperlink(this.stage, "https://ffmpeg.org", ProgConfig.SYSTEM_PROG_OPEN_URL);
            }
            default -> {
                text = new Text("Pfad zum VLC-Player ausw\u00e4hlen");
                text.getStyleClass().add("downloadGuiMediaText");
                property = ProgConfig.SYSTEM_PATH_VLC;
                btnFind.setOnAction(event -> {
                    ProgConfig.SYSTEM_PATH_VLC.setValue("");
                    txtPlayer.setText(SetFactory.getTemplatePathVlc());
                });
                yield new P2Hyperlink(this.stage, "https://www.videolan.org", ProgConfig.SYSTEM_PROG_OPEN_URL);
            }
        };
        text.setStyle("-fx-font-weight: bold");
        txtPlayer.textProperty().addListener((observable2, oldValue, newValue) -> {
            File file = new File(txtPlayer.getText());
            if (txtPlayer.getText().isEmpty() || !file.exists() || !file.isFile()) {
                txtPlayer.setStyle(ProgColorList.DOWNLOAD_NAME_ERROR.getCssBackground());
            } else {
                txtPlayer.setStyle("");
            }
        });
        txtPlayer.textProperty().bindBidirectional(property);
        if (txtPlayer.getText().isEmpty()) {
            txtPlayer.setStyle(ProgColorList.DOWNLOAD_NAME_ERROR.getCssBackground());
        }
        this.unbindList.add(new UnBind(txtPlayer, property));
        Button btnFile = new Button();
        btnFile.setOnAction(event -> P2DirFileChooser.FileChooserOpenFile(this.stage, txtPlayer));
        btnFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        btnFile.setTooltip(new Tooltip("Programmdatei ausw\u00e4hlen"));
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.getChildren().addAll((Node[])new Node[]{new Label("Website"), hyperlink});
        this.gridPane.add(text, 0, this.row);
        this.gridPane.add(txtPlayer, 0, ++this.row);
        this.gridPane.add(btnFile, 1, this.row);
        this.gridPane.add(btnFind, 2, this.row);
        this.gridPane.add(hBox, 0, ++this.row, 3, 1);
    }

    private static enum PLAYER {
        VLC,
        FFMPEG;

    }

    private static class UnBind {
        private final TextField txt;
        private final StringProperty property;

        UnBind(TextField txt, StringProperty property) {
            this.txt = txt;
            this.property = property;
        }

        void unbind() {
            this.txt.textProperty().unbindBidirectional(this.property);
        }
    }
}

