/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.startdialog;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.gui.startdialog.StartPane;
import de.p2tools.mtplayer.gui.startdialog.StartPaneColorMode;
import de.p2tools.mtplayer.gui.startdialog.StartPaneDownloadPath;
import de.p2tools.mtplayer.gui.startdialog.StartPaneFilm;
import de.p2tools.mtplayer.gui.startdialog.StartPaneGeo;
import de.p2tools.mtplayer.gui.startdialog.StartPanePath;
import de.p2tools.mtplayer.gui.startdialog.StartPaneStation;
import de.p2tools.mtplayer.gui.startdialog.StartPaneUpdate;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2Button;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;

public class StartDialogController
extends P2DialogExtra {
    private boolean ok = false;
    private Button btnOk;
    private Button btnCancel;
    private Button btnPrev;
    private Button btnNext;
    private final Button btnStart1 = new Button("Infos");
    private final Button btnStart2 = new Button("Infos");
    private final Button btnColorMode = new Button("Farbe");
    private final Button btnUpdate = new Button("Update");
    private final Button btnGeo = new Button("Geo");
    private final Button btnFilm = new Button("Filme");
    private final Button btnStation = new Button("Sender");
    private final Button btnDown = new Button("Ziel");
    private final Button btnPath = new Button("Pfade");
    private static final String STR_START_1 = "Infos";
    private static final String STR_START_2 = "Infos";
    private static final String STR_COLOR_MODE = "Farbe";
    private static final String STR_UPDATE = "Update";
    private static final String STR_GEO = "Geo";
    private static final String STR_FILM = "Filme";
    private static final String STR_STATION = "Sender";
    private static final String STR_DOWN = "Ziel";
    private static final String STR_PATH = "Pfade";
    private State aktState = State.START_1;
    private TitledPane tStart1;
    private TitledPane tStart2;
    private TitledPane tColorMode;
    private TitledPane tUpdate;
    private TitledPane tGeo;
    private TitledPane tFilm;
    private TitledPane tStation;
    private TitledPane tDown;
    private TitledPane tPath;
    private StartPane startPane1;
    private StartPane startPane2;
    private StartPaneColorMode startPaneColorMode;
    private StartPaneUpdate startPaneUpdate;
    private StartPaneGeo paneGeo;
    private StartPaneFilm startPaneFilm;
    private StartPaneStation startPaneStation;
    private StartPaneDownloadPath startPaneDownloadPath;
    private StartPanePath startPanePath;

    public StartDialogController() {
        super(null, null, "Starteinstellungen", true, false);
        ProgData progData = ProgData.getInstance();
        this.init(true);
    }

    @Override
    public void make() {
        this.initTopButton();
        this.initStack();
        this.initButton();
        this.initTooltip();
        this.selectActPane();
    }

    private void closeDialog(boolean ok) {
        this.ok = ok;
        this.startPane1.close();
        this.startPane2.close();
        this.startPaneColorMode.close();
        this.startPaneUpdate.close();
        this.paneGeo.close();
        this.startPaneFilm.close();
        this.startPaneStation.close();
        this.startPaneDownloadPath.close();
        this.startPanePath.close();
        super.close();
    }

    public boolean isOk() {
        return this.ok;
    }

    private void initTopButton() {
        TilePane tilePane1 = new TilePane();
        tilePane1.setAlignment(Pos.CENTER);
        tilePane1.setHgap(10.0);
        tilePane1.setVgap(10.0);
        this.getVBoxCont().getChildren().add(tilePane1);
        TilePane tilePane2 = new TilePane();
        tilePane2.setAlignment(Pos.CENTER);
        tilePane2.setHgap(10.0);
        tilePane2.setVgap(10.0);
        this.getVBoxCont().getChildren().add(tilePane2);
        tilePane1.getChildren().addAll((Node[])new Node[]{this.btnStart1, this.btnStart2});
        tilePane2.getChildren().addAll((Node[])new Node[]{this.btnColorMode, this.btnUpdate, this.btnGeo, this.btnFilm, this.btnStation, this.btnDown, this.btnPath});
        this.initTopButton(this.btnStart1, State.START_1);
        this.initTopButton(this.btnStart2, State.START_2);
        this.initTopButton(this.btnColorMode, State.COLOR_MODE);
        this.initTopButton(this.btnUpdate, State.UPDATE);
        this.initTopButton(this.btnGeo, State.GEO);
        this.initTopButton(this.btnFilm, State.FILM);
        this.initTopButton(this.btnStation, State.STATION);
        this.initTopButton(this.btnDown, State.DOWN);
        this.initTopButton(this.btnPath, State.PATH);
    }

    private void initTopButton(Button btn, State state) {
        btn.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncStartDialog"});
        btn.setAlignment(Pos.CENTER);
        btn.setMaxWidth(Double.MAX_VALUE);
        btn.setOnAction(a -> {
            this.aktState = state;
            this.selectActPane();
        });
    }

    private void initStack() {
        StackPane stackpane = new StackPane();
        VBox.setVgrow(stackpane, Priority.ALWAYS);
        this.getVBoxCont().getChildren().add(stackpane);
        this.startPane1 = new StartPane();
        this.tStart1 = this.startPane1.makeStart1();
        this.tStart1.setMaxHeight(Double.MAX_VALUE);
        this.tStart1.setCollapsible(false);
        this.startPane2 = new StartPane();
        this.tStart2 = this.startPane2.makeStart2();
        this.tStart2.setMaxHeight(Double.MAX_VALUE);
        this.tStart2.setCollapsible(false);
        this.startPaneColorMode = new StartPaneColorMode(this.getStage());
        this.tColorMode = this.startPaneColorMode.make();
        this.tColorMode.setMaxHeight(Double.MAX_VALUE);
        this.tColorMode.setCollapsible(false);
        this.startPaneUpdate = new StartPaneUpdate(this);
        this.tUpdate = this.startPaneUpdate.makeStart();
        this.tUpdate.setMaxHeight(Double.MAX_VALUE);
        this.tUpdate.setCollapsible(false);
        this.paneGeo = new StartPaneGeo(this.getStage());
        this.tGeo = this.paneGeo.make();
        this.tGeo.setMaxHeight(Double.MAX_VALUE);
        this.tGeo.setCollapsible(false);
        this.startPaneFilm = new StartPaneFilm(this.getStage());
        this.tFilm = this.startPaneFilm.make();
        this.tFilm.setMaxHeight(Double.MAX_VALUE);
        this.tFilm.setCollapsible(false);
        this.startPaneStation = new StartPaneStation(this.getStage());
        this.tStation = this.startPaneStation.make();
        this.tStation.setMaxHeight(Double.MAX_VALUE);
        this.tStation.setCollapsible(false);
        this.startPaneDownloadPath = new StartPaneDownloadPath(this.getStage());
        this.tDown = this.startPaneDownloadPath.makePath();
        this.tDown.setMaxHeight(Double.MAX_VALUE);
        this.tDown.setCollapsible(false);
        this.startPanePath = new StartPanePath(this.getStage());
        this.tPath = this.startPanePath.makePath();
        this.tPath.setMaxHeight(Double.MAX_VALUE);
        this.tPath.setCollapsible(false);
        stackpane.getChildren().addAll((Node[])new Node[]{this.tStart1, this.tStart2, this.tColorMode, this.tUpdate, this.tGeo, this.tFilm, this.tStation, this.tDown, this.tPath});
    }

    private void initButton() {
        this.btnOk = new Button("_Ok");
        this.btnOk.setDisable(true);
        this.btnOk.setOnAction(a -> this.closeDialog(true));
        this.btnCancel = new Button("_Abbrechen");
        this.btnCancel.setOnAction(a -> this.closeDialog(false));
        this.btnNext = P2Button.getButton(ProgIcons.ICON_BUTTON_NEXT.getImageView(), "n\u00e4chste Seite");
        this.btnNext.setOnAction(event -> {
            switch (this.aktState) {
                case START_1: {
                    this.aktState = State.START_2;
                    break;
                }
                case START_2: {
                    this.aktState = State.COLOR_MODE;
                    break;
                }
                case COLOR_MODE: {
                    this.aktState = State.UPDATE;
                    break;
                }
                case UPDATE: {
                    this.aktState = State.GEO;
                    break;
                }
                case GEO: {
                    this.aktState = State.FILM;
                    break;
                }
                case FILM: {
                    this.aktState = State.STATION;
                    break;
                }
                case STATION: {
                    this.aktState = State.DOWN;
                    break;
                }
                case DOWN: {
                    this.aktState = State.PATH;
                    break;
                }
            }
            this.selectActPane();
        });
        this.btnPrev = P2Button.getButton(ProgIcons.ICON_BUTTON_PREV.getImageView(), "vorherige Seite");
        this.btnPrev.setOnAction(event -> {
            switch (this.aktState) {
                case START_1: {
                    break;
                }
                case START_2: {
                    this.aktState = State.START_1;
                    break;
                }
                case COLOR_MODE: {
                    this.aktState = State.START_2;
                    break;
                }
                case UPDATE: {
                    this.aktState = State.COLOR_MODE;
                    break;
                }
                case GEO: {
                    this.aktState = State.UPDATE;
                    break;
                }
                case FILM: {
                    this.aktState = State.GEO;
                    break;
                }
                case STATION: {
                    this.aktState = State.FILM;
                    break;
                }
                case DOWN: {
                    this.aktState = State.STATION;
                    break;
                }
                case PATH: {
                    this.aktState = State.DOWN;
                }
            }
            this.selectActPane();
        });
        this.addOkCancelButtons(this.btnOk, this.btnCancel);
        ButtonBar.setButtonData(this.btnPrev, ButtonBar.ButtonData.BACK_PREVIOUS);
        ButtonBar.setButtonData(this.btnNext, ButtonBar.ButtonData.NEXT_FORWARD);
        this.addAnyButton(this.btnNext);
        this.addAnyButton(this.btnPrev);
        this.getButtonBar().setButtonOrder("BX+CO");
    }

    private void selectActPane() {
        switch (this.aktState) {
            case START_1: {
                this.btnPrev.setDisable(true);
                this.btnNext.setDisable(false);
                this.tStart1.toFront();
                this.setButtonStyle(this.btnStart1);
                break;
            }
            case START_2: {
                this.btnPrev.setDisable(false);
                this.btnNext.setDisable(false);
                this.tStart2.toFront();
                this.setButtonStyle(this.btnStart2);
                break;
            }
            case COLOR_MODE: {
                this.btnPrev.setDisable(false);
                this.btnNext.setDisable(false);
                this.tColorMode.toFront();
                this.setButtonStyle(this.btnColorMode);
                break;
            }
            case UPDATE: {
                this.btnPrev.setDisable(false);
                this.btnNext.setDisable(false);
                this.tUpdate.toFront();
                this.setButtonStyle(this.btnUpdate);
                break;
            }
            case GEO: {
                this.btnPrev.setDisable(false);
                this.btnNext.setDisable(false);
                this.tGeo.toFront();
                this.setButtonStyle(this.btnGeo);
                break;
            }
            case FILM: {
                this.btnPrev.setDisable(false);
                this.btnNext.setDisable(false);
                this.tFilm.toFront();
                this.setButtonStyle(this.btnFilm);
                break;
            }
            case STATION: {
                this.btnPrev.setDisable(false);
                this.btnNext.setDisable(false);
                this.tStation.toFront();
                this.setButtonStyle(this.btnStation);
                break;
            }
            case DOWN: {
                this.btnPrev.setDisable(false);
                this.btnNext.setDisable(false);
                this.tDown.toFront();
                this.setButtonStyle(this.btnDown);
                break;
            }
            case PATH: {
                this.btnPrev.setDisable(false);
                this.btnNext.setDisable(true);
                this.btnOk.setDisable(false);
                this.tPath.toFront();
                this.setButtonStyle(this.btnPath);
                break;
            }
            default: {
                this.btnOk.setDisable(false);
            }
        }
    }

    private void setButtonStyle(Button btnSel) {
        this.btnStart1.getStyleClass().setAll((String[])new String[]{"btnFunction", "btnFuncStartDialog"});
        this.btnStart2.getStyleClass().setAll((String[])new String[]{"btnFunction", "btnFuncStartDialog"});
        this.btnColorMode.getStyleClass().setAll((String[])new String[]{"btnFunction", "btnFuncStartDialog"});
        this.btnUpdate.getStyleClass().setAll((String[])new String[]{"btnFunction", "btnFuncStartDialog"});
        this.btnGeo.getStyleClass().setAll((String[])new String[]{"btnFunction", "btnFuncStartDialog"});
        this.btnFilm.getStyleClass().setAll((String[])new String[]{"btnFunction", "btnFuncStartDialog"});
        this.btnStation.getStyleClass().setAll((String[])new String[]{"btnFunction", "btnFuncStartDialog"});
        this.btnDown.getStyleClass().setAll((String[])new String[]{"btnFunction", "btnFuncStartDialog"});
        this.btnPath.getStyleClass().setAll((String[])new String[]{"btnFunction", "btnFuncStartDialog"});
        btnSel.getStyleClass().setAll((String[])new String[]{"btnFunction", "btnFuncStartDialogSel"});
    }

    private void initTooltip() {
        this.btnStart1.setTooltip(new Tooltip("Infos \u00fcber das Programm"));
        this.btnStart2.setTooltip(new Tooltip("Infos \u00fcber das Programm"));
        this.btnColorMode.setTooltip(new Tooltip("Wie soll die Programmoberfl\u00e4che aussehen?"));
        this.btnUpdate.setTooltip(new Tooltip("Soll das Programm nach Updates suchen?"));
        this.btnGeo.setTooltip(new Tooltip("Einstellung des eigenen Standorts\nund der Markierung geblockter Filme"));
        this.btnFilm.setTooltip(new Tooltip("Damit kann man die Gr\u00f6\u00dfe der\nFilmliste reduzieren und damit die Geschwindigkeit\ndes Programms auf langsamen Rechnern verbessern"));
        this.btnStation.setTooltip(new Tooltip("Damit kann man die Gr\u00f6\u00dfe der\nFilmliste reduzieren und damit die Geschwindigkeit\ndes Programms auf langsamen Rechnern verbessern"));
        this.btnDown.setTooltip(new Tooltip("Auswahl des Verzeichnis zum Speichern der Filme"));
        this.btnPath.setTooltip(new Tooltip("Angabe von Programmen zum Ansehen\nund Speichern der Filme"));
        this.btnOk.setTooltip(new Tooltip("Programm mit den gew\u00e4hlten Einstellungen starten"));
        this.btnCancel.setTooltip(new Tooltip("Das Programm nicht einrichten\nund starten sondern Dialog wieder beenden"));
        this.btnNext.setTooltip(new Tooltip("N\u00e4chste Einstellm\u00f6glichkeit"));
        this.btnPrev.setTooltip(new Tooltip("Vorherige Einstellm\u00f6glichkeit"));
    }

    private static enum State {
        START_1,
        START_2,
        COLOR_MODE,
        UPDATE,
        GEO,
        FILM,
        STATION,
        DOWN,
        PATH;

    }
}

