/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.mediadialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.mediadb.MediaData;
import de.p2tools.mtplayer.controller.mediadb.MediaDataWorker;
import de.p2tools.mtplayer.controller.mediadb.MediaSearchPredicateFactory;
import de.p2tools.mtplayer.gui.mediaSearch.MediaDataDto;
import de.p2tools.mtplayer.gui.mediadialog.PaneDialogScrollPane;
import de.p2tools.mtplayer.gui.mediadialog.PaneMediaContextMenu;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2Open;
import de.p2tools.p2lib.guitools.ptable.P2CellCheckBox;
import de.p2tools.p2lib.tools.file.P2FileUtils;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseButton;
import javafx.stage.Stage;

public class PaneDialogMedia
extends PaneDialogScrollPane {
    private final Stage stage;
    private final FilteredList<MediaData> filteredList;
    private final SortedList<MediaData> sortedList;
    private final ProgData progData = ProgData.getInstance();
    private final MediaDataDto mediaDataDto;

    public PaneDialogMedia(Stage stage, MediaDataDto mediaDataDto) {
        super(mediaDataDto);
        this.mediaDataDto = mediaDataDto;
        this.stage = stage;
        this.filteredList = new FilteredList<MediaData>(this.progData.mediaDataList, p -> true);
        this.sortedList = new SortedList<MediaData>((ObservableList<MediaData>)this.filteredList);
    }

    @Override
    public void close() {
        this.progData.mediaDataList.sizeProperty().removeListener(this.sizeListener);
        this.progress.visibleProperty().unbind();
        this.btnCreateMediaDB.disableProperty().unbind();
    }

    @Override
    void initTable() {
        this.tableMedia.setMinHeight(200.0);
        this.tableMedia.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tableMedia.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        this.tableMedia.setEditable(true);
        TableColumn nameColumn = new TableColumn("Name");
        nameColumn.setCellValueFactory(new PropertyValueFactory("name"));
        TableColumn pathColumn = new TableColumn("Pfad");
        pathColumn.setCellValueFactory(new PropertyValueFactory("path"));
        TableColumn sizeColumn = new TableColumn("Gr\u00f6\u00dfe [MB]");
        sizeColumn.setCellValueFactory(new PropertyValueFactory("size"));
        sizeColumn.getStyleClass().add("alignCenterRightPadding_25");
        TableColumn externalColumn = new TableColumn("extern");
        externalColumn.setCellValueFactory(new PropertyValueFactory("external"));
        externalColumn.setCellFactory(new P2CellCheckBox<S, T>().cellFactory);
        nameColumn.prefWidthProperty().bind(this.tableMedia.widthProperty().multiply(0.45));
        pathColumn.prefWidthProperty().bind(this.tableMedia.widthProperty().multiply(0.3));
        sizeColumn.prefWidthProperty().bind(this.tableMedia.widthProperty().multiply(0.1));
        externalColumn.prefWidthProperty().bind(this.tableMedia.widthProperty().multiply(0.1));
        this.tableMedia.getColumns().addAll(nameColumn, pathColumn, sizeColumn, externalColumn);
        this.tableMedia.getSelectionModel().selectedItemProperty().addListener((observableValue, dataOld, dataNew) -> this.setTableSel((MediaData)dataNew));
        this.tableMedia.setOnMousePressed(m -> {
            if (this.tableMedia.getItems().isEmpty()) {
                return;
            }
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                MediaData mediaData = (MediaData)this.tableMedia.getSelectionModel().getSelectedItem();
                if (mediaData == null) {
                    P2Alert.showInfoNoSelection(this.stage);
                } else {
                    ContextMenu contextMenu = new PaneMediaContextMenu(this.stage, mediaData).getContextMenu();
                    this.tableMedia.setContextMenu(contextMenu);
                }
            }
        });
        this.tableMedia.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.hoverProperty().addListener(observable2 -> {
                MediaData mediaData = (MediaData)row.getItem();
                if (row.isHover() && mediaData != null) {
                    this.setTableSel(mediaData);
                } else {
                    this.setTableSel((MediaData)this.tableMedia.getSelectionModel().getSelectedItem());
                }
            });
            return row;
        });
        this.sortedList.comparatorProperty().bind(this.tableMedia.comparatorProperty());
        this.tableMedia.setItems(this.sortedList);
    }

    private void setTableSel(MediaData mediaData) {
        if (mediaData != null) {
            this.txtPathMedia.setText(mediaData.getPath());
            this.txtTitleMedia.setText(mediaData.getName());
        } else {
            this.txtPathMedia.setText("");
            this.txtTitleMedia.setText("");
        }
    }

    @Override
    void initAction() {
        super.initAction();
        this.lblGesamtMedia.setText("" + this.progData.mediaDataList.size());
        this.sizeListener = (observable2, oldValue, newValue) -> Platform.runLater(() -> this.lblGesamtMedia.setText("" + this.progData.mediaDataList.size()));
        this.progData.mediaDataList.sizeProperty().addListener(this.sizeListener);
        this.progress.visibleProperty().bind(this.progData.mediaDataList.searchingProperty());
        this.btnCreateMediaDB.disableProperty().bind(this.progData.mediaDataList.searchingProperty());
        this.btnCreateMediaDB.setOnAction(e -> MediaDataWorker.createMediaDb());
        this.btnOpen.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        this.btnOpen.setTooltip(new Tooltip("Ausgew\u00e4hlten Pfad im Dateimanager \u00f6ffnen"));
        this.btnOpen.setOnAction(e -> this.open());
        this.btnOpen.disableProperty().bind(this.txtPathMedia.textProperty().isEmpty().and(this.txtTitleMedia.textProperty().isEmpty()));
        this.btnPlay.setGraphic(ProgIcons.ICON_BUTTON_PLAY.getImageView());
        this.btnPlay.setTooltip(new Tooltip("Ausgew\u00e4hlten Film abspielen"));
        this.btnPlay.setOnAction(e -> this.play());
        this.btnPlay.disableProperty().bind(this.txtPathMedia.textProperty().isEmpty().and(this.txtTitleMedia.textProperty().isEmpty()));
    }

    @Override
    public void filter() {
        this.filteredList.setPredicate(MediaSearchPredicateFactory.getPredicateMediaData(this.mediaDataDto.searchInWhat, this.txtSearch.getText()));
        this.lblHits.setText("" + this.filteredList.size());
    }

    private void play() {
        String path = this.txtPathMedia.getText();
        String name = this.txtTitleMedia.getText();
        if (!name.isEmpty() && !path.isEmpty()) {
            P2Open.playStoredFilm(P2FileUtils.addsPath(path, name), ProgConfig.SYSTEM_PROG_PLAY_FILME, ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        }
    }

    private void open() {
        String s = this.txtPathMedia.getText();
        P2Open.openDir(s, ProgConfig.SYSTEM_PROG_OPEN_DIR, ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
    }
}

