/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.mediadialog;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.history.HistoryData;
import de.p2tools.mtplayer.controller.data.history.HistoryList;
import de.p2tools.mtplayer.controller.mediadb.MediaSearchPredicateFactory;
import de.p2tools.mtplayer.gui.mediaSearch.MediaDataDto;
import de.p2tools.mtplayer.gui.mediadialog.PaneDialogScrollPane;
import de.p2tools.mtplayer.gui.mediadialog.PaneHistoryContextMenu;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2RowFactory;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseButton;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class PaneDialogAbo
extends PaneDialogScrollPane {
    private final HistoryList historyList;
    private final Stage stage;
    private final FilteredList<HistoryData> filteredList;
    private final SortedList<HistoryData> sortedList;
    private ProgData progData = ProgData.getInstance();

    public PaneDialogAbo(Stage stage, MediaDataDto mediaDataDto) {
        super(mediaDataDto);
        this.stage = stage;
        if (mediaDataDto.whatToShow == MediaDataDto.SHOW_WHAT.SHOW_ABO) {
            this.historyList = this.progData.historyListAbos;
            this.textSearch.setFont(Font.font(null, FontWeight.BOLD, -1.0));
            this.textSearch.getStyleClass().add("downloadGuiMediaText");
            this.textSearch = new Text("Abos, suchen im: " + (mediaDataDto.searchInWhat.getValue() == 1 ? "Titel des Abos" : "Thema oder Titel des Abos"));
            mediaDataDto.searchInWhat.addListener((u, o, n) -> this.textSearch.setText("Abos, suchen im: " + (mediaDataDto.searchInWhat.getValue() == 1 ? "Titel des Abos" : "Thema oder Titel des Abos")));
        } else {
            this.historyList = this.progData.historyList;
            this.textSearch.setFont(Font.font(null, FontWeight.BOLD, -1.0));
            this.textSearch.getStyleClass().add("downloadGuiMediaText");
            this.textSearch = new Text("History, suchen im: " + (mediaDataDto.searchInWhat.getValue() == 1 ? "Titel des History-Films" : "Thema oder Titel des History-Films"));
            mediaDataDto.searchInWhat.addListener((u, o, n) -> this.textSearch.setText("History, suchen im: " + (mediaDataDto.searchInWhat.getValue() == 1 ? "Titel des History-Films" : "Thema oder Titel des History-Films")));
        }
        this.filteredList = new FilteredList<HistoryData>(this.historyList, p -> true);
        this.sortedList = new SortedList<HistoryData>((ObservableList<HistoryData>)this.filteredList);
    }

    @Override
    public void close() {
        this.historyList.removeListener(this.listener);
    }

    @Override
    void initTable() {
        this.tableAboOrHistory.setMinHeight(200.0);
        this.tableAboOrHistory.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tableAboOrHistory.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        this.tableAboOrHistory.setEditable(true);
        TableColumn themeColumn = new TableColumn("Thema");
        themeColumn.setCellValueFactory(new PropertyValueFactory("theme"));
        TableColumn titleColumn = new TableColumn("Titel");
        titleColumn.setCellValueFactory(new PropertyValueFactory("title"));
        TableColumn dateColumn = new TableColumn("Datum");
        dateColumn.setCellValueFactory(new PropertyValueFactory("date"));
        dateColumn.setSortType(TableColumn.SortType.DESCENDING);
        dateColumn.getStyleClass().add("alignCenter");
        TableColumn pathColumn = new TableColumn("Url");
        pathColumn.setCellValueFactory(new PropertyValueFactory("url"));
        themeColumn.prefWidthProperty().bind(this.tableAboOrHistory.widthProperty().multiply(0.2));
        titleColumn.prefWidthProperty().bind(this.tableAboOrHistory.widthProperty().multiply(0.5));
        dateColumn.prefWidthProperty().bind(this.tableAboOrHistory.widthProperty().multiply(0.15));
        pathColumn.prefWidthProperty().bind(this.tableAboOrHistory.widthProperty().multiply(0.14));
        this.tableAboOrHistory.getColumns().addAll(themeColumn, titleColumn, dateColumn, pathColumn);
        this.tableAboOrHistory.getSelectionModel().selectedItemProperty().addListener((observableValue, dataOld, dataNew) -> this.setTableSel((HistoryData)dataNew));
        this.tableAboOrHistory.setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                ArrayList<HistoryData> historyDataArrayList = new ArrayList<HistoryData>();
                HistoryData historyData = (HistoryData)this.tableAboOrHistory.getSelectionModel().getSelectedItem();
                if (historyData == null) {
                    P2Alert.showInfoNoSelection();
                } else {
                    historyDataArrayList.add(historyData);
                    ContextMenu contextMenu = new PaneHistoryContextMenu(this.stage, historyDataArrayList, this.mediaDataDto.whatToShow == MediaDataDto.SHOW_WHAT.SHOW_HISTORY).getContextMenu();
                    this.tableAboOrHistory.setContextMenu(contextMenu);
                }
            }
        });
        this.tableAboOrHistory.setRowFactory(new P2RowFactory(tv -> {
            TableRow row = new TableRow();
            row.hoverProperty().addListener(observable2 -> {
                HistoryData historyData = (HistoryData)row.getItem();
                if (row.isHover() && historyData != null) {
                    this.setTableSel(historyData);
                } else {
                    this.setTableSel((HistoryData)this.tableAboOrHistory.getSelectionModel().getSelectedItem());
                }
            });
            return row;
        }));
        this.sortedList.comparatorProperty().bind(this.tableAboOrHistory.comparatorProperty());
        this.tableAboOrHistory.setItems(this.sortedList);
    }

    private void setTableSel(HistoryData historyData) {
        if (historyData == null) {
            this.txtTitleMedia.setText("");
            this.txtPathMedia.setText("");
        } else {
            this.txtTitleMedia.setText(historyData.getTitle());
            this.txtPathMedia.setText(historyData.getUrl());
        }
    }

    @Override
    void initAction() {
        super.initAction();
        this.lblGesamtMedia.setText("" + this.historyList.size());
        this.listener = c -> Platform.runLater(() -> {
            this.lblGesamtMedia.setText("" + this.historyList.size());
            this.filter();
        });
        this.historyList.addListener(this.listener);
        this.btnClearList.setOnAction(a -> this.historyList.clearAll(this.stage));
        this.btnClearSelection.setOnAction(a -> {
            ArrayList<HistoryData> historyDataArrayList = new ArrayList<HistoryData>(this.tableAboOrHistory.getSelectionModel().getSelectedItems());
            if (historyDataArrayList.isEmpty()) {
                P2Alert.showInfoNoSelection(this.stage);
            } else if (this.mediaDataDto.whatToShow == MediaDataDto.SHOW_WHAT.SHOW_HISTORY) {
                this.progData.historyList.removeHistoryDataFromHistory(historyDataArrayList);
            } else {
                this.progData.historyListAbos.removeHistoryDataFromHistory(historyDataArrayList);
            }
        });
    }

    @Override
    public void filter() {
        this.filteredList.setPredicate(MediaSearchPredicateFactory.getPredicateHistoryData(this.mediaDataDto.searchInWhat, this.txtSearch.getText()));
        this.lblHits.setText("" + this.filteredList.size());
    }
}

