/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.mediadialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.gui.mediaSearch.MediaDataDto;
import de.p2tools.mtplayer.gui.mediadialog.PaneDialogAbo;
import de.p2tools.mtplayer.gui.mediadialog.PaneDialogMedia;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.tools.log.P2Log;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class MediaDialogController
extends P2DialogExtra {
    private final TabPane tabPane = new TabPane();
    private final Button btnOk = new Button("_Ok");
    private final ProgData progData = ProgData.getInstance();
    private PaneDialogMedia paneDialogMedia;
    private PaneDialogAbo paneDialogAbo;
    private PaneDialogAbo paneDialogHistory;
    private final MediaDataDto mediaDataDtoMedia;
    private final MediaDataDto mediaDataDtoAbo;
    private final MediaDataDto mediaDataDtoHistory;

    public MediaDialogController(MediaDataDto mediaDataDto) {
        super(ProgData.getInstance().primaryStage, ProgConfig.MEDIA_DIALOG_SIZE, "Mediensammlung", true, false, P2DialogExtra.DECO.BORDER);
        this.mediaDataDtoMedia = mediaDataDto;
        this.mediaDataDtoAbo = new MediaDataDto();
        this.mediaDataDtoHistory = new MediaDataDto();
        this.initDto();
        this.init(true);
    }

    public MediaDialogController(String searchTheme, String searchTitel) {
        super(ProgData.getInstance().primaryStage, ProgConfig.MEDIA_DIALOG_SIZE, "Mediensammlung", true, false, P2DialogExtra.DECO.BORDER);
        this.mediaDataDtoMedia = new MediaDataDto();
        this.mediaDataDtoAbo = new MediaDataDto();
        this.mediaDataDtoHistory = new MediaDataDto();
        this.mediaDataDtoMedia.searchTheme = searchTheme;
        this.mediaDataDtoMedia.searchTitle = searchTitel;
        this.initDto();
        this.init(true);
    }

    @Override
    public void make() {
        this.initPanel();
        this.initAction();
        this.paneDialogMedia.filter(this.mediaDataDtoMedia.searchStringProp.getValueSafe());
        this.paneDialogAbo.filter(this.mediaDataDtoAbo.searchStringProp.getValueSafe());
        this.paneDialogHistory.filter(this.mediaDataDtoHistory.searchStringProp.getValueSafe());
    }

    @Override
    public void close() {
        this.paneDialogMedia.close();
        this.paneDialogAbo.close();
        this.paneDialogHistory.close();
        super.close();
    }

    private void initDto() {
        this.mediaDataDtoMedia.whatToShow = MediaDataDto.SHOW_WHAT.SHOW_MEDIA;
        this.mediaDataDtoMedia.searchStringProp.setValue((this.mediaDataDtoMedia.searchTheme + " " + this.mediaDataDtoMedia.searchTitle).trim());
        this.mediaDataDtoAbo.whatToShow = MediaDataDto.SHOW_WHAT.SHOW_ABO;
        this.mediaDataDtoAbo.searchTheme = this.mediaDataDtoMedia.searchTheme;
        this.mediaDataDtoAbo.searchTitle = this.mediaDataDtoMedia.searchTitle;
        this.mediaDataDtoAbo.searchStringProp.setValue(this.mediaDataDtoMedia.searchStringProp.getValueSafe());
        this.mediaDataDtoHistory.whatToShow = MediaDataDto.SHOW_WHAT.SHOW_HISTORY;
        this.mediaDataDtoHistory.searchTheme = this.mediaDataDtoMedia.searchTheme;
        this.mediaDataDtoHistory.searchTitle = this.mediaDataDtoMedia.searchTitle;
        this.mediaDataDtoHistory.searchStringProp.setValue(this.mediaDataDtoMedia.searchStringProp.getValueSafe());
        this.mediaDataDtoMedia.buildSearchFrom = ProgConfig.DIALOG_BUILD_SEARCH_FROM_FOR_MEDIA;
        this.mediaDataDtoMedia.searchInWhat = ProgConfig.DIALOG_SEARCH_IN_WHAT_FOR_MEDIA;
        this.mediaDataDtoAbo.buildSearchFrom = ProgConfig.DIALOG_BUILD_SEARCH_FROM_FOR_ABO;
        this.mediaDataDtoAbo.searchInWhat = ProgConfig.DIALOG_SEARCH_IN_WHAT_FOR_ABO;
        this.mediaDataDtoHistory.buildSearchFrom = ProgConfig.DIALOG_BUILD_SEARCH_FROM_FOR_HISTORY;
        this.mediaDataDtoHistory.searchInWhat = ProgConfig.DIALOG_SEARCH_IN_WHAT_FOR_HISTORY;
    }

    private void initPanel() {
        try {
            this.paneDialogMedia = new PaneDialogMedia(this.getStage(), this.mediaDataDtoMedia);
            this.paneDialogMedia.make();
            this.paneDialogAbo = new PaneDialogAbo(this.getStage(), this.mediaDataDtoAbo);
            this.paneDialogAbo.make();
            this.paneDialogHistory = new PaneDialogAbo(this.getStage(), this.mediaDataDtoHistory);
            this.paneDialogHistory.make();
            Tab tabMedia = new Tab("Mediensammlung");
            tabMedia.setTooltip(new Tooltip("Hier wird der Inhalt der Mediensammlung angezeigt"));
            tabMedia.setClosable(false);
            tabMedia.setContent(this.paneDialogMedia);
            this.tabPane.getTabs().add(tabMedia);
            Tab tabAbo = new Tab("Erledigte Abos");
            tabAbo.setTooltip(new Tooltip("Hier werden erledigte Abos angezeigt"));
            tabAbo.setClosable(false);
            tabAbo.setContent(this.paneDialogAbo);
            this.tabPane.getTabs().add(tabAbo);
            Tab tabHistory = new Tab("History");
            tabHistory.setTooltip(new Tooltip("Hier werden die bereits gesehenen Filme angezeigt"));
            tabHistory.setClosable(false);
            tabHistory.setContent(this.paneDialogHistory);
            this.tabPane.getTabs().add(tabHistory);
            this.getVBoxCont().setPadding(new Insets(0.0));
            VBox.setVgrow(this.tabPane, Priority.ALWAYS);
            this.getVBoxCont().getChildren().add(this.tabPane);
            Button btnHelp = P2Button.helpButton(this.getStage(), "Suche in der Mediensammlung", "In der Mediensammlung und den erledigten Abos / der History kann nach Filmen gesucht werden. Dazu wird in der Mediensammlung nach dem DATEINAMEN - und/oder - PFAD gesucht. In der Liste der erledigten Abos / History wird nach dem TITEL - und/oder - dem THEMA des Abo-Films / History-Films gesucht.\n\nDer Button (gedrehte Pfeile) stellt den urspr\u00fcnglichen Suchtext wieder her.\n\n-- Besonderheiten --\nBeim Durchsuchen der Mediensammlungen muss der Suchtext den eigenen Vorgaben f\u00fcr Dateinamen entsprechen. Eine Suche nach 'mein Film' w\u00fcrde den Film 'Das ist mein Film.avi' finden, aber nicht 'Das_ist_mein_Film.avi'.\n\nBei der Suche mit mehreren UND-Verkn\u00fcpften Suchbegriffen m\u00fcssen alle im selben Datenfeld vorkommen. Ein Film mit 'Sport' im THEMA und 'Fussball' im TITEL wird von 'Sport:Fussball' nicht gefunden.\nSind die Suchbegriffe dagegen ODER-Verkn\u00fcpft, z.B.: 'Sport,Fussball' dann wird es gefunden. Dann muss ein Suchbegriff entweder im THEMA/PFAD ODER im TITEL/DATEINAMEN vorkommen.\n\nEin Doppelklick auf ein Wort im Suchtext stellt dieses frei. So kann man den Suchtext schnell auf einen entscheidenden Begriff reduzieren.\n\n--- Suchregeln ---\nMit den Textfeldern kann nach einem w\u00f6rtlichen Suchtext (Suchtext muss enthalten sein/oder darf nicht enthalten sein) oder nach regul\u00e4ren Ausdr\u00fccken (RegExp) gesucht werden.\n\nGro\u00df- und Kleinschreibung wird bei beiden Arten der Suche nicht unterschieden.\n\n-- W\u00f6rtlicher Suchtext muss enthalten sein --\nEin w\u00f6rtlicher Suchtext findet alle Dateien bei denen der Suchtext an beliebiger Stelle im durchsuchten Bereich enthalten ist.\n\nW\u00f6rtlicher Suchtext muss in \" angegeben werden. Dann wird alles gefunden, was im durchsuchten Bereich den Inhalt zwischen den \" enth\u00e4lt. Hier sind auch \",\" und \":\" erlaubt. Der gesamte Suchtext muss aber in \" eingeschlossen werden, z.B.\n\"das, das und das wird gesucht\"\nDann muss der durchsuchte Bereich genau das \"das, das und das wird gesucht\" enthalten (ohne die \").\nEine Suche mit RegEx, z.B. \"#:.*pass,+.*\" kann damit verk\u00fcrzt werden: \"pass,\". Das ist k\u00fcrzer und l\u00e4uft im Programm auch schneller.\n\nUm mehrere Begriffe zu suchen m\u00fcssen diese durch Komma oder Doppelpunkt getrennt werden. Das Komma verkn\u00fcpft die Begriffe mit ODER (=> mindestens einer der Begriffe muss vorkommen), der Doppelpunkt mit UND (=> alle Begriffe m\u00fcssen vorkommen).\n\n\n-- W\u00f6rtlicher Suchtext darf nicht enthalten sein --\nDer Suchtext muss mit '!:' (ohne die ' ') beginnen.\nEin w\u00f6rtlicher Suchtext schlie\u00dft alle Dateien aus, bei denen der Suchtext an beliebiger Stelle im durchsuchten Bereich enthalten ist.\n\nUm mehrere Begriffe auszuschlie\u00dfen, m\u00fcssen diese durch Komma oder Doppelpunkt getrennt werden. Das Komma verkn\u00fcpft die Begriffe mit ODER (=> mindestens einer der Begriffe muss enthalten sein) und der Doppelpunkt verkn\u00fcpft die Begriffe mit UND (=> alle Begriffe m\u00fcssen enthalten sein, damit der Beitrag ausgeschlossen wird).\n\n\nSuchtext und Suchbegriffe d\u00fcrfen Leerzeichen enthalten, aber kein Komma und keinen Doppelpunkt (wenn der gesamte Suchtext nicht in \" eingeschlossen ist.)\n\nBeispiele:\n'Tagesschau' findet u.a. 'Tagesschau, 12:00 Uhr', 'ARD Tagesschau Livestream', 'Bei Logo und der Tagesschau'.\n'Sport,Fussball' (Komma-getrennt) findet Filme bei denen 'Sport' oder 'Fussball' oder beides vorkommt, u.a. 'Wintersport im Mumintal' und 'Wie wird man Fussballprofi?'.\n'Sport:Fussball' (Doppelpunkt-getrennt) findet nur Dateien bei denen beides ('Sport' und 'Fussball') vorkommt, z.B. 'Wintersport, Fussball und Formel 1'.\n\n'!:Auto,Motorrad', es werden nur Beitr\u00e4ge gefunden, die weder \"Auto\" noch \"Motorrad\" enthalten.\n'!:Auto:Motorrad', es werden Beitr\u00e4ge gefunden, die \"Auto\" *und* \"Motorrad\" *nicht* enthalten.\n\n-- Regul\u00e4re Ausdr\u00fccke --\nEin Suchtext aus regul\u00e4ren Ausdr\u00fccken (RegExp) muss mit '#:' (ohne die ' ') beginnen.\n\nBeliebige Zeichen mit in die Suche aufnehmen (als '.+', '.*' oder '.?'') macht einen Unterschied!\n\nBeispiele:\n'#:Burger' oder '#:^burger$' -- beide finden 'Burger' und 'burger' und nichts sonst.\n'#:Burger.+' findet nicht 'Burger', aber alles was nach 'Burger' noch Zeichen enth\u00e4lt (z.B. 'Burger f\u00fcr die Straubing Tigers').\n'#:.+burger' findet alles was auf 'burger' oder 'Burger' endet (z.B. 'Der Hamburger' und '1. Burger').\n\nMehr zu regul\u00e4ren Ausdr\u00fccken:\nhttps://de.wikipedia.org/wiki/Regul%C3%A4rer_Ausdruck\n\n");
            this.addOkButton(this.btnOk);
            this.addHlpButton(btnHelp);
        }
        catch (Exception ex) {
            P2Log.errorLog(951203030, ex);
        }
    }

    private void initAction() {
        this.btnOk.setOnAction(a -> this.close());
    }
}

