/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.mediaSearch;

import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.gui.mediaSearch.MediaDataDto;
import de.p2tools.p2lib.guitools.P2GuiTools;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class MediaSearchFactory {
    private MediaSearchFactory() {
    }

    public static VBox getSearchVbox(MediaDataDto mediaDataDto, Label lblSum, boolean showBuildSearchFrom) {
        HBox hBoxBuildSearchFrom = MediaSearchFactory.getSearchHbox(mediaDataDto, lblSum, true);
        HBox hBoxSearchIn = MediaSearchFactory.getSearchHbox(mediaDataDto, lblSum, false);
        VBox vBox = new VBox(5.0);
        vBox.setPadding(new Insets(5.0));
        if (showBuildSearchFrom) {
            vBox.getChildren().addAll((Node[])new Node[]{hBoxBuildSearchFrom});
        }
        vBox.getChildren().addAll((Node[])new Node[]{hBoxSearchIn});
        return vBox;
    }

    private static String getTextSearchInWhat(MediaDataDto mediaDataDto) {
        if (mediaDataDto.whatToShow == MediaDataDto.SHOW_WHAT.SHOW_MEDIA) {
            switch (mediaDataDto.searchInWhat.getValue()) {
                case 0: {
                    return "Medien suchen im: Pfad";
                }
                case 1: {
                    return "Medien suchen im: Dateinamen";
                }
            }
            return "Medien suchen im: Pfad oder Dateinamen";
        }
        if (mediaDataDto.whatToShow == MediaDataDto.SHOW_WHAT.SHOW_ABO) {
            switch (mediaDataDto.searchInWhat.getValue()) {
                case 0: {
                    return "Abos suchen im: Thema des Abos";
                }
                case 1: {
                    return "Abos suchen im: Titel des Abos";
                }
            }
            return "Abos suchen im: Thema oder Titel des Abos";
        }
        switch (mediaDataDto.searchInWhat.getValue()) {
            case 0: {
                return "History suchen im: Thema des History-Films";
            }
            case 1: {
                return "History suchen im: Titel des History-Films";
            }
        }
        return "History suchen im: Thema oder Titel des History-Films";
    }

    private static HBox getSearchHbox(MediaDataDto mediaDataDto, Label lblSum, boolean buildSearchFrom) {
        Label lblText;
        HBox hBox = new HBox(10.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.setPadding(new Insets(0.0));
        if (buildSearchFrom) {
            lblText = new Label(MediaSearchFactory.getTextBuildSearchFrom(mediaDataDto.buildSearchFrom.getValue()));
            mediaDataDto.buildSearchFrom.addListener((u, o, n) -> lblText.setText(MediaSearchFactory.getTextBuildSearchFrom(mediaDataDto.buildSearchFrom.getValue())));
        } else {
            lblText = new Label(MediaSearchFactory.getTextSearchInWhat(mediaDataDto));
            mediaDataDto.searchInWhat.addListener((u, o, n) -> lblText.setText(MediaSearchFactory.getTextSearchInWhat(mediaDataDto)));
        }
        Button btnChange = new Button();
        if (buildSearchFrom) {
            btnChange.setTooltip(new Tooltip("Einstellung wie der Suchtext gebaut wird"));
        } else {
            btnChange.setTooltip(new Tooltip("Einstellung wo gesucht wird"));
        }
        btnChange.setGraphic(ProgIcons.ICON_BUTTON_RESET.getImageView());
        btnChange.setOnAction(a -> {
            if (buildSearchFrom) {
                if (mediaDataDto.buildSearchFrom.getValue() == 0) {
                    mediaDataDto.buildSearchFrom.setValue(1);
                } else if (mediaDataDto.buildSearchFrom.getValue() == 1) {
                    mediaDataDto.buildSearchFrom.setValue(2);
                } else {
                    mediaDataDto.buildSearchFrom.setValue(0);
                }
            } else if (mediaDataDto.searchInWhat.getValue() == 0) {
                mediaDataDto.searchInWhat.setValue(1);
            } else if (mediaDataDto.searchInWhat.getValue() == 1) {
                mediaDataDto.searchInWhat.setValue(2);
            } else {
                mediaDataDto.searchInWhat.setValue(0);
            }
        });
        if (lblSum == null) {
            hBox.getChildren().addAll((Node[])new Node[]{lblText, P2GuiTools.getHBoxGrower(), btnChange});
        } else {
            hBox.getChildren().addAll((Node[])new Node[]{lblText, P2GuiTools.getHBoxGrower(), lblSum, btnChange});
        }
        return hBox;
    }

    private static String getTextBuildSearchFrom(int search) {
        return switch (search) {
            case 0 -> "Suchtext bauen mit: Thema des Films";
            case 1 -> "Suchtext bauen mit: Titel des Films";
            default -> "Suchtext bauen mit: Thema und Titel des Films";
        };
    }
}

