/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.infoPane;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.cleaningdata.CleaningMediaFactory;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.history.HistoryData;
import de.p2tools.mtplayer.controller.mediadb.MediaData;
import de.p2tools.mtplayer.controller.mediadb.MediaSearchPredicateFactory;
import de.p2tools.mtplayer.gui.mediaSearch.MediaDataDto;
import de.p2tools.mtplayer.gui.mediaSearch.MediaSearchFactory;
import de.p2tools.mtplayer.gui.mediacleaningdialog.MediaCleaningDialogController;
import de.p2tools.mtplayer.gui.mediadialog.MediaDialogController;
import de.p2tools.mtplayer.gui.mediadialog.PaneMediaContextMenu;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.mediathek.filmdata.FilmData;
import de.p2tools.p2lib.mediathek.filter.FilterCheckRegEx;
import javafx.application.Platform;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class PaneMedia
extends VBox {
    private final TableView<MediaData> tableMedia = new TableView();
    private final TableView<HistoryData> tableAbo = new TableView();
    private final TextField txtSearchMedia = new TextField();
    private final TextField txtSearchAbo = new TextField();
    private final Button btnConfig = new Button();
    private final Button btnDialogMedia = new Button();
    private final Button btnClear = new Button();
    private final Label lblSumMedia = new Label();
    private final Label lblSumAbo = new Label();
    private final MediaDataDto mediaDataDtoMedia;
    private final MediaDataDto mediaDataDtoAbo;
    private final ProgData progData = ProgData.getInstance();

    public PaneMedia(MediaDataDto mediaDataDtoMedia, MediaDataDto mediaDataDtoAbo) {
        VBox.setVgrow(this, Priority.ALWAYS);
        this.mediaDataDtoMedia = mediaDataDtoMedia;
        this.mediaDataDtoAbo = mediaDataDtoAbo;
        this.init();
        this.initMenu();
        this.initTableMedia();
        this.initTableAbo();
        this.initSearch();
    }

    public void setSearchPredicate(FilmData filmDataMTP) {
        this.mediaDataDtoMedia.searchTheme = filmDataMTP == null ? "" : filmDataMTP.getTheme().trim();
        this.mediaDataDtoMedia.searchTitle = filmDataMTP == null ? "" : filmDataMTP.getTitle().trim();
        this.mediaDataDtoAbo.searchTheme = filmDataMTP == null ? "" : filmDataMTP.getTheme().trim();
        this.mediaDataDtoAbo.searchTitle = filmDataMTP == null ? "" : filmDataMTP.getTitle().trim();
        this.setSearchStringMedia();
        this.setSearchStringAbo();
    }

    public void setSearchPredicate(DownloadData downloadData) {
        this.mediaDataDtoMedia.searchTheme = downloadData == null ? "" : downloadData.getTheme().trim();
        this.mediaDataDtoMedia.searchTitle = downloadData == null ? "" : downloadData.getTitle().trim();
        this.mediaDataDtoAbo.searchTheme = downloadData == null ? "" : downloadData.getTheme().trim();
        this.mediaDataDtoAbo.searchTitle = downloadData == null ? "" : downloadData.getTitle().trim();
        this.setSearchStringMedia();
        this.setSearchStringAbo();
    }

    private void setSearchStringMedia() {
        if (this.mediaDataDtoMedia.searchTheme.isEmpty() && this.mediaDataDtoMedia.searchTitle.isEmpty()) {
            return;
        }
        this.txtSearchMedia.setText(CleaningMediaFactory.cleanSearchText(this.mediaDataDtoMedia));
    }

    private void setSearchStringAbo() {
        if (this.mediaDataDtoAbo.searchTheme.isEmpty() && this.mediaDataDtoAbo.searchTitle.isEmpty()) {
            return;
        }
        this.txtSearchAbo.setText(CleaningMediaFactory.cleanSearchText(this.mediaDataDtoAbo));
    }

    private void init() {
        Button btnHelpMedia = P2Button.helpButton("Mediensammlung", "Hier werden Filme aus der Mediensammlung und den erledigten Abos angezeigt. Mit dem Suchtext kann in der Mediensammlung / erledigten Abos gesucht werden. Ein Doppelklick auf ein Wort im Suchtext stellt es frei.\n\nIm Einstellungsdialog kann ausgew\u00e4hlt werden, wie der Suchtext beim Klick auf einen Download gebaut wird und wo (in der Mediensammlung / erledigten Abos) gesucht werden soll.\n\nDort wird auch festgelegt, ob und wie der Suchtext \"geputzt\" wird. Beim Putzen wird der Suchtext auf die wichtigsten W\u00f6rter reduziert um das Suchergebnis zu verbessern.\n");
        HBox hBoxTop = new HBox(10.0);
        hBoxTop.setPadding(new Insets(0.0));
        hBoxTop.setAlignment(Pos.CENTER);
        HBox hBoxButton = new HBox(5.0);
        hBoxButton.getChildren().addAll((Node[])new Node[]{this.btnConfig, this.btnClear, btnHelpMedia, P2GuiTools.getVDistance(5), this.btnDialogMedia});
        hBoxTop.getChildren().addAll((Node[])new Node[]{this.txtSearchMedia, hBoxButton, this.txtSearchAbo});
        HBox.setHgrow(this.txtSearchMedia, Priority.ALWAYS);
        HBox.setHgrow(this.txtSearchAbo, Priority.ALWAYS);
        VBox vLeft = MediaSearchFactory.getSearchVbox(this.mediaDataDtoMedia, this.lblSumMedia, true);
        vLeft.getChildren().add(this.tableMedia);
        VBox vRight = MediaSearchFactory.getSearchVbox(this.mediaDataDtoAbo, this.lblSumAbo, true);
        vRight.getChildren().add(this.tableAbo);
        this.mediaDataDtoMedia.searchInWhat.addListener((u, o, n) -> this.filter(this.mediaDataDtoMedia));
        this.mediaDataDtoAbo.searchInWhat.addListener((u, o, n) -> this.filter(this.mediaDataDtoAbo));
        this.mediaDataDtoMedia.buildSearchFrom.addListener((u, o, n) -> {
            this.setSearchStringMedia();
            this.filter(this.mediaDataDtoMedia);
        });
        this.mediaDataDtoAbo.buildSearchFrom.addListener((u, o, n) -> {
            this.setSearchStringAbo();
            this.filter(this.mediaDataDtoAbo);
        });
        this.tableMedia.setStyle("-fx-border-width: 1px; -fx-border-color: -text-color-blue;");
        this.tableAbo.setStyle("-fx-border-width: 1px; -fx-border-color: -text-color-blue;");
        VBox.setVgrow(this.tableMedia, Priority.ALWAYS);
        VBox.setVgrow(this.tableAbo, Priority.ALWAYS);
        SplitPane splitPane = new SplitPane();
        splitPane.setPadding(new Insets(0.0));
        splitPane.getItems().addAll((Node[])new Node[]{vLeft, vRight});
        ((SplitPane.Divider)splitPane.getDividers().get(0)).positionProperty().bindBidirectional(ProgConfig.DOWNLOAD_GUI_MEDIA_DIVIDER);
        VBox.setVgrow(splitPane, Priority.ALWAYS);
        this.setSpacing(5.0);
        this.setPadding(new Insets(10.0));
        this.getChildren().addAll((Node[])new Node[]{hBoxTop, splitPane});
    }

    private void initMenu() {
        this.btnConfig.setTooltip(new Tooltip("Einstellungen anzeigen"));
        this.btnConfig.setGraphic(ProgIcons.ICON_BUTTON_EDIT.getImageView());
        this.btnConfig.setOnAction(a -> {
            new MediaCleaningDialogController(this.mediaDataDtoMedia, this.mediaDataDtoAbo);
            this.setSearchStringMedia();
            this.setSearchStringAbo();
        });
        this.btnDialogMedia.setTooltip(new Tooltip("Dialog Mediensammlung \u00f6ffnen"));
        this.btnDialogMedia.setGraphic(ProgIcons.ICON_TOOLBAR_MENU.getImageView());
        this.btnDialogMedia.setOnAction(a -> {
            new MediaDialogController(this.mediaDataDtoMedia);
            this.setSearchStringMedia();
            this.setSearchStringAbo();
            this.filter(this.mediaDataDtoMedia);
            this.filter(this.mediaDataDtoAbo);
        });
        this.btnClear.setTooltip(new Tooltip("Die Suchfelder l\u00f6schen"));
        this.btnClear.setGraphic(ProgIcons.ICON_BUTTON_CLEAR.getImageView());
        this.btnClear.setOnAction(a -> {
            this.txtSearchMedia.clear();
            this.txtSearchAbo.clear();
        });
    }

    private void initSearch() {
        this.lblSumMedia.setText("" + this.progData.mediaDataList.getFilteredList().size());
        this.lblSumAbo.setText("" + this.progData.historyListAbos.getFilteredList().size());
        this.progData.mediaDataList.getFilteredList().addListener(c -> Platform.runLater(() -> this.lblSumMedia.setText("" + this.progData.mediaDataList.getFilteredList().size())));
        this.progData.historyListAbos.getFilteredList().addListener(c -> Platform.runLater(() -> this.lblSumAbo.setText("" + this.progData.historyListAbos.getFilteredList().size())));
        new FilterCheckRegEx(this.txtSearchMedia);
        this.txtSearchMedia.textProperty().addListener((u, o, n) -> this.filter(this.mediaDataDtoMedia));
        this.txtSearchMedia.setOnMouseClicked(event -> {
            if (event.getClickCount() > 1) {
                String sel = this.txtSearchMedia.getSelectedText();
                this.txtSearchMedia.setText(sel);
            }
        });
        new FilterCheckRegEx(this.txtSearchAbo);
        this.txtSearchAbo.textProperty().addListener((u, o, n) -> this.filter(this.mediaDataDtoAbo));
        this.txtSearchAbo.setOnMouseClicked(event -> {
            if (event.getClickCount() > 1) {
                String sel = this.txtSearchAbo.getSelectedText();
                this.txtSearchAbo.setText(sel);
            }
        });
    }

    void filter(MediaDataDto mediaDataDto) {
        if (mediaDataDto.whatToShow == MediaDataDto.SHOW_WHAT.SHOW_MEDIA) {
            this.progData.mediaDataList.filteredListSetPredicate(MediaSearchPredicateFactory.getPredicateMediaData(this.mediaDataDtoMedia.searchInWhat, this.txtSearchMedia.getText()));
        } else {
            this.progData.historyListAbos.filteredListSetPredicate(MediaSearchPredicateFactory.getPredicateHistoryData(this.mediaDataDtoAbo.searchInWhat, this.txtSearchAbo.getText()));
        }
    }

    private void initTableMedia() {
        TableColumn nameColumn = new TableColumn("Dateiname");
        nameColumn.setCellValueFactory(new PropertyValueFactory("name"));
        nameColumn.getStyleClass().add("special-column-style");
        nameColumn.prefWidthProperty().bind(this.tableMedia.widthProperty().multiply(0.45));
        TableColumn pathColumn = new TableColumn("Pfad");
        pathColumn.setCellValueFactory(new PropertyValueFactory("path"));
        pathColumn.getStyleClass().add("special-column-style");
        pathColumn.prefWidthProperty().bind(this.tableMedia.widthProperty().multiply(0.35));
        TableColumn sizeColumn = new TableColumn("Gr\u00f6\u00dfe [MB]");
        sizeColumn.prefWidthProperty().bind(this.tableMedia.widthProperty().multiply(0.15));
        sizeColumn.setCellValueFactory(new PropertyValueFactory("size"));
        sizeColumn.getStyleClass().add("alignCenterRightPadding_25");
        this.tableMedia.getColumns().addAll(nameColumn, pathColumn, sizeColumn);
        this.tableMedia.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        SortedList<MediaData> sortedList = this.progData.mediaDataList.getSortedList();
        sortedList.comparatorProperty().bind(this.tableMedia.comparatorProperty());
        this.tableMedia.setItems(sortedList);
        this.tableMedia.setOnMousePressed(m -> {
            if (this.tableMedia.getItems().isEmpty()) {
                return;
            }
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                MediaData mediaData = (MediaData)this.tableMedia.getSelectionModel().getSelectedItem();
                if (mediaData == null) {
                    P2Alert.showInfoNoSelection();
                } else {
                    ContextMenu contextMenu = new PaneMediaContextMenu(this.progData.primaryStage, mediaData).getContextMenu();
                    this.tableMedia.setContextMenu(contextMenu);
                }
            }
        });
    }

    private void initTableAbo() {
        TableColumn themeColumn = new TableColumn("Thema");
        themeColumn.prefWidthProperty().bind(this.tableAbo.widthProperty().multiply(0.35));
        themeColumn.setCellValueFactory(new PropertyValueFactory("theme"));
        themeColumn.getStyleClass().add("special-column-style");
        TableColumn titleColumn = new TableColumn("Titel");
        titleColumn.prefWidthProperty().bind(this.tableAbo.widthProperty().multiply(0.45));
        titleColumn.setCellValueFactory(new PropertyValueFactory("title"));
        titleColumn.getStyleClass().add("special-column-style");
        TableColumn dateColumn = new TableColumn("Datum");
        dateColumn.prefWidthProperty().bind(this.tableAbo.widthProperty().multiply(0.15));
        dateColumn.setCellValueFactory(new PropertyValueFactory("date"));
        dateColumn.setSortType(TableColumn.SortType.DESCENDING);
        dateColumn.getStyleClass().add("alignCenter");
        this.tableAbo.getColumns().addAll(themeColumn, titleColumn, dateColumn);
        this.tableAbo.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        SortedList<HistoryData> sortedList = this.progData.historyListAbos.getSortedList();
        sortedList.comparatorProperty().bind(this.tableAbo.comparatorProperty());
        this.tableAbo.setItems(sortedList);
    }
}

