/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.infoPane;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2Hyperlink;
import de.p2tools.p2lib.mediathek.download.DownloadSizeData;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class PaneFilmInfo
extends VBox {
    private final TextArea textArea = new TextArea();
    private final Button btnReset = new Button("@");
    private final Label lblTheme = new Label("");
    private final Label lblTitle = new Label("");
    private final HBox hBoxUrl = new HBox(10.0);
    private final Label lblUrl = new Label("zur Website: ");
    private final Label lblDate = new Label();
    private final Label lblTime = new Label();
    private final Label lblDuration = new Label();
    private final Label lblSize = new Label();
    private final Label lblAbo = new Label();
    private FilmDataMTP film = null;
    private DownloadData downloadData = null;
    private final ChangeListener<String> changeListener;
    private final ChangeListener<DownloadSizeData> sizeChangeListener;
    private String oldDescription = "";

    public PaneFilmInfo(DoubleProperty dividerProp) {
        VBox.setVgrow(this, Priority.ALWAYS);
        StackPane stackPane = new StackPane();
        stackPane.getChildren().addAll((Node[])new Node[]{this.textArea, this.btnReset});
        StackPane.setAlignment(this.btnReset, Pos.BOTTOM_RIGHT);
        stackPane.setMaxHeight(Double.MAX_VALUE);
        VBox.setVgrow(stackPane, Priority.ALWAYS);
        this.changeListener = (observable2, oldValue, newValue) -> this.setFilmDescription();
        this.sizeChangeListener = (u, o, n) -> this.setSize(true);
        this.btnReset.setOnAction(a -> this.resetFilmDescription());
        this.btnReset.setTooltip(new Tooltip("Beschreibung zur\u00fccksetzen"));
        this.btnReset.setVisible(false);
        this.lblTheme.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        this.hBoxUrl.setAlignment(Pos.CENTER_LEFT);
        this.lblUrl.setMinWidth(Double.NEGATIVE_INFINITY);
        this.textArea.setWrapText(true);
        this.textArea.setPrefRowCount(4);
        VBox v = new VBox();
        v.setSpacing(0.0);
        v.getChildren().addAll((Node[])new Node[]{this.lblTheme, this.lblTitle});
        VBox vBoxLeft = new VBox();
        vBoxLeft.setSpacing(2.0);
        vBoxLeft.setPadding(new Insets(10.0));
        vBoxLeft.getChildren().addAll((Node[])new Node[]{v, stackPane, this.hBoxUrl});
        GridPane gridPane = new GridPane();
        gridPane.getStyleClass().add("extra-pane-info");
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        int row = 0;
        gridPane.add(new Label("Datum: "), 0, row);
        gridPane.add(this.lblDate, 1, row);
        gridPane.add(new Label("Zeit: "), 0, ++row);
        gridPane.add(this.lblTime, 1, row);
        gridPane.add(new Label("Dauer: "), 0, ++row);
        gridPane.add(this.lblDuration, 1, row);
        gridPane.add(new Label("Gr\u00f6\u00dfe: "), 0, ++row);
        gridPane.add(this.lblSize, 1, row);
        gridPane.add(new Label("Abo: "), 0, ++row);
        gridPane.add(this.lblAbo, 1, row);
        SplitPane splitPane = new SplitPane();
        splitPane.getItems().addAll((Node[])new Node[]{vBoxLeft, gridPane});
        ((SplitPane.Divider)splitPane.getDividers().get(0)).positionProperty().bindBidirectional(dividerProp);
        SplitPane.setResizableWithParent(gridPane, Boolean.FALSE);
        VBox.setVgrow(splitPane, Priority.ALWAYS);
        this.setSpacing(0.0);
        this.setPadding(new Insets(0.0));
        this.getChildren().add(splitPane);
    }

    public void setFilm(FilmDataMTP film) {
        this.hBoxUrl.getChildren().clear();
        this.textArea.textProperty().removeListener(this.changeListener);
        if (this.downloadData != null) {
            this.downloadData.downloadSizeProperty().removeListener(this.sizeChangeListener);
        }
        this.film = film;
        this.downloadData = null;
        if (film == null) {
            this.lblTheme.setText("");
            this.lblTitle.setText("");
            this.textArea.clear();
            this.oldDescription = "";
            this.btnReset.setVisible(false);
            this.lblDate.setText("");
            this.lblTime.setText("");
            this.lblDuration.setText("");
            this.lblSize.setText("");
            this.lblAbo.setText("");
            return;
        }
        this.lblTheme.setText(film.arr[1] + "  -  " + film.arr[2]);
        this.lblTitle.setText(film.arr[3]);
        this.textArea.setText(film.getDescription());
        this.oldDescription = film.getDescription();
        this.btnReset.setVisible(false);
        this.textArea.textProperty().addListener(this.changeListener);
        this.lblDate.setText(film.getDate().get_dd_MM_yyyy());
        this.lblTime.setText(film.getTime());
        this.lblDuration.setText(film.getDuration() + " [min]");
        this.lblSize.setText(film.getFilmSize().toString() + " [MB]");
        this.lblAbo.setText(film.getAboName());
        if (!film.arr[15].isEmpty()) {
            P2Hyperlink hyperlink = new P2Hyperlink(film.arr[15], ProgConfig.SYSTEM_PROG_OPEN_URL);
            this.hBoxUrl.getChildren().addAll((Node[])new Node[]{this.lblUrl, hyperlink});
        }
    }

    public void setFilm(DownloadData downloadData) {
        this.hBoxUrl.getChildren().clear();
        this.textArea.textProperty().removeListener(this.changeListener);
        if (this.downloadData != null) {
            this.downloadData.downloadSizeProperty().removeListener(this.sizeChangeListener);
        }
        this.film = null;
        this.downloadData = downloadData;
        if (downloadData == null) {
            this.lblTheme.setText("");
            this.lblTitle.setText("");
            this.textArea.clear();
            this.oldDescription = "";
            this.btnReset.setVisible(false);
            this.lblDate.setText("");
            this.lblTime.setText("");
            this.lblDuration.setText("");
            this.lblSize.setText("");
            this.lblAbo.setText("");
            return;
        }
        this.lblTheme.setText(downloadData.getChannel() + "  -  " + downloadData.getTheme());
        this.lblTitle.setText(downloadData.getTitle());
        this.lblDate.setText(downloadData.getFilmDate().get_dd_MM_yyyy());
        this.lblTime.setText(downloadData.getFilmTime());
        this.lblDuration.setText(downloadData.getDurationMinute() + " [min]");
        this.setSize(false);
        downloadData.downloadSizeProperty().addListener(this.sizeChangeListener);
        this.lblAbo.setText(downloadData.getAboName());
        this.textArea.setText(downloadData.getDescription());
        this.textArea.setEditable(downloadData.isNotStartedOrFinished());
        this.oldDescription = downloadData.getDescription();
        this.btnReset.setVisible(false);
        this.textArea.textProperty().addListener(this.changeListener);
        if (!downloadData.getUrlWebsite().isEmpty()) {
            P2Hyperlink hyperlink = new P2Hyperlink(downloadData.getUrlWebsite(), ProgConfig.SYSTEM_PROG_OPEN_URL);
            this.hBoxUrl.getChildren().addAll((Node[])new Node[]{this.lblUrl, hyperlink});
        }
    }

    private void setSize(boolean async) {
        if (this.downloadData != null) {
            String size = this.downloadData.getDownloadSize().toString();
            if (async) {
                Platform.runLater(() -> {
                    if (size.isEmpty()) {
                        this.lblSize.setText("");
                    } else {
                        this.lblSize.setText(size + " [MB]");
                    }
                });
            } else if (size.isEmpty()) {
                this.lblSize.setText("");
            } else {
                this.lblSize.setText(size + " [MB]");
            }
        }
    }

    private void setFilmDescription() {
        this.btnReset.setVisible(true);
        if (this.film != null) {
            this.film.setDescription(this.textArea.getText());
        }
        if (this.downloadData != null) {
            this.downloadData.setDescription(this.textArea.getText());
        }
    }

    private void resetFilmDescription() {
        this.btnReset.setVisible(false);
        if (this.film != null) {
            this.film.setDescription(this.oldDescription);
            this.textArea.setText(this.film.getDescription());
        }
        if (this.downloadData != null) {
            this.downloadData.setDescription(this.oldDescription);
            this.textArea.setText(this.downloadData.getDescription());
        }
    }
}

