/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.infoPane;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.film.FilmPlayFactory;
import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.mtplayer.controller.data.setdata.SetDataList;
import de.p2tools.p2lib.guitools.P2Color;
import de.p2tools.p2lib.p2event.P2Listener;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.layout.Priority;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;

public class PaneFilmButton
extends VBox {
    private final TilePane tilePane;
    private final PANE pane;

    public PaneFilmButton(PANE pane) {
        this.pane = pane;
        VBox.setVgrow(this, Priority.ALWAYS);
        this.tilePane = new TilePane();
        this.tilePane.setVgap(5.0);
        this.tilePane.setHgap(5.0);
        this.tilePane.setPadding(new Insets(10.0));
        this.setSpacing(0.0);
        this.setPadding(new Insets(0.0));
        this.getChildren().add(this.tilePane);
        this.addButton();
        ProgData.getInstance().setDataList.addListener((u, o, n) -> this.addButton());
        ProgData.getInstance().pEventHandler.addListener(new P2Listener(PEvents.EVENT_SET_DATA_BUTTON_CHANGED){

            @Override
            public void ping() {
                PaneFilmButton.this.addButton();
            }
        });
    }

    private void addButton() {
        this.tilePane.getChildren().clear();
        SetDataList setDataList = ProgData.getInstance().setDataList.getSetDataListButton();
        setDataList.forEach(setData -> {
            Button btn = new Button();
            btn.textProperty().bind(setData.visibleNameProperty());
            btn.setMinWidth(100.0);
            btn.setMaxWidth(Double.MAX_VALUE);
            if (!setData.getColor().equals(SetData.RESET_COLOR)) {
                String c = P2Color.getCssColor(setData.getColor());
                String css = "-fx-border-color: " + c + "; ";
                btn.setStyle(css);
                btn.getStyleClass().add("setButton");
            }
            btn.setOnAction(a -> {
                switch (this.pane) {
                    case FILM: {
                        FilmPlayFactory.playFilmListWithSet(false, setData, ProgData.getInstance().filmGuiController.getSelList(true));
                        break;
                    }
                    case AUDIO: {
                        FilmPlayFactory.playFilmListWithSet(true, setData, ProgData.getInstance().audioGuiController.getSelList(true));
                        break;
                    }
                    case LIVE: {
                        FilmPlayFactory.playFilmListWithSet(false, setData, ProgData.getInstance().liveFilmGuiController.getSelList(true));
                    }
                }
            });
            this.tilePane.getChildren().add(btn);
        });
    }

    public static enum PANE {
        FILM,
        AUDIO,
        LIVE;

    }
}

