/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.infoPane;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.p2lib.tools.file.P2FileSize;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;

public class PaneDownloadInfoList
extends VBox {
    private final VBox vBoxHeader = new VBox();
    private final GridPane gridPane = new GridPane();
    private final ProgData progData = ProgData.getInstance();

    public PaneDownloadInfoList() {
        VBox.setVgrow(this, Priority.ALWAYS);
        this.gridPane.setHgap(30.0);
        this.gridPane.setVgap(10.0);
        this.gridPane.setPadding(new Insets(10.0));
        this.gridPane.getStyleClass().add("downloadInfoGrid");
        VBox vBoxAll = new VBox();
        vBoxAll.setSpacing(10.0);
        vBoxAll.setPadding(new Insets(10.0));
        vBoxAll.getChildren().addAll((Node[])new Node[]{this.vBoxHeader, this.gridPane});
        this.getChildren().add(vBoxAll);
        AnchorPane.setLeftAnchor(this.gridPane, 0.0);
        AnchorPane.setBottomAnchor(this.gridPane, 0.0);
        AnchorPane.setRightAnchor(this.gridPane, 0.0);
        AnchorPane.setTopAnchor(this.gridPane, 0.0);
        this.setInfoText();
    }

    public void setInfoText() {
        this.vBoxHeader.getChildren().clear();
        this.gridPane.getChildren().clear();
        if (this.progData.downloadList.isEmpty()) {
            Text text1 = new Text("Keine Downloads");
            text1.setFont(Font.font(null, FontWeight.BOLD, -1.0));
            text1.getStyleClass().add("downloadGuiMediaText");
            this.vBoxHeader.getChildren().add(text1);
            this.gridPane.setVisible(false);
            return;
        }
        int row = 0;
        this.gridPane.setVisible(true);
        this.getInfoText();
        Text text1 = new Text("laufende Downloads: " + this.progData.downloadInfos.getLoading());
        text1.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        text1.getStyleClass().add("downloadGuiMediaText");
        this.gridPane.add(text1, 1, row);
        text1 = new Text("wartende Downloads: " + this.progData.downloadInfos.getStartedNotLoading());
        text1.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        text1.getStyleClass().add("downloadGuiMediaText");
        this.gridPane.add(text1, 2, row);
        text1 = new Text("nicht gestartete Downloads: " + this.progData.downloadInfos.getNotStarted());
        text1.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        text1.getStyleClass().add("downloadGuiMediaText");
        this.gridPane.add(text1, 3, row);
        text1 = new Text("Gr\u00f6\u00dfe: ");
        text1.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        text1.getStyleClass().add("downloadGuiMediaText");
        this.gridPane.add(text1, 0, ++row);
        text1 = new Text("Restzeit: ");
        text1.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        text1.getStyleClass().add("downloadGuiMediaText");
        this.gridPane.add(text1, 0, ++row);
        text1 = new Text("Bandbreite: ");
        text1.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        text1.getStyleClass().add("downloadGuiMediaText");
        this.gridPane.add(text1, 0, ++row);
        row = 1;
        this.getSizeText(row);
        this.getRestzeit(++row);
        ++row;
        if (this.progData.downloadInfos.getBandwidth() > 0L) {
            Text text2 = new Text(this.progData.downloadInfos.getBandwidthStr());
            text2.getStyleClass().add("downloadGuiMediaText");
            this.gridPane.add(text2, 1, row);
        }
    }

    private void getInfoText() {
        Text text1 = new Text("Downloads: " + this.progData.downloadList.size());
        text1.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        text1.getStyleClass().add("downloadGuiMediaText");
        this.vBoxHeader.getChildren().add(text1);
        if (this.progData.downloadList.size() > 0) {
            int m3u8;
            Object txt = "( ";
            if (this.progData.downloadInfos.getPlacedBack() != 0) {
                txt = (String)txt + this.progData.downloadInfos.getPlacedBack() + " zur\u00fcckgestellt, ";
            }
            txt = this.progData.downloadInfos.getLoading() == 1 ? (String)txt + "1 l\u00e4uft" : (String)txt + this.progData.downloadInfos.getLoading() + " laufen";
            txt = this.progData.downloadInfos.getStartedNotLoading() == 1 ? (String)txt + ", 1 wartet" : (String)txt + ", " + this.progData.downloadInfos.getStartedNotLoading() + " warten";
            if (this.progData.downloadInfos.getFinishedOk() > 0) {
                txt = this.progData.downloadInfos.getFinishedOk() == 1 ? (String)txt + ", 1 fertig" : (String)txt + ", " + this.progData.downloadInfos.getFinishedOk() + " fertig";
            }
            if (this.progData.downloadInfos.getFinishedError() > 0) {
                txt = this.progData.downloadInfos.getFinishedError() == 1 ? (String)txt + ", 1 fehlerhaft" : (String)txt + ", " + this.progData.downloadInfos.getFinishedError() + " fehlerhaft";
            }
            if ((m3u8 = this.progData.downloadInfos.getLoadingM3u8()) == 1) {
                txt = (String)txt + ", ein Download ist ein Stream, Zeit- und Gr\u00f6\u00dfenangaben sind nur Sch\u00e4tzungen";
            } else if (m3u8 > 1) {
                txt = (String)txt + ", " + m3u8 + " Downloads sind Streams, Zeit- und Gr\u00f6\u00dfenangaben sind nur Sch\u00e4tzungen";
            }
            txt = (String)txt + " )";
            Text text2 = new Text((String)txt);
            text2.getStyleClass().add("downloadGuiMediaText");
            this.vBoxHeader.getChildren().add(text2);
        }
    }

    private void getSizeText(int row) {
        Text text2;
        if (this.progData.downloadInfos.getByteLoadingDownloads() > 0L || this.progData.downloadInfos.getByteLoadingDownloadsAlreadyLoaded() > 0L) {
            if (this.progData.downloadInfos.getByteLoadingDownloads() > 0L) {
                text2 = new Text(P2FileSize.convertToStr(this.progData.downloadInfos.getByteLoadingDownloadsAlreadyLoaded()) + " von " + P2FileSize.convertToStr(this.progData.downloadInfos.getByteLoadingDownloads()));
                text2.getStyleClass().add("downloadGuiMediaText");
            } else {
                text2 = new Text(P2FileSize.convertToStr(this.progData.downloadInfos.getByteLoadingDownloadsAlreadyLoaded()));
                text2.getStyleClass().add("downloadGuiMediaText");
            }
            this.gridPane.add(text2, 1, row);
        }
        if (this.progData.downloadInfos.getByteWaitingDownloads() > 0L) {
            text2 = new Text(P2FileSize.convertToStr(this.progData.downloadInfos.getByteWaitingDownloads()));
            text2.getStyleClass().add("downloadGuiMediaText");
            this.gridPane.add(text2, 2, row);
        }
        if (this.progData.downloadInfos.getByteNotStartedDownloads() > 0L) {
            text2 = new Text(P2FileSize.convertToStr(this.progData.downloadInfos.getByteNotStartedDownloads()));
            text2.getStyleClass().add("downloadGuiMediaText");
            this.gridPane.add(text2, 3, row);
        }
    }

    private void getRestzeit(int row) {
        Text text2;
        if (this.progData.downloadInfos.getTimeLeftLoadingDownloads() > 0L && this.progData.downloadInfos.getTimeLeftLoadingDownloads() > 0L) {
            text2 = new Text(this.progData.downloadInfos.getTimeLeftLoading());
            text2.getStyleClass().add("downloadGuiMediaText");
            this.gridPane.add(text2, 1, row);
        }
        if (this.progData.downloadInfos.getTimeLeftWaitingDownloads() > 0L) {
            text2 = new Text(this.progData.downloadInfos.getTimeLeftWaiting());
            text2.getStyleClass().add("downloadGuiMediaText");
            this.gridPane.add(text2, 2, row);
        }
        if (this.progData.downloadInfos.getTimeLeftNotStartedDownloads() > 0L) {
            text2 = new Text(this.progData.downloadInfos.getTimeLeftNotStarted());
            text2.getStyleClass().add("downloadGuiMediaText");
            this.gridPane.add(text2, 3, row);
        }
    }
}

