/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.infoPane;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.gui.dialog.downloaddialog.DownloadErrorStreamDialogController;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class PaneDownloadError
extends VBox {
    private final VBox vBoxCont = new VBox();
    private final ScrollPane scrollPane = new ScrollPane();
    private final Button btnClear = new Button();
    private final ProgData progData = ProgData.getInstance();

    public PaneDownloadError() {
        VBox.setVgrow(this, Priority.ALWAYS);
        this.btnClear.setGraphic(ProgIcons.ICON_BUTTON_CLEAR.getImageView());
        this.btnClear.setTooltip(new Tooltip("Die Liste der Downloadfehler l\u00f6schen"));
        this.btnClear.setOnAction(a -> this.progData.downloadErrorList.clear());
        this.vBoxCont.setPadding(new Insets(5.0));
        this.vBoxCont.setSpacing(5.0);
        this.scrollPane.setContent(this.vBoxCont);
        this.scrollPane.setFitToHeight(true);
        this.scrollPane.setFitToWidth(true);
        this.getChildren().add(this.scrollPane);
        VBox.setVgrow(this.scrollPane, Priority.ALWAYS);
        this.progData.downloadErrorList.addListener((u, o, n) -> this.setInfoText());
        this.setInfoText();
    }

    public void setInfoText() {
        this.vBoxCont.getChildren().clear();
        if (this.progData.downloadErrorList.isEmpty()) {
            Label lblNoError = new Label("Keine Fehler");
            this.vBoxCont.getChildren().add(lblNoError);
        } else {
            this.progData.downloadErrorList.forEach(d -> {
                GridPane gridPane = new GridPane();
                gridPane.setHgap(5.0);
                gridPane.setVgap(5.0);
                gridPane.setPadding(new Insets(5.0));
                gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
                gridPane.setStyle("-fx-border-width: 2px; -fx-border-color: black;");
                TextField txtTitle = new TextField(d.getTitle());
                txtTitle.setText(d.getTitle());
                txtTitle.setEditable(false);
                TextField txtUrl = new TextField();
                txtUrl.setText(d.getUrl());
                txtUrl.setEditable(false);
                TextField txtFile = new TextField();
                txtFile.setText(d.getFile());
                txtFile.setEditable(false);
                TextArea taError = new TextArea();
                taError.setText(d.getError());
                taError.setEditable(false);
                taError.setWrapText(true);
                taError.setPrefRowCount(4);
                int row = 0;
                gridPane.add(new Label("Titel: "), 0, row);
                if (d.getErrorStream().isEmpty()) {
                    gridPane.add(txtTitle, 1, row);
                } else {
                    Button btnErrorStream = new Button("Programmausgabe");
                    btnErrorStream.setOnAction(a -> new DownloadErrorStreamDialogController(d.getErrorStream()));
                    btnErrorStream.setVisible(!d.getErrorStream().isEmpty());
                    HBox hBox = new HBox(10.0);
                    HBox.setHgrow(txtTitle, Priority.ALWAYS);
                    hBox.getChildren().addAll((Node[])new Node[]{txtTitle, btnErrorStream});
                    gridPane.add(hBox, 1, row);
                }
                gridPane.add(new Label("URL: "), 0, ++row);
                gridPane.add(txtUrl, 1, row);
                gridPane.add(new Label("Datei:"), 0, ++row);
                gridPane.add(txtFile, 1, row);
                gridPane.add(taError, 0, ++row, 2, 1);
                GridPane.setHgrow(taError, Priority.ALWAYS);
                GridPane.setVgrow(taError, Priority.ALWAYS);
                this.vBoxCont.getChildren().add(gridPane);
                VBox.setVgrow(gridPane, Priority.ALWAYS);
            });
            HBox hBox = new HBox();
            hBox.getChildren().add(this.btnClear);
            hBox.setAlignment(Pos.CENTER_RIGHT);
            this.vBoxCont.getChildren().add(hBox);
        }
    }
}

