/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.infoPane;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkData;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;

public class PaneBookmarkInfo
extends SplitPane {
    private final Label lblChannelS = new Label("");
    private final Label lblThemeS = new Label("");
    private final Label lblTitleS = new Label("");
    private final Label lblDateS = new Label();
    private final Label lblAge = new Label();
    private final TextArea txtInfo = new TextArea();
    private final Text text = new Text("Kein Film in der Liste");
    private BookmarkData bookmarkData = null;
    private boolean changed = false;

    public PaneBookmarkInfo() {
        GridPane gridPane = new GridPane();
        gridPane.getStyleClass().add("extra-pane-info");
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        int row = 0;
        gridPane.add(new Label("Sender:"), 0, row);
        gridPane.add(this.lblChannelS, 1, row, 2, 1);
        gridPane.add(new Label("Thema:"), 0, ++row);
        gridPane.add(this.lblThemeS, 1, row, 2, 1);
        gridPane.add(new Label("Titel:"), 0, ++row);
        gridPane.add(this.lblTitleS, 1, row, 2, 1);
        gridPane.add(new Label("Datum:"), 0, ++row);
        gridPane.add(this.lblDateS, 1, row);
        gridPane.add(new Label("Alter:"), 0, ++row);
        gridPane.add(this.lblAge, 1, row);
        gridPane.add(this.text, 2, row);
        this.text.setVisible(false);
        this.text.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        this.txtInfo.setWrapText(true);
        this.txtInfo.setPrefRowCount(2);
        this.txtInfo.textProperty().addListener((u, o, n) -> {
            if (this.bookmarkData != null) {
                this.changed = true;
                this.bookmarkData.setInfo(this.txtInfo.getText());
            }
        });
        VBox vBox = new VBox(1.0);
        Label lbl = new Label("Info:");
        vBox.getChildren().addAll((Node[])new Node[]{lbl, this.txtInfo});
        VBox.setVgrow(this.txtInfo, Priority.ALWAYS);
        PaneBookmarkInfo splitPane = this;
        splitPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        SplitPane.setResizableWithParent(gridPane, Boolean.FALSE);
        splitPane.getItems().addAll((Node[])new Node[]{vBox, gridPane});
        ((SplitPane.Divider)splitPane.getDividers().get(0)).positionProperty().bindBidirectional(ProgConfig.BOOKMARK_DIALOG_INFO_DIVIDER);
    }

    public void setBookmarkData(BookmarkData bd) {
        this.bookmarkData = null;
        if (bd == null) {
            this.lblChannelS.setText("");
            this.lblThemeS.setText("");
            this.lblTitleS.setText("");
            this.lblDateS.setText("");
            this.lblAge.setText("");
            this.text.setVisible(false);
            this.text.setManaged(false);
            this.txtInfo.setText("");
            this.txtInfo.setDisable(true);
            return;
        }
        this.lblChannelS.setText(bd.getChannel());
        this.lblThemeS.setText(bd.getTheme());
        this.lblTitleS.setText(bd.getTitle());
        this.lblDateS.setText(bd.getDate().get_dd_MM_yyyy());
        this.lblAge.setText("" + bd.getDate().diffInDays());
        this.text.setVisible(bd.getFilmData() == null && ProgConfig.BOOKMARK_DIALOG_SHOW_INFO.get());
        this.text.setManaged(bd.getFilmData() == null && ProgConfig.BOOKMARK_DIALOG_SHOW_INFO.get());
        this.txtInfo.setText(bd.getInfo());
        this.txtInfo.setDisable(false);
        this.bookmarkData = bd;
    }

    public boolean isChanged() {
        return this.changed;
    }
}

