/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.infoPane;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.gui.chart.BandwidthDataFactory;
import de.p2tools.mtplayer.gui.chart.ChartDataFactory;
import de.p2tools.mtplayer.gui.chart.ChartFactory;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.chart.LineChart;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class PaneBandwidthChart
extends VBox {
    private final BooleanProperty chartOnlyExistingProp = ProgConfig.DOWNLOAD_CHART_ONLY_EXISTING;
    private final BooleanProperty chartOnlyRunningProp = ProgConfig.DOWNLOAD_CHART_ONLY_RUNNING;
    private final ProgData progData;
    private LineChart<Number, Number> lineChart = null;
    private ContextMenu cm = null;

    public PaneBandwidthChart(ProgData progData) {
        this.progData = progData;
        VBox.setVgrow(this, Priority.ALWAYS);
        this.initList();
        this.initCharts();
    }

    public synchronized void searchInfos(boolean visible) {
        BandwidthDataFactory.addBandwidthData();
        if (visible) {
            ChartDataFactory.runChart(this.lineChart);
        }
    }

    private synchronized void initList() {
        this.progData.chartData.setyScale(1);
    }

    private void initCharts() {
        this.lineChart = new LineChart<Number, Number>(ChartFactory.createXAxis(), ChartFactory.createYAxis());
        this.lineChart.getStyleClass().add("thick-chart");
        this.lineChart.setLegendSide(Side.RIGHT);
        this.lineChart.setLegendVisible(true);
        this.lineChart.setAnimated(false);
        this.lineChart.setCreateSymbols(false);
        this.lineChart.setTitle("Downloads");
        VBox.setVgrow(this.lineChart, Priority.ALWAYS);
        this.lineChart.setOnMouseClicked(e -> {
            if (this.cm != null && this.cm.isShowing()) {
                this.cm.hide();
            }
            if (e.getButton() == MouseButton.SECONDARY) {
                this.cm = this.initContextMenu();
                this.cm.show(this.lineChart, e.getScreenX(), e.getScreenY());
            }
        });
        this.lineChart.setData(this.progData.chartData.getChartSeriesList());
        AnchorPane.setLeftAnchor(this.lineChart, 0.0);
        AnchorPane.setBottomAnchor(this.lineChart, 0.0);
        AnchorPane.setRightAnchor(this.lineChart, 0.0);
        AnchorPane.setTopAnchor(this.lineChart, 0.0);
        this.getChildren().add(this.lineChart);
    }

    private synchronized void clearChart() {
        this.progData.chartData.getBandwidthDataList().clear();
        this.progData.chartData.setyScale(1);
    }

    private ContextMenu initContextMenu() {
        if (ProgConfig.DOWNLOAD_CHART_MAX_TIME_TO_SHOW_MIN.getValue() % 10 != 0) {
            ProgConfig.DOWNLOAD_CHART_MAX_TIME_TO_SHOW_MIN.setValue(30);
        }
        Label lblValue = new Label(" " + ProgConfig.DOWNLOAD_CHART_MAX_TIME_TO_SHOW_MIN.get() + " Min.");
        Label lblInfo = new Label("Zeitraum:");
        Slider slMaxTime = new Slider();
        slMaxTime.setMinWidth(250.0);
        slMaxTime.setMin(10.0);
        slMaxTime.setMax((double)BandwidthDataFactory.MAX_SECONDS_SHOWING / 60.0);
        slMaxTime.setBlockIncrement(10.0);
        slMaxTime.setShowTickLabels(true);
        slMaxTime.setSnapToTicks(true);
        slMaxTime.setShowTickMarks(true);
        slMaxTime.setMinorTickCount(0);
        slMaxTime.setMajorTickUnit(10.0);
        IntegerProperty ip = ProgConfig.DOWNLOAD_CHART_MAX_TIME_TO_SHOW_MIN;
        slMaxTime.valueProperty().bindBidirectional(ip);
        slMaxTime.valueProperty().addListener((observable2, oldValue, newValue) -> {
            if (newValue != null) {
                lblValue.setText(" " + newValue.intValue() + " Min.");
            }
        });
        HBox hBox = new HBox(5.0);
        hBox.getChildren().addAll((Node[])new Node[]{lblInfo, slMaxTime, lblValue});
        HBox.setHgrow(slMaxTime, Priority.ALWAYS);
        CustomMenuItem cmiTime = new CustomMenuItem(hBox);
        ToggleGroup tg = new ToggleGroup();
        RadioMenuItem rbShowAll = new RadioMenuItem("Summe und alle Downloads anzeigen");
        rbShowAll.setToggleGroup(tg);
        rbShowAll.setSelected(ProgConfig.DOWNLOAD_CHART_SHOW_WHAT.getValue() == 0);
        rbShowAll.setOnAction(e -> ProgConfig.DOWNLOAD_CHART_SHOW_WHAT.setValue(0));
        RadioMenuItem rbShowDown = new RadioMenuItem("Nur Downloads anzeigen");
        rbShowDown.setToggleGroup(tg);
        rbShowDown.setSelected(ProgConfig.DOWNLOAD_CHART_SHOW_WHAT.getValue() == 1);
        rbShowDown.setOnAction(e -> ProgConfig.DOWNLOAD_CHART_SHOW_WHAT.setValue(1));
        RadioMenuItem rbShowSum = new RadioMenuItem("Nur Summe anzeigen");
        rbShowSum.setToggleGroup(tg);
        rbShowSum.setSelected(ProgConfig.DOWNLOAD_CHART_SHOW_WHAT.getValue() == 2);
        rbShowSum.setOnAction(e -> ProgConfig.DOWNLOAD_CHART_SHOW_WHAT.setValue(2));
        RadioMenuItem rbAll = new RadioMenuItem("alle Downloads immer anzeigen");
        RadioMenuItem rbOnlyExisting = new RadioMenuItem("nur noch vorhandene Downloads anzeigen");
        RadioMenuItem rbOnlyRunning = new RadioMenuItem("nur aktuell laufende Downloads anzeigen");
        ToggleGroup group = new ToggleGroup();
        rbAll.setToggleGroup(group);
        rbOnlyExisting.setToggleGroup(group);
        rbOnlyRunning.setToggleGroup(group);
        rbAll.setSelected(this.chartOnlyExistingProp.getValue() == false && this.chartOnlyRunningProp.getValue() == false);
        rbOnlyExisting.selectedProperty().bindBidirectional(this.chartOnlyExistingProp);
        rbOnlyRunning.selectedProperty().bindBidirectional(this.chartOnlyRunningProp);
        rbAll.disableProperty().bind(rbShowAll.selectedProperty().not().and(rbShowDown.selectedProperty().not()));
        rbOnlyExisting.disableProperty().bind(rbShowAll.selectedProperty().not().and(rbShowDown.selectedProperty().not()));
        rbOnlyRunning.disableProperty().bind(rbShowAll.selectedProperty().not().and(rbShowDown.selectedProperty().not()));
        MenuItem delData = new MenuItem("Diagramm l\u00f6schen");
        delData.setOnAction(e -> this.clearChart());
        ContextMenu cm = new ContextMenu();
        cm.getItems().addAll((MenuItem[])new MenuItem[]{cmiTime, new SeparatorMenuItem(), rbShowAll, rbShowDown, rbShowSum, new SeparatorMenuItem(), rbAll, rbOnlyExisting, rbOnlyRunning, new SeparatorMenuItem(), delData});
        return cm;
    }
}

