/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.infoPane;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class PaneAboInfo
extends VBox {
    private final TextArea txtInfo = new TextArea();
    private final TextField txtName = new TextField("");
    private final Label lblSender = new Label();
    private final Label lblThema = new Label();
    private final CheckBox chkExact = new CheckBox();
    private final Label lblThemaTitel = new Label();
    private final Label lblTitel = new Label();
    private final Label lblSomewhere = new Label();
    private AboData abo = null;

    public PaneAboInfo() {
        VBox.setVgrow(this, Priority.ALWAYS);
        this.txtName.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        this.txtName.setTooltip(new Tooltip("Name des Abos"));
        this.txtInfo.setWrapText(true);
        this.txtInfo.setPrefRowCount(4);
        this.txtInfo.setTooltip(new Tooltip("Beschreibung des Abos"));
        GridPane gridPaneLeft = new GridPane();
        gridPaneLeft.setHgap(5.0);
        gridPaneLeft.setVgap(5.0);
        gridPaneLeft.setPadding(new Insets(10.0));
        GridPane.setVgrow(this.txtInfo, Priority.ALWAYS);
        gridPaneLeft.add(this.txtName, 0, 0);
        gridPaneLeft.add(this.txtInfo, 0, 1);
        gridPaneLeft.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        VBox.setVgrow(gridPaneLeft, Priority.ALWAYS);
        GridPane gridPaneRight = new GridPane();
        gridPaneRight.getStyleClass().add("extra-pane-info");
        gridPaneRight.setHgap(5.0);
        gridPaneRight.setVgap(5.0);
        gridPaneRight.setPadding(new Insets(10.0));
        gridPaneRight.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        this.chkExact.setDisable(true);
        int row = 0;
        gridPaneRight.add(new Label("Sender: "), 0, row);
        gridPaneRight.add(this.lblSender, 1, row);
        gridPaneRight.add(new Label("Thema: "), 0, ++row);
        gridPaneRight.add(this.lblThema, 1, row);
        gridPaneRight.add(new Label("Exakt: "), 0, ++row);
        gridPaneRight.add(this.chkExact, 1, row);
        gridPaneRight.add(new Label("Thema-Titel: "), 0, ++row);
        gridPaneRight.add(this.lblThemaTitel, 1, row);
        gridPaneRight.add(new Label("Titel: "), 0, ++row);
        gridPaneRight.add(this.lblTitel, 1, row);
        gridPaneRight.add(new Label("Irgendwo: "), 0, ++row);
        gridPaneRight.add(this.lblSomewhere, 1, row);
        SplitPane splitPane = new SplitPane();
        splitPane.getItems().addAll((Node[])new Node[]{gridPaneLeft, gridPaneRight});
        ((SplitPane.Divider)splitPane.getDividers().get(0)).positionProperty().bindBidirectional(ProgConfig.ABO_PANE_INFO_DIVIDER);
        SplitPane.setResizableWithParent(gridPaneRight, false);
        VBox.setVgrow(splitPane, Priority.ALWAYS);
        this.setSpacing(0.0);
        this.setPadding(new Insets(0.0));
        this.getChildren().add(splitPane);
    }

    public void setAbo(AboData newAbo) {
        if (this.abo != null) {
            this.txtName.textProperty().unbindBidirectional(this.abo.nameProperty());
            this.txtInfo.textProperty().unbindBidirectional(this.abo.descriptionProperty());
            this.lblSender.textProperty().unbindBidirectional(this.abo.channelProperty());
            this.lblThema.textProperty().unbindBidirectional(this.abo.themeProperty());
            this.chkExact.selectedProperty().unbindBidirectional(this.abo.themeExactProperty());
            this.lblThemaTitel.textProperty().unbindBidirectional(this.abo.themeTitleProperty());
            this.lblTitel.textProperty().unbindBidirectional(this.abo.titleProperty());
            this.lblSomewhere.textProperty().unbindBidirectional(this.abo.somewhereProperty());
        }
        this.abo = newAbo;
        if (newAbo == null) {
            this.txtName.setText("");
            this.txtInfo.setText("");
            this.lblSender.setText("");
            this.lblThema.setText("");
            this.chkExact.setSelected(false);
            this.lblThemaTitel.setText("");
            this.lblTitel.setText("");
            this.lblSomewhere.setText("");
            return;
        }
        this.txtName.textProperty().bindBidirectional(this.abo.nameProperty());
        this.txtInfo.textProperty().bindBidirectional(this.abo.descriptionProperty());
        this.lblSender.textProperty().bindBidirectional(this.abo.channelProperty());
        this.lblThema.textProperty().bindBidirectional(this.abo.themeProperty());
        this.chkExact.selectedProperty().bindBidirectional(this.abo.themeExactProperty());
        this.lblThemaTitel.textProperty().bindBidirectional(this.abo.themeTitleProperty());
        this.lblTitel.textProperty().bindBidirectional(this.abo.titleProperty());
        this.lblSomewhere.textProperty().bindBidirectional(this.abo.somewhereProperty());
    }
}

