/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter.live;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.livesearch.JsonInfoDto;
import de.p2tools.mtplayer.controller.livesearch.LiveSearchArd;
import de.p2tools.mtplayer.controller.livesearch.tools.LiveFactory;
import de.p2tools.mtplayer.gui.filter.helper.PCboString;
import de.p2tools.p2lib.guitools.P2GuiTools;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tab;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class LiveFilterTabArd
extends Tab {
    private final ProgData progData;
    private final JsonInfoDto jsonInfoDto = new JsonInfoDto();
    private final ProgressBar progress = new ProgressBar();
    private final VBox vBoxTab = new VBox();

    public LiveFilterTabArd() {
        super("ARD");
        this.progData = ProgData.getInstance();
        this.setClosable(false);
        ProgConfig.LIVE_FILM_GUI_SEARCH_ARD.addListener((u, o, n) -> this.jsonInfoDto.init());
        this.addTabArd();
        this.addProgress();
    }

    private void addTabArd() {
        this.vBoxTab.setSpacing(10.0);
        this.vBoxTab.setPadding(new Insets(10.0));
        this.vBoxTab.setAlignment(Pos.TOP_CENTER);
        Button btnClear = new Button();
        btnClear.setGraphic(ProgIcons.ICON_BUTTON_CLEAR.getImageView());
        btnClear.setTooltip(new Tooltip("Suche l\u00f6schen"));
        btnClear.setOnAction(a -> ProgConfig.LIVE_FILM_GUI_SEARCH_ARD.set(""));
        Button btnSearchArd = new Button();
        btnSearchArd.setGraphic(ProgIcons.ICON_BUTTON_SEARCH.getImageView());
        btnSearchArd.setTooltip(new Tooltip("Suche starten"));
        btnSearchArd.setOnAction(a -> this.searchArd(false));
        btnSearchArd.disableProperty().bind(ProgConfig.LIVE_FILM_GUI_SEARCH_ARD.length().lessThan(4).or(LiveFactory.getProgressProperty(LiveFactory.CHANNEL.ARD).isNotEqualTo(LiveFactory.PROGRESS_NULL)));
        Button btnKeepOnArd = new Button("Weitersuchen");
        btnKeepOnArd.setGraphic(ProgIcons.ICON_BUTTON_FORWARD.getImageView());
        btnKeepOnArd.setTooltip(new Tooltip("Weitersuchen"));
        btnKeepOnArd.setOnAction(a -> this.searchArd(true));
        btnKeepOnArd.disableProperty().bind(this.jsonInfoDto.nextUrlProperty().isEmpty().or(LiveFactory.getProgressProperty(LiveFactory.CHANNEL.ARD).isNotEqualTo(LiveFactory.PROGRESS_NULL)));
        PCboString cboSearch = new PCboString(this.progData.stringFilterLists.getFilterListLiveArd(), ProgConfig.LIVE_FILM_GUI_SEARCH_ARD);
        VBox vBox = new VBox();
        vBox.setSpacing(2.0);
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.getChildren().addAll((Node[])new Node[]{cboSearch, btnClear});
        HBox.setHgrow(cboSearch, Priority.ALWAYS);
        vBox.getChildren().addAll((Node[])new Node[]{new Label("Livesuche ARD"), hBox});
        hBox = new HBox();
        hBox.setPadding(new Insets(2.0, 0.0, 0.0, 0.0));
        hBox.setSpacing(10.0);
        hBox.setAlignment(Pos.CENTER_RIGHT);
        hBox.getChildren().addAll((Node[])new Node[]{btnKeepOnArd, btnSearchArd});
        vBox.getChildren().add(hBox);
        this.vBoxTab.getChildren().add(vBox);
        Button btnClearUrl = new Button();
        btnClearUrl.setGraphic(ProgIcons.ICON_BUTTON_CLEAR.getImageView());
        btnClearUrl.setTooltip(new Tooltip("Suche l\u00f6schen"));
        btnClearUrl.setOnAction(a -> ProgConfig.LIVE_FILM_GUI_SEARCH_URL_ARD.set(""));
        Button btnSearchUrlArd = new Button();
        btnSearchUrlArd.setGraphic(ProgIcons.ICON_BUTTON_SEARCH.getImageView());
        btnSearchUrlArd.setTooltip(new Tooltip("Suche starten"));
        btnSearchUrlArd.setOnAction(a -> this.searchUrl());
        btnSearchUrlArd.disableProperty().bind(ProgConfig.LIVE_FILM_GUI_SEARCH_URL_ARD.isEmpty().or(LiveFactory.getProgressProperty(LiveFactory.CHANNEL.ARD).isNotEqualTo(LiveFactory.PROGRESS_NULL)));
        PCboString cboSearchUrl = new PCboString(this.progData.stringFilterLists.getFilterListLiveArdUrl(), ProgConfig.LIVE_FILM_GUI_SEARCH_URL_ARD);
        vBox = new VBox(2.0);
        hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.getChildren().addAll((Node[])new Node[]{cboSearchUrl, btnClearUrl});
        HBox.setHgrow(cboSearchUrl, Priority.ALWAYS);
        vBox.getChildren().addAll((Node[])new Node[]{new Label("URL ARD-Filmseite"), hBox});
        hBox = new HBox();
        hBox.setPadding(new Insets(2.0, 0.0, 0.0, 0.0));
        hBox.setSpacing(10.0);
        hBox.setAlignment(Pos.CENTER_RIGHT);
        hBox.getChildren().addAll((Node[])new Node[]{btnSearchUrlArd});
        vBox.getChildren().add(hBox);
        this.vBoxTab.getChildren().add(vBox);
        this.setContent(this.vBoxTab);
    }

    private void searchArd(boolean next) {
        new Thread(() -> new LiveSearchArd().loadLive(this.jsonInfoDto, next)).start();
    }

    private void searchUrl() {
        new Thread(() -> new LiveSearchArd().loadUrl(this.jsonInfoDto)).start();
    }

    private void addProgress() {
        this.progress.progressProperty().bind(LiveFactory.getProgressProperty(LiveFactory.CHANNEL.ARD));
        this.progress.visibleProperty().bind(LiveFactory.getProgressProperty(LiveFactory.CHANNEL.ARD).greaterThan(-1));
        this.progress.setMaxWidth(Double.MAX_VALUE);
        this.vBoxTab.getChildren().addAll((Node[])new Node[]{P2GuiTools.getVBoxGrower(), this.progress});
        VBox.setVgrow(this.progress, Priority.ALWAYS);
    }
}

