/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter.live;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.worker.ThemeListFactory;
import de.p2tools.mtplayer.gui.filter.helper.PCboString;
import de.p2tools.p2lib.guitools.P2ButtonClearFilterFactory;
import de.p2tools.p2lib.guitools.P2MenuButton;
import java.util.function.BooleanSupplier;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class LiveFilmFilterText
extends VBox {
    private final P2MenuButton mbChannel;
    private final PCboString cboThema;
    private final PCboString cboTitle;
    private final ProgData progData = ProgData.getInstance();

    public LiveFilmFilterText() {
        BooleanSupplier booleanSupplier = () -> {
            this.progData.liveFilmFilterWorker.getActFilterSettings().reportFilterReturn();
            return true;
        };
        this.mbChannel = new P2MenuButton(this.progData.liveFilmFilterWorker.getActFilterSettings().channelProperty(), ThemeListFactory.allChannelListFilm);
        this.cboThema = new PCboString(this.progData.stringFilterLists.getFilterListLiveThema(), this.progData.liveFilmFilterWorker.getActFilterSettings().themeProperty(), booleanSupplier);
        this.cboTitle = new PCboString(this.progData.stringFilterLists.getFilterListLiveTitel(), this.progData.liveFilmFilterWorker.getActFilterSettings().titleProperty(), booleanSupplier);
        this.addFilter();
    }

    private void addFilter() {
        this.setSpacing(5.0);
        this.addTxt("Sender", this.mbChannel, this);
        this.addTxt("Thema", this.cboThema, this);
        this.addTxt("Titel", this.cboTitle, this);
        Button btnClear = P2ButtonClearFilterFactory.getPButtonClear();
        btnClear.setOnAction(a -> this.progData.liveFilmFilterWorker.clearFilter());
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER_RIGHT);
        hBox.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        hBox.getChildren().add(btnClear);
        this.getChildren().add(hBox);
    }

    private void addTxt(String txt, Node control, VBox vBoxComplete) {
        VBox vBox = new VBox(2.0);
        Label label = new Label(txt);
        vBox.getChildren().addAll((Node[])new Node[]{label, control});
        vBoxComplete.getChildren().add(vBox);
    }
}

