/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter.helper;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.filter.FilmFilter;
import de.p2tools.mtplayer.controller.filter.TextFilter;
import de.p2tools.mtplayer.controller.filter.TextFilterList;
import de.p2tools.p2lib.p2event.P2Listener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.StringConverter;

public class PCboTextFilter
extends HBox {
    private ComboBox<TextFilter> cbo = new ComboBox();
    private boolean itsMe = false;
    private final TextFilterList textFilterList;
    boolean audio;

    public PCboTextFilter(boolean audio) {
        this.audio = audio;
        this.textFilterList = audio ? ProgData.getInstance().textFilterListAudio : ProgData.getInstance().textFilterListFilm;
        this.cbo.setMaxWidth(Double.MAX_VALUE);
        this.cbo.setVisibleRowCount(10);
        this.getChildren().add(this.cbo);
        HBox.setHgrow(this.cbo, Priority.ALWAYS);
        if (audio) {
            ProgData.getInstance().pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILTER_AUDIO_CHANGED){

                @Override
                public void pingGui() {
                    PCboTextFilter.this.addNewToList(ProgData.getInstance().filterWorkerAudio.getActFilterSettings());
                }
            });
        } else {
            ProgData.getInstance().pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILTER_FILM_CHANGED){

                @Override
                public void pingGui() {
                    PCboTextFilter.this.addNewToList(ProgData.getInstance().filterWorkerFilm.getActFilterSettings());
                }
            });
        }
        this.cbo.valueProperty().addListener((u, o, n) -> {
            if (n != null) {
                if (audio) {
                    FilmFilter actFilmFilter = ProgData.getInstance().filterWorkerAudio.getActFilterSettings().getCopy();
                    actFilmFilter.setChannel(n.getChannel());
                    actFilmFilter.setExactTheme(n.getTheme());
                    actFilmFilter.setTheme(n.getTheme());
                    actFilmFilter.setThemeTitle(n.getThemeTitle());
                    actFilmFilter.setTitle(n.getTitle());
                    actFilmFilter.setSomewhere(n.getSomewhere());
                    this.itsMe = true;
                    ProgData.getInstance().filterWorkerAudio.setActFilterSettings(actFilmFilter);
                    this.itsMe = false;
                } else {
                    FilmFilter actFilmFilter = ProgData.getInstance().filterWorkerFilm.getActFilterSettings().getCopy();
                    actFilmFilter.setChannel(n.getChannel());
                    actFilmFilter.setExactTheme(n.getTheme());
                    actFilmFilter.setTheme(n.getTheme());
                    actFilmFilter.setThemeTitle(n.getThemeTitle());
                    actFilmFilter.setTitle(n.getTitle());
                    actFilmFilter.setSomewhere(n.getSomewhere());
                    this.itsMe = true;
                    ProgData.getInstance().filterWorkerFilm.setActFilterSettings(actFilmFilter);
                    this.itsMe = false;
                }
            }
        });
        this.cbo.setItems(this.textFilterList);
        this.cbo.setConverter(new StringConverter<TextFilter>(){

            @Override
            public String toString(TextFilter textFilter) {
                return "";
            }

            @Override
            public TextFilter fromString(String string) {
                return null;
            }
        });
        this.cbo.setCellFactory(cell -> new ListCell<TextFilter>(){
            final Button btnDel = new Button("");
            final HBox hBox = new HBox();
            final Label lblChannel = new Label();
            final Label lblTheme = new Label();
            final Label lblThemeTitle = new Label();
            final Label lblTitle = new Label();
            final Label lblSomewhere = new Label();
            {
                this.btnDel.setGraphic(ProgIcons.ICON_BUTTON_DEL_SW.getImageView());
                this.btnDel.getStyleClass().add("buttonVerySmall");
                this.hBox.setPadding(new Insets(0.0));
                this.hBox.setSpacing(5.0);
                this.hBox.getChildren().addAll((Node[])new Node[]{this.btnDel, this.lblChannel, this.lblTheme, this.lblThemeTitle, this.lblTitle, this.lblSomewhere});
                this.lblChannel.getStyleClass().add("lblFilmFilter");
                this.lblTheme.getStyleClass().add("lblFilmFilter");
                this.lblThemeTitle.getStyleClass().add("lblFilmFilter");
                this.lblTitle.getStyleClass().add("lblFilmFilter");
                this.lblSomewhere.getStyleClass().add("lblFilmFilter");
            }

            @Override
            protected void updateItem(TextFilter filmFilter, boolean empty) {
                super.updateItem(filmFilter, empty);
                PCboTextFilter.this.cbo.setVisibleRowCount(8);
                PCboTextFilter.this.cbo.setVisibleRowCount(10);
                if (!empty && filmFilter != null) {
                    this.btnDel.setOnMousePressed(m -> PCboTextFilter.this.textFilterList.remove(filmFilter));
                    if (!filmFilter.filterIsEmpty()) {
                        this.lblChannel.setText(PCboTextFilter.this.getSubString(filmFilter.getChannel()));
                        this.lblTheme.setText(PCboTextFilter.this.getSubString(filmFilter.getTheme()));
                        this.lblThemeTitle.setText(PCboTextFilter.this.getSubString(filmFilter.getThemeTitle()));
                        this.lblTitle.setText(PCboTextFilter.this.getSubString(filmFilter.getTitle()));
                        this.lblSomewhere.setText(PCboTextFilter.this.getSubString(filmFilter.getSomewhere()));
                    } else {
                        this.lblChannel.setText("<==>");
                    }
                    this.setGraphic(this.hBox);
                } else {
                    this.setGraphic(null);
                }
            }
        });
    }

    public ComboBox<TextFilter> getCbo() {
        return this.cbo;
    }

    private String getSubString(String s) {
        if (s.length() > 20) {
            return s.substring(0, 20) + " ...";
        }
        return s;
    }

    private synchronized void addNewToList(FilmFilter addF) {
        if (this.itsMe) {
            return;
        }
        this.cbo.getSelectionModel().clearSelection();
        TextFilter addFilter = new TextFilter(addF);
        if (addFilter.filterIsEmpty()) {
            return;
        }
        TextFilter tf = this.textFilterList.stream().filter(addFilter::filterIsSame).findFirst().orElse(null);
        if (tf == null) {
            while (this.textFilterList.size() > 15) {
                this.textFilterList.remove(this.textFilterList.size() - 1);
            }
            this.textFilterList.add(0, addFilter);
        }
    }
}

