/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter.helper;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.offer.OfferData;
import de.p2tools.mtplayer.controller.data.offer.OfferFactory;
import de.p2tools.mtplayer.gui.filter.helper.OfferFilterDialog;
import de.p2tools.p2lib.mediathek.filter.FilterCheckRegEx;
import java.util.function.BooleanSupplier;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;

public class PCboString_
extends ComboBox<PCboLabel> {
    public static final int MAX_FILTER_HISTORY = 15;
    private final ObservableList<String> storedFilterList;
    private final ObservableList<PCboLabel> itemList = FXCollections.observableArrayList(new PCboLabel(""));
    private final StringProperty strSearchProperty;
    private final BooleanSupplier doSomething;

    public PCboString_(ObservableList<String> storedFilterList, StringProperty strSearchProperty) {
        this.storedFilterList = storedFilterList;
        this.strSearchProperty = strSearchProperty;
        this.doSomething = () -> true;
        this.start();
    }

    public PCboString_(ObservableList<String> storedFilterList, StringProperty strSearchProperty, BooleanSupplier doSomething) {
        this.storedFilterList = storedFilterList;
        this.strSearchProperty = strSearchProperty;
        this.doSomething = doSomething;
        this.start();
    }

    private void start() {
        this.getEditor().setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && mouseEvent.getClickCount() == 2) {
                if (!ProgConfig.SYSTEM_USE_OFFERTABLE.get()) {
                    return;
                }
                ObservableList<OfferData> list = OfferFactory.getActiveList();
                if (list.isEmpty()) {
                    return;
                }
                this.getSelectionModel().clearSelection();
                if (list.size() > 1) {
                    SimpleObjectProperty<OfferData> prop = new SimpleObjectProperty<OfferData>();
                    new OfferFilterDialog(ProgData.getInstance(), prop);
                    if (prop.get() != null) {
                        this.getEditor().setText(((OfferData)prop.get()).getOffer());
                    }
                } else {
                    this.getEditor().setText(((OfferData)list.get(0)).getOffer());
                }
            }
        });
        this.storedFilterList.forEach(s -> {
            PCboLabel tf;
            if (!s.isEmpty() && (tf = (PCboLabel)this.itemList.stream().filter(pCboSearchLabel -> pCboSearchLabel.getText().equals(s)).findFirst().orElse(null)) == null) {
                this.itemList.add(new PCboLabel((String)s));
            }
        });
        this.setItems(this.itemList);
        this.fillStoredList();
        this.setEditable(true);
        this.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.setVisibleRowCount(15);
        this.init();
    }

    private void init() {
        new FilterCheckRegEx(this.getEditor());
        this.getEditor().textProperty().addListener((observable2, oldValue, newValue) -> {
            if (newValue == null) {
                return;
            }
            if (!this.isShowing()) {
                this.addLastFilter((String)newValue);
            }
            this.strSearchProperty.setValue(this.getEditor().getText());
        });
        this.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> {
            if (ProgConfig.SYSTEM_FILTER_RETURN.getValue().booleanValue() && (this.isShowing() || newValue != null && newValue.getClass().equals(PCboLabel.class) && !this.strSearchProperty.getValueSafe().equals(((PCboLabel)newValue).getText()))) {
                this.doSomething.getAsBoolean();
            }
        });
        this.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.doSomething.getAsBoolean();
            }
        });
        this.strSearchProperty.addListener((u, o, n) -> this.getEditor().setText(this.strSearchProperty.getValue()));
        this.getEditor().setText(this.strSearchProperty.getValue());
        this.setCellFactory(cell -> new ListCell<PCboLabel>(){
            final Button btnDel = new Button();
            final HBox hBox = new HBox();
            final Label lblFilter = new Label();
            {
                this.btnDel.setGraphic(ProgIcons.ICON_BUTTON_DEL_SW.getImageView());
                this.btnDel.getStyleClass().add("buttonVerySmall");
                this.btnDel.visibleProperty().bind(Bindings.size(PCboString_.this.itemList).greaterThan(1));
                this.hBox.setPadding(new Insets(0.0));
                this.hBox.setAlignment(Pos.CENTER_LEFT);
                this.hBox.setSpacing(5.0);
                this.hBox.getChildren().addAll((Node[])new Node[]{this.btnDel, this.lblFilter});
            }

            @Override
            protected void updateItem(PCboLabel searchLabel, boolean empty) {
                super.updateItem(searchLabel, empty);
                PCboString_.this.setVisibleRowCount(8);
                PCboString_.this.setVisibleRowCount(10);
                if (!empty && searchLabel != null) {
                    this.btnDel.setOnMousePressed(m -> {
                        if (searchLabel.getText().isEmpty()) {
                            if (PCboString_.this.itemList.size() > 1) {
                                PCboString_.this.itemList.remove(1, PCboString_.this.itemList.size());
                            }
                        } else {
                            PCboString_.this.itemList.remove(searchLabel);
                        }
                        PCboString_.this.getSelectionModel().select(0);
                        PCboString_.this.fillStoredList();
                    });
                    this.lblFilter.textProperty().bind(searchLabel.textProperty());
                    this.setGraphic(this.hBox);
                } else {
                    this.setGraphic(null);
                }
            }
        });
    }

    private synchronized void addLastFilter(String addF) {
        PCboLabel tf;
        this.getSelectionModel().clearSelection();
        PCboLabel addFilter = new PCboLabel(addF);
        if (addFilter.getText().isEmpty()) {
            return;
        }
        if (this.getItems().size() <= 1) {
            this.getItems().add(addFilter);
            return;
        }
        PCboLabel tmp = (PCboLabel)this.getItems().get(1);
        if (addF.contains(tmp.getText())) {
            tmp.setText(addF);
        }
        if ((tf = (PCboLabel)this.itemList.stream().filter(pCboSearchLabel -> pCboSearchLabel.getText().equals(addF)).findFirst().orElse(null)) == null) {
            while (this.itemList.size() > 15) {
                this.itemList.remove(this.itemList.size() - 1);
            }
            this.itemList.add(1, addFilter);
        } else {
            this.itemList.remove(tf);
            this.itemList.add(1, tf);
        }
        this.fillStoredList();
    }

    private void fillStoredList() {
        this.storedFilterList.clear();
        this.itemList.forEach(s -> this.storedFilterList.add(s.toString()));
    }

    static class PCboLabel
    extends Label
    implements Comparable<PCboLabel> {
        public PCboLabel(String value) {
            this.setText(value);
        }

        @Override
        public String toString() {
            return this.getText();
        }

        @Override
        public int compareTo(PCboLabel arg0) {
            return this.getText().compareTo(arg0.getText());
        }
    }
}

