/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter.helper;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.offer.OfferData;
import de.p2tools.mtplayer.controller.data.offer.OfferFactory;
import de.p2tools.mtplayer.gui.filter.helper.OfferFilterDialog;
import de.p2tools.p2lib.mediathek.filter.FilterCheckRegEx;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;

public class PCboString
extends ComboBox<PCboLabel> {
    public static final int MAX_FILTER_HISTORY = 20;
    private final ObservableList<String> storedFilterList;
    private final ObservableList<PCboLabel> itemList = FXCollections.observableArrayList(new PCboLabel(""));
    private final StringProperty strSearchProperty;
    private final BooleanSupplier doSomething;

    public PCboString(ObservableList<String> storedFilterList, StringProperty strSearchProperty) {
        this.storedFilterList = storedFilterList;
        this.strSearchProperty = strSearchProperty;
        this.doSomething = () -> true;
        this.start();
    }

    public PCboString(ObservableList<String> storedFilterList, StringProperty strSearchProperty, BooleanSupplier doSomething) {
        this.storedFilterList = storedFilterList;
        this.strSearchProperty = strSearchProperty;
        this.doSomething = doSomething;
        this.start();
    }

    private void start() {
        this.cleanStoredList();
        this.fillItemListWithStoredList();
        this.setEditable(true);
        this.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.setVisibleRowCount(20);
        this.initListener();
    }

    private void initListener() {
        new FilterCheckRegEx(this.getEditor());
        this.getEditor().setText(this.strSearchProperty.getValue());
        this.strSearchProperty.addListener((u, o, n) -> this.getEditor().setText(this.strSearchProperty.getValueSafe()));
        this.getEditor().setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && mouseEvent.getClickCount() == 2) {
                if (!ProgConfig.SYSTEM_USE_OFFERTABLE.get()) {
                    return;
                }
                ObservableList<OfferData> list = OfferFactory.getActiveList();
                if (list.isEmpty()) {
                    return;
                }
                if (list.size() > 1) {
                    SimpleObjectProperty<OfferData> prop = new SimpleObjectProperty<OfferData>();
                    new OfferFilterDialog(ProgData.getInstance(), prop);
                    if (prop.get() != null) {
                        this.getEditor().setText(((OfferData)prop.get()).getOffer());
                    }
                } else {
                    this.getEditor().setText(((OfferData)list.get(0)).getOffer());
                }
            }
        });
        this.getEditor().textProperty().addListener((observable2, oldValue, newValue) -> {
            if (newValue == null) {
                return;
            }
            System.out.println("==> Editor");
            this.addToStoredList(this.getEditor().getText());
            this.strSearchProperty.setValue(this.getEditor().getText());
        });
        this.showingProperty().addListener((u, o, n) -> {
            if (this.isShowing()) {
                System.out.println("showingProperty");
                this.fillItemListWithStoredList();
            }
        });
        this.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> {
            System.out.println("Aus Combo ausgew\u00e4hlt");
            if (ProgConfig.SYSTEM_FILTER_RETURN.getValue().booleanValue() && (this.isShowing() || newValue != null && newValue.getClass().equals(PCboLabel.class) && !this.strSearchProperty.getValueSafe().equals(((PCboLabel)newValue).getText()))) {
                this.doSomething.getAsBoolean();
            }
        });
        this.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.doSomething.getAsBoolean();
            }
        });
        this.setCellFactory(cell -> new ListCell<PCboLabel>(){
            final Button btnDel = new Button();
            final HBox hBox = new HBox();
            final Label lblFilter = new Label();
            {
                this.btnDel.setGraphic(ProgIcons.ICON_BUTTON_DEL_SW.getImageView());
                this.btnDel.getStyleClass().add("buttonVerySmall");
                this.btnDel.visibleProperty().bind(Bindings.size(PCboString.this.itemList).greaterThan(1));
                this.hBox.setPadding(new Insets(0.0));
                this.hBox.setAlignment(Pos.CENTER_LEFT);
                this.hBox.setSpacing(5.0);
                this.hBox.getChildren().addAll((Node[])new Node[]{this.btnDel, this.lblFilter});
            }

            @Override
            protected void updateItem(PCboLabel pCboLabel, boolean empty) {
                super.updateItem(pCboLabel, empty);
                if (!empty && pCboLabel != null) {
                    this.btnDel.setOnMousePressed(m -> {
                        if (pCboLabel.getText().isEmpty()) {
                            if (PCboString.this.itemList.size() > 1) {
                                PCboString.this.itemList.remove(1, PCboString.this.itemList.size());
                            }
                        } else {
                            PCboString.this.itemList.remove(pCboLabel);
                        }
                        PCboString.this.getSelectionModel().select(0);
                        PCboString.this.fillStoredListWithItem();
                    });
                    this.lblFilter.textProperty().bind(pCboLabel.textProperty());
                    this.setGraphic(this.hBox);
                } else {
                    this.setGraphic(null);
                }
            }
        });
    }

    private void addToStoredList(String add) {
        if (add.isEmpty()) {
            return;
        }
        if (this.storedFilterList.isEmpty()) {
            this.storedFilterList.add(add);
        } else if (add.contains((CharSequence)this.storedFilterList.get(0)) || ((String)this.storedFilterList.get(0)).contains(add)) {
            this.storedFilterList.remove(0);
            this.storedFilterList.add(0, add);
        } else {
            this.storedFilterList.add(0, add);
        }
        this.cleanStoredList();
    }

    private void cleanStoredList() {
        while (this.storedFilterList.size() > 20) {
            this.storedFilterList.remove(this.storedFilterList.size() - 1);
        }
        this.storedFilterList.setAll(this.storedFilterList.stream().filter(p -> !p.isEmpty()).distinct().collect(Collectors.toList()));
    }

    private void fillStoredListWithItem() {
        this.storedFilterList.clear();
        this.itemList.stream().filter(s -> !s.getText().isEmpty()).forEach(s -> this.storedFilterList.add(s.toString()));
        this.cleanStoredList();
    }

    private void fillItemListWithStoredList() {
        this.getSelectionModel().clearSelection();
        this.itemList.clear();
        this.itemList.add(new PCboLabel(""));
        this.storedFilterList.forEach(s -> this.itemList.add(new PCboLabel((String)s)));
        this.setItems(this.itemList);
    }

    static class PCboLabel
    extends Label
    implements Comparable<PCboLabel> {
        public PCboLabel(String value) {
            this.setText(value);
        }

        @Override
        public String toString() {
            return this.getText();
        }

        @Override
        public int compareTo(PCboLabel arg0) {
            return this.getText().compareTo(arg0.getText());
        }
    }
}

