/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter.helper;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.offer.OfferData;
import de.p2tools.mtplayer.controller.data.offer.OfferFactory;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2Button;
import javafx.beans.property.ObjectProperty;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class OfferFilterDialog
extends P2DialogExtra {
    private final Button btnOk = new Button("_Ok");
    private final Button btnCancel = new Button("_Abbrechen");
    private final CheckBox chkShow = new CheckBox("Nicht mehr anzeigen");
    private final TableView<OfferData> tableView = new TableView();
    private final ProgData progData;
    private final ObjectProperty<OfferData> offer;

    public OfferFilterDialog(ProgData progData, ObjectProperty<OfferData> offer) {
        super(progData.primaryStage, null, "Filtervorschlag", true, false, P2DialogExtra.DECO.NO_BORDER, true);
        this.progData = progData;
        this.offer = offer;
        this.init(true);
    }

    @Override
    public void close() {
        if (this.chkShow.isSelected()) {
            ProgConfig.SYSTEM_USE_OFFERTABLE.set(false);
        }
        super.close();
    }

    @Override
    public void make() {
        this.getHboxLeft().getChildren().add(this.chkShow);
        this.getHboxLeft().setAlignment(Pos.CENTER_LEFT);
        Button btnHelp = P2Button.helpButton(this.getStage(), "Filtervorschl\u00e4ge", "Hier k\u00f6nnen Filter angelegt werden, die dann als Vorschlag bei einem Doppelklick auf ein Filterfeld eingetragen werden.\nIst nur ein Vorschlag vorhanden, wird er sofort eingetragen. Sind mehrere Vorschl\u00e4ge vorhanden, kann man in einem Dialog einen ausw\u00e4hlen.\n");
        this.addHlpButton(btnHelp);
        this.addCancelButton(this.btnCancel);
        this.btnOk.setOnAction(a -> this.close());
        this.btnCancel.setOnAction(a -> {
            this.offer.set(null);
            this.close();
        });
        this.getVBoxCont().getChildren().add(this.tableView);
        VBox.setVgrow(this.tableView, Priority.ALWAYS);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tableView.setMinHeight(200.0);
        this.tableView.setMaxHeight(Double.MAX_VALUE);
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableView.getSelectionModel().selectedItemProperty().addListener((u, o, n) -> {
            if (n != null) {
                this.offer.set((OfferData)n);
            }
        });
        this.tableView.setRowFactory(param -> new TableRow<OfferData>(){

            @Override
            protected void updateItem(OfferData item, boolean empty) {
                super.updateItem(item, empty);
                this.setOnMouseClicked(event -> {
                    if (event.getButton().equals((Object)MouseButton.PRIMARY) && !this.isEmpty()) {
                        OfferFilterDialog.this.offer.set(item);
                        OfferFilterDialog.this.close();
                    }
                });
            }
        });
        TableColumn offerColumn = new TableColumn("Vorschlag");
        offerColumn.setCellValueFactory(new PropertyValueFactory("offer"));
        this.tableView.getColumns().add(offerColumn);
        this.tableView.setItems(OfferFactory.getActiveList());
    }
}

