/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter.film;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.filter.FilterDto;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ButtonClearFilterFactory;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.tools.duration.P2Duration;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;

public class FilmSmallFilterControllerFilter
extends HBox {
    private final ProgData progData;
    private final FilterDto filterDto;

    public FilmSmallFilterControllerFilter(FilterDto filterDto) {
        this.filterDto = filterDto;
        this.progData = ProgData.getInstance();
        Button btnSmall = new Button("Alle Filter anzeigen");
        if (filterDto.audio) {
            btnSmall.setOnAction(a -> ProgConfig.AUDIOFILTER_SMALL_FILTER.set(false));
        } else {
            btnSmall.setOnAction(a -> ProgConfig.FILMFILTER_SMALL_FILTER.set(false));
        }
        this.setSpacing(5.0);
        Button btnClearFilter = P2ButtonClearFilterFactory.getPButtonClearFilter();
        btnClearFilter.setOnAction(a -> this.clearFilter());
        Button btnHelp = P2Button.helpButton("Filter", "\"Sender\" und \"Thema\"\nHier kann man ausw\u00e4hlen, welche Sender und welches Thema angezeigt werden soll.\n\nDas Textfeld [Thema oder Titel] durchsucht THEMA und TITEL der Filmliste. Der Suchtext muss im Thema ODER Titel vorkommen.\n\n\"Zeitraum\" und \"Filml\u00e4nge\" finden Filme die in dem vorgegebenem Zeitraum liefen und die vorgegebene L\u00e4nge haben.\n\n==================================================\nGro\u00df- und Kleinschreibung wird beim Suchen nicht unterschieden.\n\nUm mehrere Begriffe zu suchen m\u00fcssen diese durch Komma oder Doppelpunkt getrennt werden. Das Komma verkn\u00fcpft die Begriffe mit ODER (=> mindestens einer der Begriffe muss vorkommen), der Doppelpunkt mit UND (=> alle Begriffe m\u00fcssen vorkommen).\n\n'Tagesschau' findet u.a. 'Tagesschau, 12:00 Uhr', 'ARD Tagesschau Livestream', 'Bei Logo und der Tagesschau'.\n\n'Sport,Fussball' (Komma-getrennt) findet Filme bei denen 'Sport' oder 'Fussball' oder beides vorkommt, u.a. 'Wintersport im Mumintal' und 'Wie wird man Fussballprofi?'.\n\n'Sport:Fussball' (Doppelpunkt-getrennt) findet nur Dateien bei denen beides ('Sport' und 'Fussball') vorkommt, z.B. 'Wintersport, Fussball und Formel 1'.\n\n");
        this.setAlignment(Pos.CENTER_RIGHT);
        this.getChildren().addAll((Node[])new Node[]{btnSmall, P2GuiTools.getHBoxGrower(), btnHelp, btnClearFilter});
    }

    private void clearFilter() {
        P2Duration.onlyPing("Filter l\u00f6schen");
        this.filterDto.filterWorker.clearFilter();
    }
}

