/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter.film;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.filter.FilterDto;
import de.p2tools.mtplayer.controller.worker.ThemeListFactory;
import de.p2tools.mtplayer.gui.filter.helper.PCboString;
import de.p2tools.mtplayer.gui.filter.helper.PCboThemeExact;
import de.p2tools.p2lib.guitools.P2MenuButton;
import java.util.function.BooleanSupplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;

public class FilmFilterControllerTextFilter
extends VBox {
    private final P2MenuButton mbChannel;
    private final PCboThemeExact cboThemeExact;
    private final PCboString cboTheme;
    private final PCboString cboThemeTitle;
    private final PCboString cboTitle;
    private final PCboString cboSomewhere;
    private final PCboString cboUrl;
    private final ProgData progData;
    private final FilterDto filterDto;

    public FilmFilterControllerTextFilter(FilterDto filterDto) {
        this.filterDto = filterDto;
        this.progData = ProgData.getInstance();
        this.mbChannel = new P2MenuButton(filterDto.filterWorker.getActFilterSettings().channelProperty(), filterDto.audio ? ThemeListFactory.allChannelListAudio : ThemeListFactory.allChannelListFilm);
        BooleanSupplier supplierReportReturn = () -> {
            filterDto.filterWorker.getActFilterSettings().reportFilterReturn();
            return true;
        };
        this.cboThemeExact = new PCboThemeExact(this.progData, filterDto);
        this.cboTheme = new PCboString(this.progData.stringFilterLists.getFilterListFilmTheme(), filterDto.filterWorker.getActFilterSettings().themeProperty(), supplierReportReturn);
        this.cboThemeTitle = new PCboString(this.progData.stringFilterLists.getFilterListFilmThemeTitle(), filterDto.filterWorker.getActFilterSettings().themeTitleProperty(), supplierReportReturn);
        this.cboTitle = new PCboString(this.progData.stringFilterLists.getFilterListFilmTitel(), filterDto.filterWorker.getActFilterSettings().titleProperty(), supplierReportReturn);
        this.cboSomewhere = new PCboString(this.progData.stringFilterLists.getFilterListFilmSomewhere(), filterDto.filterWorker.getActFilterSettings().somewhereProperty(), supplierReportReturn);
        this.cboUrl = new PCboString(this.progData.stringFilterLists.getFilterListFilmUrl(), filterDto.filterWorker.getActFilterSettings().urlProperty(), supplierReportReturn);
        this.setSpacing(5.0);
        this.addFilter();
    }

    private void addFilter() {
        this.addTxt("Sender", this.mbChannel, this, this.filterDto.filterWorker.getActFilterSettings().channelVisProperty());
        SimpleBooleanProperty b = new SimpleBooleanProperty();
        b.bind(this.filterDto.filterWorker.getActFilterSettings().themeVisProperty().and(this.filterDto.filterWorker.getActFilterSettings().themeIsExactProperty().not()));
        this.addTxt("Thema", this.cboTheme, this, b);
        b = new SimpleBooleanProperty();
        b.bind(this.filterDto.filterWorker.getActFilterSettings().themeVisProperty().and(this.filterDto.filterWorker.getActFilterSettings().themeIsExactProperty()));
        this.addTxt("Thema exakt", this.cboThemeExact, this, b);
        this.addTxt("Thema oder Titel", this.cboThemeTitle, this, this.filterDto.filterWorker.getActFilterSettings().themeTitleVisProperty());
        this.addTxt("Titel", this.cboTitle, this, this.filterDto.filterWorker.getActFilterSettings().titleVisProperty());
        this.addTxt("Irgendwo", this.cboSomewhere, this, this.filterDto.filterWorker.getActFilterSettings().somewhereVisProperty());
        this.addTxt("URL", this.cboUrl, this, this.filterDto.filterWorker.getActFilterSettings().urlVisProperty());
        this.visibleProperty().bind(this.filterDto.filterWorker.getActFilterSettings().channelVisProperty().or(this.filterDto.filterWorker.getActFilterSettings().themeVisProperty().or(this.filterDto.filterWorker.getActFilterSettings().themeTitleVisProperty().or(this.filterDto.filterWorker.getActFilterSettings().titleVisProperty().or(this.filterDto.filterWorker.getActFilterSettings().somewhereVisProperty().or(this.filterDto.filterWorker.getActFilterSettings().urlVisProperty()))))));
        this.managedProperty().bind(this.visibleProperty());
    }

    private void addTxt(String txt, Node control, VBox vBoxComplete, BooleanProperty booleanProperty) {
        VBox vBox = new VBox(2.0);
        Label label = new Label(txt);
        vBox.getChildren().addAll((Node[])new Node[]{label, control});
        vBoxComplete.getChildren().add(vBox);
        vBox.visibleProperty().bind(booleanProperty);
        vBox.managedProperty().bind(booleanProperty);
    }
}

