/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter.film;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.filter.FilterDto;
import de.p2tools.mtplayer.gui.filter.film.FilmFilterEditDialog;
import de.p2tools.mtplayer.gui.filter.helper.PCboTextFilter;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ButtonClearFilterFactory;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.tools.duration.P2Duration;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class FilmFilterControllerClearFilter
extends VBox {
    private final Button btnClearFilter = P2ButtonClearFilterFactory.getPButtonClearFilter();
    private final Button btnEditFilter = new Button("");
    private final Button btnGoBack = new Button("");
    private final Button btnGoForward = new Button("");
    private final PCboTextFilter cboTextFilter = new PCboTextFilter(false);
    private final ProgData progData;
    private final FilterDto filterDto;

    public FilmFilterControllerClearFilter(FilterDto filterDto) {
        this.filterDto = filterDto;
        this.progData = ProgData.getInstance();
        this.setSpacing(5.0);
        this.addButton();
    }

    private void addButton() {
        this.btnGoBack.setGraphic(ProgIcons.ICON_BUTTON_BACKWARD.getImageView());
        this.btnGoBack.setOnAction(a -> this.filterDto.filterWorker.getBackwardFilmFilter().goBackward());
        this.btnGoBack.disableProperty().bind(this.filterDto.filterWorker.getBackwardFilterList().emptyProperty().or(this.filterDto.filterWorker.getBackwardFilterList().sizeProperty().isEqualTo(1)));
        this.btnGoBack.setTooltip(new Tooltip("letzte Filtereinstellung wieder herstellen"));
        this.btnGoForward.setGraphic(ProgIcons.ICON_BUTTON_FORWARD.getImageView());
        this.btnGoForward.setOnAction(a -> this.filterDto.filterWorker.getBackwardFilmFilter().goForward());
        this.btnGoForward.disableProperty().bind(this.filterDto.filterWorker.getForwardFilterList().emptyProperty());
        this.btnGoForward.setTooltip(new Tooltip("letzte Filtereinstellung wieder herstellen"));
        this.btnClearFilter.setOnAction(a -> this.clearFilter());
        this.btnEditFilter.setGraphic(ProgIcons.ICON_BUTTON_EDIT.getImageView());
        this.btnEditFilter.setOnAction(a -> new FilmFilterEditDialog(this.progData, this.filterDto));
        this.btnEditFilter.setTooltip(new Tooltip("Filter ein/ausschalten"));
        HBox hBox1 = new HBox(5.0);
        hBox1.getChildren().addAll((Node[])new Node[]{this.btnEditFilter, P2GuiTools.getHBoxGrower(), this.btnGoBack, this.btnGoForward, P2GuiTools.getHBoxGrower(), this.btnClearFilter});
        Button btnHelp = P2Button.helpButton("Filter", "Die Men\u00fcs, Textfelder und Schieberegler erlauben ein detailliertes Durchsuchen und Filtern der vorhandenen Filme.\n\nIm Bereich darunter k\u00f6nnen ganze Such-/Filtereinstellungen als Profile angelegt und verwaltet werden.\n\nDarunter wird ein Schalter zum Ein/Ausschalten der Blacklist angezeigt. (Aber nur wenn in den Programm-Einstellungen > Blacklist diese eingeschaltet ist)\n  - Blacklist aus: Alle Filme werden angezeigt.\n  - Blacklist ein: Von der Blacklist erfasste Filme werden nicht angezeigt.\n  - Blacklist invers: Nur von der Blacklist erfasste Filme werden angezeigt.\n\nDie Buttons \"<\" und \">\" bl\u00e4ttern durch die letzten Filtereinstellungen.\nIn dem Man\u00fc darunter werden die zuletzt verwendeten Textfilter angezeigt und k\u00f6nnen damit wieder ausgew\u00e4hlt werden.\n\nDer Filter-Einstellungsbutton (das Zahnrad) \u00f6ffnet einen Dialog in dem die einzelnen Filter ein- oder ausgeschaltet werden k\u00f6nnen.\nZ.B. kann dort das Suchfeld: \"Thema\" f\u00fcr freies Suchen umgeschaltet werden. Angezeigt werden immer nur eingeschaltete Filter.\n\n-- Men\u00fcs \"Sender\" und \"Thema\" --\nDie Eintr\u00e4ge der Filtermen\u00fcs \"Sender\" und \"Thema\" werden automatisch aus der Filmliste erstellt.\n\n\n-- Suchen und Filtern --\nMit den Textfeldern ([Thema] wenn freie Suche eingeschaltet, [Thema oder Titel], [Titel], [Irgendwo] und [URL]) kann sehr detailliert gesucht werden. \"Zeitraum\", \"Filml\u00e4nge\", \"Sendezeit\" (ein- oder ausschlie\u00dfen), \"anzeigen\" und \"ausschlie\u00dfen\" erlauben noch weitergehende Filterung.\n\n-- Besonderheiten --\n[Thema oder Titel] durchsucht THEMA und TITEL der Filmliste. [Irgendwo] sucht au\u00dferdem noch in BESCHREIBUNG und DATUM. \nBei einer Suche nach mehreren Suchbegriffen m\u00fcssen hier alle Suchbegriffe im selben Datenfeld vorkommen. Ein Film mit 'Sport' in THEMA und 'Fussball' in TITEL wird von 'Sport:Fussball' nicht erfasst.\n\n[URL] sucht in der URL des Films sowie in der URL der Webseite des Films.\n\n\n==================================================\nMit den Textfeldern kann nach einem w\u00f6rtlichen Suchtext (Suchtext muss enthalten sein/oder darf nicht enthalten sein) oder nach regul\u00e4ren Ausdr\u00fccken (RegExp) gesucht werden.\n\nGro\u00df- und Kleinschreibung wird bei beiden Arten der Suche nicht unterschieden.\n\n-- W\u00f6rtlicher Suchtext muss enthalten sein --\nEin w\u00f6rtlicher Suchtext findet alle Dateien bei denen der Suchtext an beliebiger Stelle im durchsuchten Bereich enthalten ist.\n\nW\u00f6rtlicher Suchtext muss in \" angegeben werden. Dann wird alles gefunden, was im durchsuchten Bereich den Inhalt zwischen den \" enth\u00e4lt. Hier sind auch \",\" und \":\" erlaubt. Der gesamte Suchtext muss aber in \" eingeschlossen werden, z.B.\n\"das, das und das wird gesucht\"\nDann muss der durchsuchte Bereich genau das \"das, das und das wird gesucht\" enthalten (ohne die \").\nEine Suche mit RegEx, z.B. \"#:.*pass,+.*\" kann damit verk\u00fcrzt werden: \"pass,\". Das ist k\u00fcrzer und l\u00e4uft im Programm auch schneller.\n\nUm mehrere Begriffe zu suchen m\u00fcssen diese durch Komma oder Doppelpunkt getrennt werden. Das Komma verkn\u00fcpft die Begriffe mit ODER (=> mindestens einer der Begriffe muss vorkommen), der Doppelpunkt mit UND (=> alle Begriffe m\u00fcssen vorkommen).\n\n\n-- W\u00f6rtlicher Suchtext darf nicht enthalten sein --\nDer Suchtext muss mit '!:' (ohne die ' ') beginnen.\nEin w\u00f6rtlicher Suchtext schlie\u00dft alle Dateien aus, bei denen der Suchtext an beliebiger Stelle im durchsuchten Bereich enthalten ist.\n\nUm mehrere Begriffe auszuschlie\u00dfen, m\u00fcssen diese durch Komma oder Doppelpunkt getrennt werden. Das Komma verkn\u00fcpft die Begriffe mit ODER (=> mindestens einer der Begriffe muss enthalten sein) und der Doppelpunkt verkn\u00fcpft die Begriffe mit UND (=> alle Begriffe m\u00fcssen enthalten sein, damit der Beitrag ausgeschlossen wird).\n\n\nSuchtext und Suchbegriffe d\u00fcrfen Leerzeichen enthalten, aber kein Komma und keinen Doppelpunkt (wenn der gesamte Suchtext nicht in \" eingeschlossen ist.)\n\nBeispiele:\n'Tagesschau' findet u.a. 'Tagesschau, 12:00 Uhr', 'ARD Tagesschau Livestream', 'Bei Logo und der Tagesschau'.\n'Sport,Fussball' (Komma-getrennt) findet Filme bei denen 'Sport' oder 'Fussball' oder beides vorkommt, u.a. 'Wintersport im Mumintal' und 'Wie wird man Fussballprofi?'.\n'Sport:Fussball' (Doppelpunkt-getrennt) findet nur Dateien bei denen beides ('Sport' und 'Fussball') vorkommt, z.B. 'Wintersport, Fussball und Formel 1'.\n\n'!:Auto,Motorrad', es werden nur Beitr\u00e4ge gefunden, die weder \"Auto\" noch \"Motorrad\" enthalten.\n'!:Auto:Motorrad', es werden Beitr\u00e4ge gefunden, die \"Auto\" *und* \"Motorrad\" *nicht* enthalten.\n\n-- Regul\u00e4re Ausdr\u00fccke --\nEin Suchtext aus regul\u00e4ren Ausdr\u00fccken (RegExp) muss mit '#:' (ohne die ' ') beginnen.\n\nBeliebige Zeichen mit in die Suche aufnehmen (als '.+', '.*' oder '.?'') macht einen Unterschied!\n\nBeispiele:\n'#:Burger' oder '#:^burger$' -- beide finden 'Burger' und 'burger' und nichts sonst.\n'#:Burger.+' findet nicht 'Burger', aber alles was nach 'Burger' noch Zeichen enth\u00e4lt (z.B. 'Burger f\u00fcr die Straubing Tigers').\n'#:.+burger' findet alles was auf 'burger' oder 'Burger' endet (z.B. 'Der Hamburger' und '1. Burger').\n\nMehr zu regul\u00e4ren Ausdr\u00fccken:\nhttps://de.wikipedia.org/wiki/Regul%C3%A4rer_Ausdruck\n\n");
        HBox hBox2 = new HBox(5.0);
        hBox2.getChildren().addAll((Node[])new Node[]{this.cboTextFilter, btnHelp});
        HBox.setHgrow(this.cboTextFilter, Priority.ALWAYS);
        this.getChildren().addAll((Node[])new Node[]{hBox1, hBox2});
    }

    private void clearFilter() {
        P2Duration.onlyPing("Filter l\u00f6schen");
        this.filterDto.filterWorker.clearFilter();
    }
}

