/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter.film;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.filter.FilterDto;
import de.p2tools.mtplayer.controller.filter.FilterWorker;
import de.p2tools.mtplayer.gui.filter.FilterController;
import de.p2tools.mtplayer.gui.filter.film.FilmFilterControllerBlacklist;
import de.p2tools.mtplayer.gui.filter.film.FilmFilterControllerClearFilter;
import de.p2tools.mtplayer.gui.filter.film.FilmFilterControllerFilter;
import de.p2tools.mtplayer.gui.filter.film.FilmFilterControllerOnlyNew;
import de.p2tools.mtplayer.gui.filter.film.FilmFilterControllerProfiles;
import de.p2tools.mtplayer.gui.filter.film.FilmFilterControllerTextFilter;
import de.p2tools.mtplayer.gui.filter.film.FilmSmallFilterControllerFilter;
import de.p2tools.p2lib.guitools.P2GuiTools;
import javafx.scene.Node;
import javafx.scene.control.Separator;
import javafx.scene.layout.VBox;

public class FilmFilterController
extends FilterController {
    final FilmFilterControllerTextFilter filmFilterControllerTextFilter;
    final FilmFilterControllerOnlyNew filmFilterControllerOnlyNew;
    final FilmFilterControllerFilter filmFilterControllerFilter;
    final FilmFilterControllerClearFilter filmFilterControllerClearFilter;
    final FilmFilterControllerProfiles filmFilterControllerProfiles;
    final FilmFilterControllerBlacklist filmFilterControllerBlacklist;
    final FilmSmallFilterControllerFilter filmSmallFilterControllerFilter;
    private final FilterDto filterDto;

    public FilmFilterController(FilterDto filterDto) {
        this.filterDto = filterDto;
        this.filmFilterControllerTextFilter = new FilmFilterControllerTextFilter(filterDto);
        this.filmFilterControllerOnlyNew = new FilmFilterControllerOnlyNew(filterDto);
        this.filmFilterControllerFilter = new FilmFilterControllerFilter(filterDto);
        this.filmFilterControllerClearFilter = new FilmFilterControllerClearFilter(filterDto);
        this.filmFilterControllerProfiles = new FilmFilterControllerProfiles(filterDto);
        this.filmFilterControllerBlacklist = new FilmFilterControllerBlacklist(filterDto);
        this.filmSmallFilterControllerFilter = new FilmSmallFilterControllerFilter(filterDto);
        if (filterDto.audio) {
            ProgConfig.AUDIOFILTER_SMALL_FILTER.addListener((u, o, n) -> {
                this.setFilter();
                this.setGui();
            });
        } else {
            ProgConfig.FILMFILTER_SMALL_FILTER.addListener((u, o, n) -> {
                this.setFilter();
                this.setGui();
            });
        }
        this.setFilterStart();
        this.setGui();
    }

    private void setFilterStart() {
        boolean small;
        boolean bl = small = this.filterDto.audio ? ProgConfig.AUDIOFILTER_SMALL_FILTER.get() : ProgConfig.FILMFILTER_SMALL_FILTER.get();
        if (small) {
            this.filterDto.filterWorker.getActFilterSettings().copyTo(this.filterDto.filterWorker.getStoredSmallFilterSettings());
            FilterWorker.setSmallFilter(this.filterDto.filterWorker.getStoredSmallFilterSettings());
        } else {
            this.filterDto.filterWorker.getActFilterSettings().copyTo(this.filterDto.filterWorker.getStoredFilterSettings());
        }
    }

    private void setFilter() {
        boolean small;
        boolean bl = small = this.filterDto.audio ? ProgConfig.AUDIOFILTER_SMALL_FILTER.get() : ProgConfig.FILMFILTER_SMALL_FILTER.get();
        if (small) {
            this.filterDto.filterWorker.getActFilterSettings().copyTo(this.filterDto.filterWorker.getStoredFilterSettings());
            FilterWorker.setSmallFilter(this.filterDto.filterWorker.getStoredSmallFilterSettings());
            this.filterDto.filterWorker.setActFilterSettings(this.filterDto.filterWorker.getStoredSmallFilterSettings());
        } else {
            this.filterDto.filterWorker.getActFilterSettings().copyTo(this.filterDto.filterWorker.getStoredSmallFilterSettings());
            this.filterDto.filterWorker.setActFilterSettings(this.filterDto.filterWorker.getStoredFilterSettings());
        }
    }

    private void setGui() {
        boolean small;
        boolean bl = small = this.filterDto.audio ? ProgConfig.AUDIOFILTER_SMALL_FILTER.get() : ProgConfig.FILMFILTER_SMALL_FILTER.get();
        if (small) {
            this.getChildren().clear();
            VBox vBox = this.getVBoxFilter();
            vBox.getChildren().addAll((Node[])new Node[]{this.filmFilterControllerTextFilter});
            vBox.getChildren().add(P2GuiTools.getHDistance(10));
            vBox.getChildren().addAll((Node[])new Node[]{this.filmFilterControllerFilter});
            vBox.getChildren().add(P2GuiTools.getHDistance(10));
            vBox.getChildren().addAll((Node[])new Node[]{this.filmFilterControllerOnlyNew});
            vBox.getChildren().add(P2GuiTools.getVBoxGrower());
            vBox.getChildren().addAll((Node[])new Node[]{this.filmSmallFilterControllerFilter});
            this.getVBoxBlack().getChildren().add(this.filmFilterControllerBlacklist);
        } else {
            this.getChildren().clear();
            VBox vBox = this.getVBoxFilter();
            vBox.getChildren().addAll((Node[])new Node[]{this.filmFilterControllerTextFilter});
            Separator sp = new Separator();
            sp.getStyleClass().add("pseperator1");
            sp.setMinHeight(0.0);
            sp.setMaxHeight(1.0);
            sp.visibleProperty().bind(this.filmFilterControllerTextFilter.visibleProperty());
            sp.managedProperty().bind(this.filmFilterControllerTextFilter.visibleProperty());
            vBox.getChildren().add(sp);
            vBox.getChildren().addAll((Node[])new Node[]{this.filmFilterControllerFilter, P2GuiTools.getVBoxGrower(), this.filmFilterControllerClearFilter});
            this.getVBoxBlack().getChildren().add(this.filmFilterControllerProfiles);
            this.getVBoxBlack().getChildren().add(this.filmFilterControllerBlacklist);
        }
    }
}

