/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.gui.filter.helper.PCboString;
import java.util.function.BooleanSupplier;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;

public class FastFilter
extends HBox {
    private final Button btnSearch = new Button();
    private final Button btnSelectWhere = new Button();
    private final Button btnClear = new Button();
    private final PCboString cboSearch;
    private final Label lblTitel = new Label("");
    private final ProgData progData = ProgData.getInstance();
    private final boolean audio;

    public FastFilter(boolean audio) {
        this.audio = audio;
        BooleanSupplier booleanSupplier = () -> {
            if (audio) {
                this.progData.filterWorkerAudio.getFastFilterSettings().reportFilterReturn();
            } else {
                this.progData.filterWorkerFilm.getFastFilterSettings().reportFilterReturn();
            }
            return true;
        };
        this.cboSearch = audio ? new PCboString(this.progData.stringFilterLists.getFilterListFastFilterAudio(), this.progData.filterWorkerAudio.getFastFilterSettings().filterTermProperty(), booleanSupplier) : new PCboString(this.progData.stringFilterLists.getFilterListFastFilterFilm(), this.progData.filterWorkerFilm.getFastFilterSettings().filterTermProperty(), booleanSupplier);
        this.make();
    }

    private void make() {
        if (this.audio) {
            ProgConfig.FAST_AUDIO_SEARCH_ON.addListener((u, o, n) -> this.setFastSearchOnOff(true));
            ProgConfig.FAST_AUDIO_SEARCH_WHERE.addListener((u, o, n) -> this.setLblText());
            ProgConfig.AUDIO__FILTER_IS_SHOWING.addListener((observable2, oldValue, newValue) -> {
                if (ProgConfig.AUDIO__FILTER_IS_SHOWING.getValue().booleanValue() && ProgConfig.FAST_AUDIO_SEARCH_ON.getValue().booleanValue()) {
                    ProgConfig.FAST_AUDIO_SEARCH_ON.setValue(false);
                }
            });
        } else {
            ProgConfig.FAST_FILM_SEARCH_ON.addListener((u, o, n) -> this.setFastSearchOnOff(true));
            ProgConfig.FAST_FILM_SEARCH_WHERE.addListener((u, o, n) -> this.setLblText());
            ProgConfig.FILM__FILTER_IS_SHOWING.addListener((observable2, oldValue, newValue) -> {
                if (ProgConfig.FILM__FILTER_IS_SHOWING.getValue().booleanValue() && ProgConfig.FAST_FILM_SEARCH_ON.getValue().booleanValue()) {
                    ProgConfig.FAST_FILM_SEARCH_ON.setValue(false);
                }
            });
        }
        this.initText();
        this.initListener();
        this.setLblText();
        this.setFastSearchOnOff(false);
    }

    private void initText() {
        HBox hBoxTitle = new HBox(10.0);
        hBoxTitle.setAlignment(Pos.CENTER_LEFT);
        hBoxTitle.setPadding(new Insets(0.0));
        hBoxTitle.getChildren().addAll((Node[])new Node[]{this.btnSelectWhere, this.lblTitel});
        HBox hBoxCbo = new HBox(5.0);
        hBoxCbo.setAlignment(Pos.CENTER_RIGHT);
        hBoxCbo.setPadding(new Insets(0.0));
        hBoxCbo.getChildren().addAll((Node[])new Node[]{this.cboSearch, this.btnClear});
        HBox.setHgrow(this.cboSearch, Priority.ALWAYS);
        VBox vBox = new VBox(3.0);
        vBox.setAlignment(Pos.CENTER_LEFT);
        vBox.setPadding(new Insets(0.0));
        vBox.getChildren().addAll((Node[])new Node[]{hBoxTitle, hBoxCbo});
        if (this.audio) {
            vBox.visibleProperty().bind(ProgConfig.FAST_AUDIO_SEARCH_ON);
            vBox.managedProperty().bind(ProgConfig.FAST_AUDIO_SEARCH_ON);
        } else {
            vBox.visibleProperty().bind(ProgConfig.FAST_FILM_SEARCH_ON);
            vBox.managedProperty().bind(ProgConfig.FAST_FILM_SEARCH_ON);
        }
        this.btnSearch.setGraphic(ProgIcons.ICON_TOOLBAR_BUTTON_SEARCH.getImageView());
        this.btnSearch.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFunc-1"});
        this.btnSelectWhere.setGraphic(ProgIcons.ICON_BUTTON_UP_DOWN_H.getImageView());
        this.btnSelectWhere.getStyleClass().addAll((String[])new String[]{"selectButton"});
        this.btnClear.setGraphic(ProgIcons.ICON_BUTTON_CLEAR.getImageView());
        this.lblTitel.setFont(new Font(10.0));
        this.setAlignment(Pos.CENTER_RIGHT);
        this.setPadding(new Insets(1.0, 2.0, 1.0, 2.0));
        this.setSpacing(10.0);
        this.getChildren().addAll((Node[])new Node[]{vBox, this.btnSearch});
    }

    private void initListener() {
        this.btnSearch.setOnMouseClicked(mouseEvent -> {
            if (this.audio) {
                ProgConfig.FAST_AUDIO_SEARCH_ON.setValue(ProgConfig.FAST_AUDIO_SEARCH_ON.getValue() == false);
                ProgConfig.AUDIO__FILTER_IS_SHOWING.setValue(ProgConfig.FAST_AUDIO_SEARCH_ON.getValue() == false);
            } else {
                ProgConfig.FAST_FILM_SEARCH_ON.setValue(ProgConfig.FAST_FILM_SEARCH_ON.getValue() == false);
                ProgConfig.FILM__FILTER_IS_SHOWING.setValue(ProgConfig.FAST_FILM_SEARCH_ON.getValue() == false);
            }
        });
        this.btnSelectWhere.setOnMouseClicked(event -> {
            if (this.audio) {
                if (ProgConfig.FAST_AUDIO_SEARCH_WHERE.getValue() == 2) {
                    ProgConfig.FAST_AUDIO_SEARCH_WHERE.setValue(0);
                } else {
                    ProgConfig.FAST_AUDIO_SEARCH_WHERE.setValue(1 + ProgConfig.FAST_AUDIO_SEARCH_WHERE.getValue());
                }
                ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_AUDIO_CHANGED);
            } else {
                if (ProgConfig.FAST_FILM_SEARCH_WHERE.getValue() == 2) {
                    ProgConfig.FAST_FILM_SEARCH_WHERE.setValue(0);
                } else {
                    ProgConfig.FAST_FILM_SEARCH_WHERE.setValue(1 + ProgConfig.FAST_FILM_SEARCH_WHERE.getValue());
                }
                ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_FILM_CHANGED);
            }
        });
        this.btnClear.setOnAction(a -> {
            if (this.audio) {
                this.progData.filterWorkerAudio.getFastFilterSettings().clearFilter();
            } else {
                this.progData.filterWorkerFilm.getFastFilterSettings().clearFilter();
            }
        });
    }

    private void setFastSearchOnOff(boolean andSearch) {
        if (this.audio && ProgConfig.FAST_AUDIO_SEARCH_ON.getValue().booleanValue()) {
            this.getStyleClass().remove("fast-search-off");
            this.getStyleClass().add("fast-search-on");
        } else if (!this.audio && ProgConfig.FAST_FILM_SEARCH_ON.getValue().booleanValue()) {
            this.getStyleClass().remove("fast-search-off");
            this.getStyleClass().add("fast-search-on");
        } else {
            this.getStyleClass().remove("fast-search-on");
            this.getStyleClass().add("fast-search-off");
        }
        if (andSearch) {
            if (this.audio) {
                ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_AUDIO_CHANGED);
            } else {
                ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_FILM_CHANGED);
            }
        }
    }

    private void setLblText() {
        if (this.audio) {
            if (ProgConfig.FAST_AUDIO_SEARCH_WHERE.getValue() == 0) {
                this.lblTitel.setText("Thema oder Titel");
            } else if (ProgConfig.FAST_AUDIO_SEARCH_WHERE.getValue() == 1) {
                this.lblTitel.setText("Thema");
            } else {
                this.lblTitel.setText("Titel");
            }
        } else if (ProgConfig.FAST_FILM_SEARCH_WHERE.getValue() == 0) {
            this.lblTitel.setText("Thema oder Titel");
        } else if (ProgConfig.FAST_FILM_SEARCH_WHERE.getValue() == 1) {
            this.lblTitel.setText("Thema");
        } else {
            this.lblTitel.setText("Titel");
        }
    }
}

