/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadInfosFactory;
import de.p2tools.mtplayer.controller.worker.ThemeListFactory;
import de.p2tools.mtplayer.gui.filter.FilterController;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ButtonClearFilterFactory;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.P2MenuButton;
import javafx.beans.binding.Bindings;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

public class DownloadFilterController
extends FilterController {
    private final ComboBox<String> cboList = new ComboBox();
    private final ComboBox<String> cboSrc = new ComboBox();
    private final ComboBox<String> cboKind = new ComboBox();
    private final P2MenuButton mbChannel;
    private final ComboBox<String> cboAbo = new ComboBox();
    private final ComboBox<String> cboState = new ComboBox();
    private final Spinner<Integer> spinnerAnz = new Spinner(1, 9, 1);
    private final Slider sliderBandwidth = new Slider();
    private final Button btnClear = P2ButtonClearFilterFactory.getPButtonClearFilter();
    private final Label lblBandwidth = new Label();
    private final VBox vBoxFilter = this.getVBoxFilter();

    public DownloadFilterController() {
        ProgData progData = ProgData.getInstance();
        progData.downloadFilterController = this;
        this.mbChannel = new P2MenuButton(ProgConfig.FILTER_DOWNLOAD_CHANNEL, ThemeListFactory.allChannelListFilm);
        this.initLayout();
        this.initFilter();
        this.initNumberDownloads();
        DownloadInfosFactory.initBandwidth(this.sliderBandwidth, this.lblBandwidth);
    }

    private void initLayout() {
        this.addCont("Liste", this.cboList, this.vBoxFilter);
        this.addCont("Quelle", this.cboSrc, this.vBoxFilter);
        this.addCont("Downloadart", this.cboKind, this.vBoxFilter);
        this.addCont("Sender", (Control)this.mbChannel, this.vBoxFilter);
        this.addCont("Abo", this.cboAbo, this.vBoxFilter);
        this.addCont("Status", this.cboState, this.vBoxFilter);
        Button btnHelpFilter = P2Button.helpButton("Filter", "Die Filter erlauben ein detailliertes Durchsuchen und Filtern der vorhandenen Downloads.\n\n-- Men\u00fcs \"Quelle\", \"Downloadart\", \"Sender\", \"Abo\" und \"Status\" --\nDie Eintr\u00e4ge der Filtermen\u00fcs werden automatisch aus der Filmliste und Downloadliste erstellt.\n\n-- Suchen und Filtern --\n\"Quelle\" filtert nach Herkunft, also Downloads von Hand oder durch ein Abo angelegt.\n\"Downloadart\" sucht nach Downloads die direkt geladen werden k\u00f6nnen oder Downloads die durch ein externes Programm geladen werden m\u00fcssen.\n\n\"Sender\", \"Abo\", \"Status\" sucht Downloads mit dem Sender, aus dem Abo, oder mit dem Status (nicht/gestartet, fertig).\n\nMit den Schiebereglern \"gleichzeitige Downloads\" und \"max. Bandbreite\" kann die Anzahl der gleichzeitigen Downloads die geladen werden und die maximale Bandbreite, festgelegt werden.\n\nDie vorgegebene maximale Bandbreite gilt pro Download. Es sind kByte oder MByte pro Sekunde.\n1 MByte\\s braucht eine Internetbandbreite von ~ 10 MBit.\n10 MByte\\s braucht eine Internetbandbreite von ~ 100 MBit.\n\n");
        HBox hBoxClear = new HBox(10.0);
        hBoxClear.setAlignment(Pos.CENTER_RIGHT);
        hBoxClear.getChildren().addAll((Node[])new Node[]{this.btnClear});
        HBox hBoxHelp = new HBox();
        hBoxHelp.setAlignment(Pos.CENTER_RIGHT);
        hBoxHelp.getChildren().add(btnHelpFilter);
        this.vBoxFilter.getChildren().addAll((Node[])new Node[]{P2GuiTools.getVDistance(10), hBoxClear, P2GuiTools.getVBoxGrower(), hBoxHelp});
        VBox vb = new VBox(5.0);
        this.addCont("Gleichzeitige Downloads", this.spinnerAnz, vb);
        Label lblText = new Label("Max. Bandbreite: ");
        lblText.setMinWidth(0.0);
        lblText.setTooltip(new Tooltip("Maximale Bandbreite die ein einzelner Download beanspruchen darf \noder unbegrenzt wenn \"aus\""));
        this.sliderBandwidth.setTooltip(new Tooltip("Maximale Bandbreite die ein einzelner Download beanspruchen darf \noder unbegrenzt wenn \"aus\""));
        HBox h = new HBox();
        h.getChildren().addAll((Node[])new Node[]{lblText, P2GuiTools.getHBoxGrower(), this.lblBandwidth});
        this.addCont(h, (Control)this.sliderBandwidth, vb);
        this.getVBoxBlack().getChildren().add(vb);
    }

    private void initFilter() {
        this.btnClear.setOnAction(a -> this.clearFilter());
        this.cboList.getItems().addAll((String[])new String[]{"", "nur Filme", "nur Audios"});
        this.cboList.valueProperty().bindBidirectional(ProgConfig.FILTER_DOWNLOAD_LIST);
        this.cboSrc.getItems().addAll((String[])new String[]{"", "nur Downloads", "nur Abos"});
        Bindings.bindBidirectional(this.cboSrc.valueProperty(), ProgConfig.FILTER_DOWNLOAD_SOURCE, new StringConverter<String>(){

            @Override
            public String fromString(String cb) {
                switch (cb) {
                    case "": {
                        return "";
                    }
                    case "nur Abos": {
                        return "Abo";
                    }
                    case "nur Downloads": {
                        return "Download";
                    }
                }
                return "";
            }

            @Override
            public String toString(String prop) {
                switch (prop) {
                    case "": {
                        return "";
                    }
                    case "Abo": {
                        return "nur Abos";
                    }
                    case "Download": {
                        return "nur Downloads";
                    }
                }
                return "";
            }
        });
        this.cboKind.getItems().addAll((String[])new String[]{"", "nur direkte Downloads", "nur Programme"});
        Bindings.bindBidirectional(this.cboKind.valueProperty(), ProgConfig.FILTER_DOWNLOAD_TYPE, new StringConverter<String>(){

            @Override
            public String fromString(String cb) {
                switch (cb) {
                    case "": {
                        return "";
                    }
                    case "nur direkte Downloads": {
                        return "direkter Download";
                    }
                    case "nur Programme": {
                        return "Programm";
                    }
                }
                return "";
            }

            @Override
            public String toString(String prop) {
                switch (prop) {
                    case "": {
                        return "";
                    }
                    case "direkter Download": {
                        return "nur direkte Downloads";
                    }
                    case "Programm": {
                        return "nur Programme";
                    }
                }
                return "";
            }
        });
        this.cboState.getItems().addAll((String[])new String[]{"", "Noch nicht gestartet", "Gestartet, wartet noch", "Gestartet, l\u00e4uft oder wartet", "L\u00e4uft", "Fehlerhaft"});
        this.cboState.valueProperty().bindBidirectional(ProgConfig.FILTER_DOWNLOAD_STATE);
        this.cboAbo.setItems(ThemeListFactory.allAboNamesList);
        this.cboAbo.valueProperty().bindBidirectional(ProgConfig.FILTER_DOWNLOAD_ABO);
    }

    private void initNumberDownloads() {
        this.spinnerAnz.valueProperty().addListener((u, o, n) -> ProgConfig.DOWNLOAD_MAX_DOWNLOADS.setValue(this.spinnerAnz.getValue()));
        ProgConfig.DOWNLOAD_MAX_DOWNLOADS.addListener((u, o, n) -> this.spinnerAnz.getValueFactory().setValue(ProgConfig.DOWNLOAD_MAX_DOWNLOADS.getValue()));
        this.spinnerAnz.getValueFactory().setValue(ProgConfig.DOWNLOAD_MAX_DOWNLOADS.getValue());
    }

    private void clearFilter() {
        if (this.cboList.getSelectionModel() != null) {
            this.cboList.getSelectionModel().selectFirst();
        }
        if (this.cboSrc.getSelectionModel() != null) {
            this.cboSrc.getSelectionModel().selectFirst();
        }
        if (this.cboKind.getSelectionModel() != null) {
            this.cboKind.getSelectionModel().selectFirst();
        }
        ProgConfig.FILTER_DOWNLOAD_CHANNEL.setValue("");
        if (this.cboAbo.getSelectionModel() != null) {
            this.cboAbo.getSelectionModel().selectFirst();
        }
        if (this.cboState.getSelectionModel() != null) {
            this.cboState.getSelectionModel().selectFirst();
        }
    }
}

