/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog.propose;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.gui.dialog.propose.PaneCleaningList;
import de.p2tools.mtplayer.gui.dialog.propose.PanePropFilmList;
import de.p2tools.mtplayer.gui.dialog.propose.PaneProposeList;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.tools.log.P2Log;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class ProposeDialogController
extends P2DialogExtra {
    private final TabPane tabPane = new TabPane();
    private final Label lblHeader = new Label("Filme vorschlagen");
    private final ProgData progData;
    private PaneProposeList paneProposeList;
    private PaneCleaningList paneCleaningList;
    private PanePropFilmList panePropFilmList;

    public ProposeDialogController(ProgData progData, StringProperty conf) {
        super(progData.primaryStage, conf, "Download weiterf\u00fchren", true, false, P2DialogExtra.DECO.BORDER_SMALL);
        this.progData = progData;
        this.init(true);
    }

    @Override
    public void make() {
        this.getHBoxTitle().getChildren().add(this.lblHeader);
        Button btnOk = new Button("_Ok");
        Button btnHelp = P2Button.helpButton(this.getStage(), "Medien", "");
        btnOk.setOnAction(a -> this.quit());
        this.addOkButton(btnOk);
        this.addHlpButton(btnHelp);
        this.getVBoxCont().setPadding(new Insets(0.0));
        this.getVBoxCont().getChildren().add(this.tabPane);
        VBox.setVgrow(this.tabPane, Priority.ALWAYS);
        this.initPanel();
    }

    @Override
    public void close() {
        this.paneProposeList.close();
        this.paneCleaningList.close();
        this.panePropFilmList.close();
        super.close();
    }

    private void initPanel() {
        try {
            this.panePropFilmList = new PanePropFilmList(this.progData, this.getStage());
            Tab tabFilmlist = new Tab("Filme");
            tabFilmlist.setClosable(false);
            tabFilmlist.setContent(this.panePropFilmList.makePane());
            this.tabPane.getTabs().add(tabFilmlist);
            this.paneProposeList = new PaneProposeList(this.progData, this.getStage());
            Tab tabProposeList = new Tab("Vorschl\u00e4ge");
            tabProposeList.setClosable(false);
            tabProposeList.setContent(this.paneProposeList.makePane());
            this.tabPane.getTabs().add(tabProposeList);
            this.paneCleaningList = new PaneCleaningList(this.getStage(), true);
            Tab tabCleaningList = new Tab("Cleaning Liste");
            tabCleaningList.setClosable(false);
            tabCleaningList.setContent(this.paneCleaningList.makePane());
            this.tabPane.getTabs().add(tabCleaningList);
        }
        catch (Exception ex) {
            P2Log.errorLog(894210365, ex);
        }
    }

    private void quit() {
        this.close();
    }
}

