/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog.propose;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.data.propose.ProposeFactory;
import de.p2tools.mtplayer.gui.dialog.FilmInfoDialogController;
import de.p2tools.mtplayer.gui.tools.table.TableFilmFactory;
import de.p2tools.mtplayer.gui.tools.table.TableRowFilm;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.prange.P2RangeBox;
import de.p2tools.p2lib.guitools.ptable.P2CellIntNull;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PanePropFilmList {
    private final ProgData progData;
    private final Stage stage;
    private final TableView<FilmDataMTP> tableFilm = new TableView();

    public PanePropFilmList(ProgData progData, Stage stage) {
        this.progData = progData;
        this.stage = stage;
    }

    public AnchorPane makePane() {
        VBox vBox = new VBox(10.0);
        vBox.setPadding(new Insets(10.0));
        this.initTableFilm(vBox);
        this.initUnderTable(vBox);
        AnchorPane anchorPane = new AnchorPane();
        AnchorPane.setTopAnchor(vBox, 0.0);
        AnchorPane.setRightAnchor(vBox, 0.0);
        AnchorPane.setBottomAnchor(vBox, 0.0);
        AnchorPane.setLeftAnchor(vBox, 0.0);
        anchorPane.getChildren().add(vBox);
        return anchorPane;
    }

    public void close() {
    }

    private void initTableFilm(VBox vBox) {
        this.tableFilm.setMinHeight(200.0);
        this.tableFilm.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tableFilm.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        this.tableFilm.setEditable(true);
        TableColumn channelColumn = new TableColumn("Sender");
        channelColumn.setCellValueFactory(new PropertyValueFactory("channel"));
        channelColumn.getStyleClass().add("alignCenter");
        TableColumn themeColumn = new TableColumn("Thema");
        themeColumn.setCellValueFactory(new PropertyValueFactory("theme"));
        TableColumn titleColumn = new TableColumn("Titel");
        titleColumn.setCellValueFactory(new PropertyValueFactory("title"));
        TableColumn<FilmDataMTP, String> startColumn = new TableColumn<FilmDataMTP, String>("");
        TableFilmFactory.columnFactoryButton(startColumn);
        startColumn.getStyleClass().add("alignCenter");
        TableColumn dateColumn = new TableColumn("Datum");
        dateColumn.setCellValueFactory(new PropertyValueFactory("date"));
        dateColumn.getStyleClass().add("alignCenter");
        TableColumn proposeColumn = new TableColumn("Vorschlag");
        proposeColumn.setCellValueFactory(new PropertyValueFactory("propose"));
        proposeColumn.getStyleClass().add("alignCenterRight");
        TableColumn timeColumn = new TableColumn("Zeit");
        timeColumn.setCellValueFactory(new PropertyValueFactory("time"));
        timeColumn.getStyleClass().add("alignCenter");
        TableColumn durationColumn = new TableColumn("Dauer [min]");
        durationColumn.setCellFactory(new P2CellIntNull<S, T>().cellFactory);
        durationColumn.setCellValueFactory(new PropertyValueFactory("durationMinute"));
        durationColumn.getStyleClass().add("alignCenterRightPadding_25");
        channelColumn.setPrefWidth(80.0);
        themeColumn.setPrefWidth(200.0);
        titleColumn.setPrefWidth(400.0);
        this.tableFilm.getColumns().addAll(channelColumn, themeColumn, titleColumn, startColumn, proposeColumn, dateColumn, timeColumn, durationColumn);
        this.tableFilm.getSelectionModel().selectedItemProperty().addListener((observableValue, dataOld, dataNew) -> FilmInfoDialogController.getInstance().setFilm((FilmDataMTP)this.tableFilm.getSelectionModel().getSelectedItem()));
        this.tableFilm.setRowFactory(tableView -> {
            TableRowFilm row = new TableRowFilm();
            row.setOnMouseClicked(event -> {
                if (event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() == 2 && !row.isEmpty()) {
                    FilmInfoDialogController.getInstanceAndShow().showFilmInfo();
                }
            });
            return row;
        });
        this.progData.proposeList.getFilmSortedList().comparatorProperty().bind(this.tableFilm.comparatorProperty());
        this.tableFilm.setItems(this.progData.proposeList.getFilmSortedList());
        vBox.getChildren().addAll((Node[])new Node[]{this.tableFilm});
        VBox.setVgrow(this.tableFilm, Priority.ALWAYS);
    }

    private void initUnderTable(VBox vBox) {
        P2RangeBox slDur = new P2RangeBox("Filml\u00e4nge:", false, 0, 150);
        Button btnGenerate = new Button("Filme suchen");
        btnGenerate.setOnAction(a -> ProposeFactory.generateFilmList(slDur.getActMinValue(), slDur.getActMaxValue()));
        Label lblCountList = new Label();
        lblCountList.textProperty().bind(this.progData.proposeList.getFilmDataList().sizeProperty().asString());
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(0.0));
        int row = 0;
        gridPane.add(btnGenerate, 0, row);
        gridPane.add(lblCountList, 1, row);
        GridPane.setHalignment(lblCountList, HPos.RIGHT);
        gridPane.add(new Label(), 0, ++row, 2, 1);
        gridPane.add(slDur, 0, ++row, 2, 1);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        vBox.getChildren().addAll((Node[])new Node[]{gridPane});
    }
}

