/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog.downloaddialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2Button;
import java.io.File;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;

public class DownloadStopDialogController
extends P2DialogExtra {
    public static final int DOWN_STOP_DEL = 0;
    public static final int DOWN_ONLY_DEL = 1;
    public static final int DOWN_ONLY_STOP = 2;
    private final int howToDel;
    private final VBox vBoxCont;
    private final Button btnDelDlFile = new Button();
    private final Button btnDelDl = new Button("DL l\u00f6schen, Datei behalten");
    private final Button btnCancel = new Button("Abbrechen");
    private final CheckBox chkAlways = new CheckBox("Nicht mehr fragen");
    private final ObservableList<File> list;
    private final ObservableList<DownloadData> foundDownloadList;
    private P2DialogExtra.STATE state;

    public DownloadStopDialogController(ObservableList<DownloadData> foundDownloadList, ObservableList<File> list, int howToDel) {
        super(ProgData.getInstance().primaryStage, ProgConfig.DOWNLOAD_STOP_DIALOG_SIZE, "Datei l\u00f6schen", true, false, P2DialogExtra.DECO.BORDER_SMALL);
        this.foundDownloadList = foundDownloadList;
        this.list = list;
        this.howToDel = howToDel;
        this.vBoxCont = this.getVBoxCont();
        this.init(true);
    }

    public P2DialogExtra.STATE getState() {
        return this.state;
    }

    @Override
    public void make() {
        switch (this.howToDel) {
            case 0: {
                this.btnDelDlFile.setText("DL und Datei l\u00f6schen");
                this.btnDelDl.setText("DL l\u00f6schen, Datei behalten");
                break;
            }
            case 1: {
                this.btnDelDlFile.setText("Datei l\u00f6schen");
                this.btnDelDl.setText("Datei behalten");
                this.btnDelDl.setVisible(false);
                this.btnDelDl.setManaged(false);
                break;
            }
            case 2: {
                this.btnDelDlFile.setText("DL abbrechen, Datei l\u00f6schen");
                this.btnDelDl.setText("DL abbrechen, Datei behalten");
            }
        }
        this.getHBoxTitle().getChildren().add(this.list.isEmpty() ? new Label("Es liegen keine Filmdateien vor") : new Label("Filmdateien existieren bereits"));
        this.vBoxCont.setPadding(new Insets(10.0));
        this.vBoxCont.setSpacing(10.0);
        TableView<DownloadData> tableDownload = new TableView<DownloadData>();
        TableColumn themeColumn = new TableColumn("Thema");
        themeColumn.prefWidthProperty().bind(tableDownload.widthProperty().multiply(0.4));
        themeColumn.setCellValueFactory(new PropertyValueFactory("theme"));
        themeColumn.getStyleClass().add("special-column-style");
        TableColumn titleColumn = new TableColumn("Titel");
        titleColumn.prefWidthProperty().bind(tableDownload.widthProperty().multiply(0.55));
        titleColumn.setCellValueFactory(new PropertyValueFactory("title"));
        titleColumn.getStyleClass().add("special-column-style");
        tableDownload.getColumns().addAll(themeColumn, titleColumn);
        tableDownload.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        tableDownload.setItems(this.foundDownloadList);
        Text text = new Text("Downloads");
        text.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        text.getStyleClass().add("downloadGuiMediaText");
        this.vBoxCont.getChildren().addAll((Node[])new Node[]{text, tableDownload});
        TableView<File> table = new TableView<File>();
        TableColumn fileColumn = new TableColumn("Datei");
        fileColumn.prefWidthProperty().bind(table.widthProperty().multiply(0.6));
        fileColumn.setCellValueFactory(new PropertyValueFactory("name"));
        fileColumn.getStyleClass().add("special-column-style");
        TableColumn pathColumn = new TableColumn("Pfad");
        pathColumn.prefWidthProperty().bind(table.widthProperty().multiply(0.35));
        pathColumn.setCellValueFactory(new PropertyValueFactory("parent"));
        pathColumn.getStyleClass().add("special-column-style");
        table.getColumns().addAll(fileColumn, pathColumn);
        table.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        table.setItems(this.list);
        text = new Text("Dateien");
        text.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        text.getStyleClass().add("downloadGuiMediaText");
        this.vBoxCont.getChildren().addAll((Node[])new Node[]{text, table});
        this.getHBoxOverButtons().setAlignment(Pos.CENTER_RIGHT);
        this.getHBoxOverButtons().getChildren().addAll((Node[])new Node[]{this.chkAlways});
        this.btnDelDlFile.setTooltip(new Tooltip("Der Download wird abgebrochen oder gel\u00f6scht,\ndie angefangenen Filmdateien werden auch gel\u00f6scht."));
        this.btnDelDl.setTooltip(new Tooltip("Der Download wird abgebrochen oder gel\u00f6scht,\ndie angefangenen Filmdateien werden aber NICHT gel\u00f6scht."));
        this.btnCancel.setTooltip(new Tooltip("Es wird nichts abgebrochen oder gel\u00f6scht."));
        this.btnDelDlFile.setOnAction(event -> {
            this.state = P2DialogExtra.STATE.STATE_DOWN_AND_FILE;
            if (this.chkAlways.isSelected()) {
                ProgConfig.DOWNLOAD_STOP.setValue(1);
            }
            this.quit();
        });
        this.btnDelDl.setOnAction(event -> {
            this.state = P2DialogExtra.STATE.STATE_ONLY_DOWNLOAD;
            if (this.chkAlways.isSelected()) {
                ProgConfig.DOWNLOAD_STOP.setValue(2);
            }
            this.quit();
        });
        this.btnCancel.setOnAction(a -> {
            this.state = P2DialogExtra.STATE.STATE_CANCEL;
            this.quit();
        });
        Button btnHelp = P2Button.helpButton(this.getStage(), "Download abbrechen oder l\u00f6schen", "Wenn ein Download abgebrochen oder gel\u00f6scht wird, k\u00f6nnen zus\u00e4tzlich auch noch bereits geladene oder teilweise geladene Filmdateien mit gel\u00f6scht werden.\n\nWird \"Nicht mehr fragen\" angeklickt, wird die Einstellung in Zukunft immer ausgef\u00fchrt, der Dialog erscheint dann nicht mehr. Diese Einstellung kann aber in den Programmeinstellungen->Downloads auch wieder ge\u00e4ndert werden.\n");
        this.addHlpButton(btnHelp);
        this.addAnyButton(this.btnDelDlFile);
        this.addAnyButton(this.btnDelDl);
        this.addCancelButton(this.btnCancel);
    }

    private void quit() {
        this.close();
    }
}

