/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog.downloaddialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2TimePicker;
import de.p2tools.p2lib.tools.GermanStringIntSorter;
import java.util.Collection;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class DownloadStartAtTimeController
extends P2DialogExtra {
    private boolean ok = false;
    private Button btnOk = new Button("_Ok");
    private Button btnCancel = new Button("_Abbrechen");
    private final ToggleGroup toggleGroup = new ToggleGroup();
    private final P2TimePicker p2TimePicker = new P2TimePicker(true);
    private final CheckBox chkStartNow = new CheckBox();
    private final RadioButton rbAll = new RadioButton();
    private final RadioButton rbOnlySel = new RadioButton();
    private final GridPane gridPane = new GridPane();
    private final TableView<DownloadData> tableView = new TableView();
    private final SplitPane splitPane = new SplitPane();
    private final VBox vBoxTable = new VBox(10.0);
    private final VBox vBoxStart = new VBox(10.0);
    private final ObservableList<DownloadData> downloadListAll = FXCollections.observableArrayList();
    private final ObservableList<DownloadData> downloadListSel = FXCollections.observableArrayList();
    private final ProgData progData;
    private final boolean onlyAll;
    private Callback<TableColumn<DownloadData, Integer>, TableCell<DownloadData, Integer>> cellFactoryState = param -> {
        TableCell<DownloadData, Integer> cell = new TableCell<DownloadData, Integer>(){

            @Override
            public void updateItem(Integer item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                HBox hbox = new HBox();
                hbox.setSpacing(5.0);
                hbox.setAlignment(Pos.CENTER);
                hbox.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
                Button btnDownDel = new Button("");
                btnDownDel.setTooltip(new Tooltip("Download l\u00f6schen"));
                btnDownDel.setGraphic(ProgIcons.IMAGE_TABLE_DOWNLOAD_DEL.getImageView());
                btnDownDel.setOnAction(event -> {
                    DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                    if (DownloadStartAtTimeController.this.rbAll.isSelected()) {
                        DownloadStartAtTimeController.this.downloadListAll.remove(download);
                    } else {
                        DownloadStartAtTimeController.this.downloadListSel.remove(download);
                    }
                    DownloadStartAtTimeController.this.fillTable();
                });
                hbox.getChildren().addAll((Node[])new Node[]{btnDownDel});
                this.setGraphic(hbox);
            }
        };
        return cell;
    };

    public DownloadStartAtTimeController(ProgData progData, List<DownloadData> dListAll, List<DownloadData> dListSel) {
        super(progData.primaryStage, ProgConfig.DOWNLOAD_DIALOG_START_AT_TIME_SIZE, "Downloads starten", true, false, P2DialogExtra.DECO.NO_BORDER);
        this.progData = progData;
        dListAll.stream().filter(DownloadData::isNotStartedOrFinished).forEach(this.downloadListAll::add);
        dListSel.stream().filter(DownloadData::isNotStartedOrFinished).forEach(this.downloadListSel::add);
        this.onlyAll = this.downloadListSel.isEmpty();
        this.init(true);
    }

    @Override
    public void make() {
        this.addOkCancelButtons(this.btnOk, this.btnCancel);
        Button btnHelp = P2Button.helpButton(this.getStage(), "Downloads starten", "Downloads k\u00f6nnen mit einer Startzeit gestartet werden.\n\n\"Nur ausgew\u00e4hlte Downloads starten\" zeigt die markierten Downloads und\n\"Alle Downloads starten\" zeigt alle Downloads die gestartet werden k\u00f6nnen.\n\nDie Auswahl wird nur angezeigt, wenn auch Downloads markiert wurden.\n");
        this.addHlpButton(btnHelp);
        this.initGui();
        this.initRadio();
        this.initTable();
        this.initButton();
        this.initGridPane();
    }

    public boolean isOk() {
        return this.ok;
    }

    private void initGui() {
        this.p2TimePicker.disableProperty().bind(this.chkStartNow.selectedProperty());
        this.vBoxTable.setPadding(new Insets(10.0));
        SplitPane.setResizableWithParent(this.vBoxTable, true);
        if (this.onlyAll) {
            this.vBoxTable.getChildren().addAll((Node[])new Node[]{this.tableView});
        } else {
            VBox vBox = new VBox(5.0);
            vBox.getChildren().addAll((Node[])new Node[]{this.rbOnlySel, this.rbAll});
            this.vBoxTable.getChildren().addAll((Node[])new Node[]{this.tableView, vBox});
        }
        VBox.setVgrow(this.tableView, Priority.ALWAYS);
        this.vBoxStart.setPadding(new Insets(10.0));
        this.vBoxStart.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.gridPane.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.vBoxStart.getChildren().add(this.gridPane);
        this.splitPane.getItems().addAll((Node[])new Node[]{this.vBoxTable, this.vBoxStart});
        VBox.setVgrow(this.splitPane, Priority.ALWAYS);
        this.getVBoxCont().getChildren().add(this.splitPane);
    }

    private void initRadio() {
        this.rbAll.setToggleGroup(this.toggleGroup);
        this.rbOnlySel.setToggleGroup(this.toggleGroup);
        if (this.onlyAll) {
            this.rbAll.setSelected(true);
        } else {
            this.rbOnlySel.setSelected(true);
        }
        this.rbAll.selectedProperty().addListener((u, o, n) -> this.fillTable());
        this.rbOnlySel.selectedProperty().addListener((u, o, n) -> this.fillTable());
        this.rbAll.setText("Alle Downloads starten");
        this.rbOnlySel.setText("Nur ausgew\u00e4hlte Downloads starten");
    }

    private void initTable() {
        GermanStringIntSorter sorter = GermanStringIntSorter.getInstance();
        this.tableView.setTableMenuButtonVisible(true);
        this.tableView.setEditable(false);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        TableColumn startColumn = new TableColumn("");
        startColumn.setCellValueFactory(new PropertyValueFactory("guiState"));
        startColumn.setCellFactory(this.cellFactoryState);
        startColumn.getStyleClass().add("alignCenter");
        TableColumn senderColumn = new TableColumn("Sender");
        senderColumn.setCellValueFactory(new PropertyValueFactory("channel"));
        senderColumn.getStyleClass().add("alignCenter");
        TableColumn themeColumn = new TableColumn("Thema");
        themeColumn.setCellValueFactory(new PropertyValueFactory("theme"));
        themeColumn.getStyleClass().add("alignCenterLeft");
        themeColumn.setComparator(sorter);
        TableColumn titleColumn = new TableColumn("Titel");
        titleColumn.setCellValueFactory(new PropertyValueFactory("title"));
        titleColumn.getStyleClass().add("alignCenterLeft");
        titleColumn.setComparator(sorter);
        this.tableView.getColumns().addAll(startColumn, senderColumn, themeColumn, titleColumn);
        this.fillTable();
    }

    private void fillTable() {
        this.tableView.getItems().clear();
        if (this.rbAll.isSelected()) {
            this.tableView.getItems().addAll((Collection<DownloadData>)this.downloadListAll);
        } else {
            this.tableView.getItems().addAll((Collection<DownloadData>)this.downloadListSel);
        }
    }

    private void initButton() {
        this.checkBtnOk();
        this.rbAll.selectedProperty().addListener((u, o, n) -> this.checkBtnOk());
        this.rbOnlySel.selectedProperty().addListener((u, o, n) -> this.checkBtnOk());
        this.downloadListAll.addListener(c -> this.checkBtnOk());
        this.downloadListSel.addListener(c -> this.checkBtnOk());
        this.btnOk.setOnAction(event -> {
            this.ok = true;
            this.setStartTimeAndStart();
            this.close();
        });
        this.btnCancel.setOnAction(event -> {
            this.ok = false;
            this.close();
        });
    }

    private void checkBtnOk() {
        boolean ret = this.rbAll.isSelected() ? !this.downloadListAll.isEmpty() : !this.downloadListSel.isEmpty();
        this.btnOk.setDisable(!ret);
    }

    private void setStartTimeAndStart() {
        ObservableList<DownloadData> downloadList = this.rbAll.isSelected() ? this.downloadListAll : this.downloadListSel;
        if (downloadList == null || downloadList.isEmpty()) {
            return;
        }
        if (this.chkStartNow.isSelected()) {
            downloadList.forEach(download -> download.setStartTime(""));
        } else {
            String time = this.p2TimePicker.getTime();
            downloadList.forEach(download -> download.setStartTimeAlsoTomorrow(time));
        }
        downloadList.forEach(DownloadData::resetDownload);
        this.progData.downloadList.startDownloads(downloadList, false);
    }

    private void initGridPane() {
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize()});
        this.gridPane.setHgap(10.0);
        this.gridPane.setVgap(10.0);
        int row = 0;
        this.gridPane.add(new Label("Sofort starten:"), 0, row);
        this.gridPane.add(this.chkStartNow, 1, row);
        this.gridPane.add(new Label("Startzeit:"), 0, ++row);
        this.gridPane.add(this.p2TimePicker, 1, row);
    }
}

