/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog.downloaddialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2Button;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;

public class DownloadOnlyStopDialogController
extends P2DialogExtra {
    private final VBox vBoxCont;
    private final Button btnDelDl = new Button("DL l\u00f6schen, Datei behalten");
    private final Button btnCancel = new Button("Abbrechen");
    private final CheckBox chkAlways = new CheckBox("Nicht mehr fragen");
    private final boolean delete;
    private final ObservableList<DownloadData> foundDownloadList;
    private P2DialogExtra.STATE state;

    public DownloadOnlyStopDialogController(ObservableList<DownloadData> foundDownloadList, boolean delete) {
        super(ProgData.getInstance().primaryStage, ProgConfig.DOWNLOAD_ONLY_STOP_DIALOG_SIZE, "Download l\u00f6schen", true, false, P2DialogExtra.DECO.BORDER_SMALL);
        this.foundDownloadList = foundDownloadList;
        this.delete = delete;
        this.vBoxCont = this.getVBoxCont();
        this.init(true);
    }

    public P2DialogExtra.STATE getState() {
        return this.state;
    }

    @Override
    public void make() {
        if (this.delete) {
            this.btnDelDl.setText("Download l\u00f6schen");
        } else {
            this.btnDelDl.setText("Download abbrechen");
        }
        this.getHBoxTitle().getChildren().add(this.delete ? new Label("Download l\u00f6schen") : new Label("Download abbrechen"));
        this.vBoxCont.setPadding(new Insets(10.0));
        this.vBoxCont.setSpacing(10.0);
        TableView<DownloadData> table = new TableView<DownloadData>();
        TableColumn themeColumn = new TableColumn("Thema");
        themeColumn.prefWidthProperty().bind(table.widthProperty().multiply(0.4));
        themeColumn.setCellValueFactory(new PropertyValueFactory("theme"));
        themeColumn.getStyleClass().add("special-column-style");
        TableColumn titleColumn = new TableColumn("Titel");
        titleColumn.prefWidthProperty().bind(table.widthProperty().multiply(0.55));
        titleColumn.setCellValueFactory(new PropertyValueFactory("title"));
        titleColumn.getStyleClass().add("special-column-style");
        table.getColumns().addAll(themeColumn, titleColumn);
        table.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        table.setItems(this.foundDownloadList);
        this.vBoxCont.getChildren().addAll((Node[])new Node[]{table});
        this.getHBoxOverButtons().setAlignment(Pos.CENTER_RIGHT);
        this.getHBoxOverButtons().getChildren().addAll((Node[])new Node[]{this.chkAlways});
        this.btnDelDl.setTooltip(new Tooltip("Der Download wird abgebrochen oder gel\u00f6scht."));
        this.btnCancel.setTooltip(new Tooltip("Der Download wird nicht abgebrochen oder gel\u00f6scht."));
        this.btnDelDl.setOnAction(event -> {
            this.state = P2DialogExtra.STATE.STATE_OK;
            if (this.chkAlways.isSelected()) {
                ProgConfig.DOWNLOAD_ONLY_STOP.setValue(1);
            }
            this.quit();
        });
        this.btnCancel.setOnAction(a -> {
            this.state = P2DialogExtra.STATE.STATE_CANCEL;
            this.quit();
        });
        Button btnHelp = P2Button.helpButton(this.getStage(), "Download abbrechen oder l\u00f6schen", "Hier kann ein Download abgebrochen oder gel\u00f6scht werden. \n\nWird \"Nicht mehr fragen\" angeklickt, wird der Download in Zukunft immer abgebrochen oder gel\u00f6scht. Der Dialog erscheint dann nicht mehr. Diese Einstellung kann aber in den Programmeinstellungen->Downloads auch wieder ge\u00e4ndert werden.\n");
        this.addHlpButton(btnHelp);
        this.addOkCancelButtons(this.btnDelDl, this.btnCancel);
    }

    private void quit() {
        this.close();
    }
}

