/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog.downloaddialog;

import de.p2tools.mtplayer.controller.config.ProgColorList;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgConfigAskBeforeDelete;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.download.DownloadFactory;
import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.mediathek.tools.P2FileNameUtils;
import de.p2tools.p2lib.tools.P2InfoFactory;
import java.nio.file.Paths;
import java.util.Collection;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.StringProperty;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

public class DownloadContinueDialogController
extends P2DialogExtra {
    private final Label lblHeader = new Label("Die Filmdatei existiert bereits,\nwie soll der Download weitergef\u00fchrt werden?");
    private final Button btnRestartDownload = new Button("neu _Starten");
    private final Button btnCancel = new Button("_Abbrechen");
    private final Button btnContinueDownload = new Button("_Weiterf\u00fchren");
    private final CheckBox chkAlways = new CheckBox("Nicht mehr fragen");
    private final Label lblFilmTitle = new Label("ARD: Tatort, ..");
    private final TextField txtFileName = new TextField("");
    private final ComboBox<String> cbPath = new ComboBox();
    private final Label lblSizeFree = new Label("");
    private final Button btnPath = new Button("");
    private final GridPane gridPane = new GridPane();
    private final DownloadData download;
    private ProgConfigAskBeforeDelete.ContinueDownload result = ProgConfigAskBeforeDelete.ContinueDownload.CANCEL;
    private final boolean httpDownload;
    private final String oldPathFile;
    private Timeline timeline = null;
    private Integer timeSeconds = ProgConfig.SYSTEM_PARAMETER_DOWNLOAD_CONTINUE_IN_SECONDS.getValue();

    public DownloadContinueDialogController(StringProperty conf, ProgData progData, DownloadData download, boolean httpDownload) {
        super(progData.primaryStage, conf, download.getDownloadStartDto().getStartCounter() == 1 ? "Download starten" : "Download abgebrochen", true, false, P2DialogExtra.DECO.BORDER_SMALL);
        this.download = download;
        this.httpDownload = httpDownload;
        this.oldPathFile = download.getDestPathFile();
        this.init(true);
    }

    public ProgConfigAskBeforeDelete.ContinueDownload getResult() {
        return this.result;
    }

    public boolean isNewName() {
        switch (P2InfoFactory.getOs()) {
            case LINUX: {
                return !this.oldPathFile.equals(this.download.getDestPathFile());
            }
        }
        return !this.oldPathFile.equalsIgnoreCase(this.download.getDestPathFile());
    }

    @Override
    public void make() {
        this.initCont();
        this.lblFilmTitle.setStyle("-fx-font-weight: bold;");
        this.lblFilmTitle.setText(this.download.getTitle());
        this.btnContinueDownload.setVisible(this.httpDownload);
        this.btnContinueDownload.setManaged(this.httpDownload);
        if (!this.httpDownload && this.download.getSetData() == null) {
            this.txtFileName.setDisable(true);
            this.cbPath.setDisable(true);
        }
        this.initButton();
        this.initPathAndName();
        this.handleCountDownAction();
        this.timeline = new Timeline();
        this.timeline.setCycleCount(-1);
        this.timeline.getKeyFrames().add(new KeyFrame(Duration.seconds(1.0), event -> this.handleCountDownAction(), new KeyValue[0]));
        this.timeline.playFromStart();
    }

    private void initCont() {
        this.getHBoxTitle().getChildren().add(this.lblHeader);
        this.lblHeader.setMinHeight(Double.NEGATIVE_INFINITY);
        this.gridPane.setHgap(10.0);
        this.gridPane.setVgap(10.0);
        VBox.setVgrow(this.gridPane, Priority.ALWAYS);
        this.gridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        int row = 0;
        this.gridPane.add(new Label("Film:"), 0, row);
        this.gridPane.add(this.lblFilmTitle, 1, row, 2, 1);
        this.gridPane.add(new Label("Dateiname:"), 0, ++row);
        this.gridPane.add(this.txtFileName, 1, row, 2, 1);
        this.cbPath.setMaxWidth(Double.MAX_VALUE);
        this.gridPane.add(new Label("Zielpfad:"), 0, ++row);
        this.gridPane.add(this.cbPath, 1, row);
        this.gridPane.add(this.btnPath, 2, row);
        GridPane.setHalignment(this.lblSizeFree, HPos.RIGHT);
        this.gridPane.add(this.lblSizeFree, 1, ++row, 2, 1);
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        this.getVBoxCont().setPadding(new Insets(5.0));
        this.getVBoxCont().setSpacing(20.0);
        this.getVBoxCont().getChildren().addAll((Node[])new Node[]{this.gridPane});
        this.addCancelButton(this.btnCancel);
        this.addOkButton(this.btnRestartDownload);
        this.addOkButton(this.btnContinueDownload);
        this.getHBoxOverButtons().setAlignment(Pos.CENTER_RIGHT);
        this.getHBoxOverButtons().getChildren().addAll((Node[])new Node[]{this.chkAlways});
    }

    private void initButton() {
        this.btnPath.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        this.btnPath.setTooltip(new Tooltip("Einen Pfad zum Speichern ausw\u00e4hlen"));
        this.btnPath.setOnAction(event -> this.getDestination());
        this.btnCancel.setOnAction(event -> {
            this.result = ProgConfigAskBeforeDelete.ContinueDownload.CANCEL;
            this.quit();
        });
        this.btnRestartDownload.setOnAction(event -> {
            if (this.chkAlways.isSelected()) {
                ProgConfig.DOWNLOAD_CONTINUE.setValue(2);
            }
            this.result = ProgConfigAskBeforeDelete.ContinueDownload.RESTART;
            this.download.setPathName((String)this.cbPath.getSelectionModel().getSelectedItem(), this.txtFileName.getText());
            this.quit();
        });
        this.btnContinueDownload.setOnAction(event -> {
            if (this.chkAlways.isSelected()) {
                ProgConfig.DOWNLOAD_CONTINUE.setValue(1);
            }
            this.result = ProgConfigAskBeforeDelete.ContinueDownload.CONTINUE;
            this.quit();
        });
    }

    private void initPathAndName() {
        this.cbPath.getItems().addAll((Collection<String>)ProgConfig.DOWNLOAD_DIALOG_DOWNLOAD_PATH);
        if (this.download.getDestPath().isEmpty()) {
            this.cbPath.getSelectionModel().selectFirst();
        } else {
            this.cbPath.getSelectionModel().select(this.download.getDestPath());
        }
        this.cbPath.valueProperty().addListener((observable2, oldValue, newValue) -> {
            this.stopCounter();
            if (newValue != null) {
                this.btnContinueDownload.setDisable(!this.download.getDestPath().equals(newValue));
                this.download.setFile(Paths.get((String)this.cbPath.getValue(), this.txtFileName.getText()).toFile());
            }
            DownloadFactory.calculateAndCheckDiskSpace(this.download, (String)this.cbPath.getSelectionModel().getSelectedItem(), this.lblSizeFree);
        });
        DownloadFactory.calculateAndCheckDiskSpace(this.download, (String)this.cbPath.getSelectionModel().getSelectedItem(), this.lblSizeFree);
        this.txtFileName.setText(this.download.getDestFileName());
        this.txtFileName.textProperty().addListener((observable2, oldValue, newValue) -> {
            this.stopCounter();
            if (newValue != null) {
                this.btnContinueDownload.setDisable(!this.download.getDestFileName().equals(newValue));
            }
            if (!this.txtFileName.getText().equals(P2FileNameUtils.checkFileName(this.txtFileName.getText(), false))) {
                this.txtFileName.setStyle(ProgColorList.DOWNLOAD_NAME_ERROR.getCssBackground());
            } else {
                this.txtFileName.setStyle("");
            }
        });
    }

    private void handleCountDownAction() {
        Integer n = this.timeSeconds;
        this.timeSeconds = this.timeSeconds - 1;
        if (this.timeSeconds > 0) {
            if (!this.httpDownload) {
                this.btnRestartDownload.setText("neu _Starten in " + this.timeSeconds + " s");
            } else {
                this.btnContinueDownload.setText("_Weiterf\u00fchren in " + this.timeSeconds + " s");
            }
        } else {
            this.timeline.stop();
            this.result = ProgConfigAskBeforeDelete.ContinueDownload.CONTINUE;
            this.quit();
        }
    }

    private void stopCounter() {
        if (this.timeline != null) {
            this.timeline.stop();
        }
        this.setButtonText();
    }

    private void setButtonText() {
        if (!this.httpDownload) {
            this.btnRestartDownload.setText("neu _Starten");
        } else {
            this.btnContinueDownload.setText("_Weiterf\u00fchren");
        }
    }

    private void quit() {
        this.timeline.stop();
        this.close();
    }

    private void getDestination() {
        P2DirFileChooser.DirChooser(ProgData.getInstance().primaryStage, this.cbPath);
    }
}

