/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.gui.dialog.ImportSetDialogController;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;

public class NoSetDialogController
extends P2DialogExtra {
    final ProgData progData;
    final TEXT text;
    Button btnCancel = new Button("_Abbrechen");
    Button btnImport = new Button("_Standarsets wieder herstellen");

    public NoSetDialogController(ProgData progData, TEXT text) {
        super(progData.primaryStage, null, text == TEXT.SAVE || text == TEXT.ABO ? "Set zum Speichern" : "Kein Videoplayer!", true, false);
        this.progData = progData;
        this.text = text;
        this.init(true);
    }

    @Override
    public void make() {
        this.btnCancel.setOnAction(a -> this.close());
        this.btnImport.setOnAction(event -> {
            Platform.runLater(() -> {
                ImportSetDialogController importSetDialogController = new ImportSetDialogController(this.progData);
                importSetDialogController.close();
            });
            this.close();
        });
        Text textHeaderSave = new Text("Kein Set zum Aufzeichnen!");
        textHeaderSave.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        textHeaderSave.getStyleClass().add("downloadGuiMediaText");
        Text textHeaderPlay = new Text("Kein Videoplayer zum Abspielen!");
        textHeaderPlay.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        textHeaderPlay.getStyleClass().add("downloadGuiMediaText");
        Text textHeaderAbo = new Text("Kein Set zum Aufzeichnen der Abos!");
        textHeaderAbo.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        textHeaderAbo.getStyleClass().add("downloadGuiMediaText");
        String txtAdd = "Im Programmmen\u00fc unter\n -> Einstellungen -> Aufzeichnen und Abspielen\nk\u00f6nnen die Einstellungen zum Abspielen und Aufzeichnen von Filmen korrigiert werden.\n\n -> Standardsets wieder herstellen\nEs werden die Einstellungen zur\u00fcckgesetzt und\ndie Standardsets wieder hergestellt.";
        int prefRowCount = 14;
        TextArea textArea = new TextArea();
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setMaxHeight(Double.MAX_VALUE);
        textArea.setPrefRowCount(14);
        VBox.setVgrow(textArea, Priority.ALWAYS);
        this.getVBoxCont().setSpacing(20.0);
        switch (this.text) {
            case SAVE: {
                this.getVBoxCont().getChildren().addAll((Node[])new Node[]{textHeaderSave, textArea});
                textArea.setText("Es ist kein Set von Programmen zum Aufzeichnen der Filme angelegt." + P2LibConst.LINE_SEPARATORx2 + "Im Programmmen\u00fc unter\n -> Einstellungen -> Aufzeichnen und Abspielen\nk\u00f6nnen die Einstellungen zum Abspielen und Aufzeichnen von Filmen korrigiert werden.\n\n -> Standardsets wieder herstellen\nEs werden die Einstellungen zur\u00fcckgesetzt und\ndie Standardsets wieder hergestellt.");
                break;
            }
            case PLAY: {
                this.getVBoxCont().getChildren().addAll((Node[])new Node[]{textHeaderPlay, textArea});
                textArea.setText("Es ist kein Videoplayer zum Abspielen der Filme angelegt." + P2LibConst.LINE_SEPARATORx2 + "Im Programmmen\u00fc unter\n -> Einstellungen -> Aufzeichnen und Abspielen\nk\u00f6nnen die Einstellungen zum Abspielen und Aufzeichnen von Filmen korrigiert werden.\n\n -> Standardsets wieder herstellen\nEs werden die Einstellungen zur\u00fcckgesetzt und\ndie Standardsets wieder hergestellt.");
                break;
            }
            case ABO: {
                this.getVBoxCont().getChildren().addAll((Node[])new Node[]{textHeaderAbo, textArea});
                textArea.setText("Es ist kein Set von Programmen zum Aufzeichnen der Abos angelegt." + P2LibConst.LINE_SEPARATORx2 + "Im Programmmen\u00fc unter\n -> Einstellungen -> Aufzeichnen und Abspielen\nk\u00f6nnen die Einstellungen zum Abspielen und Aufzeichnen von Filmen korrigiert werden.\n\n -> Standardsets wieder herstellen\nEs werden die Einstellungen zur\u00fcckgesetzt und\ndie Standardsets wieder hergestellt.");
            }
        }
        this.addOkButton(this.btnImport);
        this.addCancelButton(this.btnCancel);
    }

    public static enum TEXT {
        SAVE,
        PLAY,
        ABO;

    }
}

