/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog;

import de.p2tools.mtplayer.controller.ProgSave;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.tools.P2ShutDown;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class ChangeShutDownCallDialog
extends P2DialogExtra {
    private final Button btnOk = new Button("_Ok");

    public ChangeShutDownCallDialog(Stage stage) {
        super(stage, null, "Den Systembefehl zum Herunterfahren anpassen", true, true, P2DialogExtra.DECO.NO_BORDER);
        this.initDialog();
        this.init(false);
        super.showDialog();
    }

    private void initDialog() {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        TextField txtCall = new TextField();
        txtCall.textProperty().bindBidirectional(ProgConfig.SYSTEM_SHUT_DOWN_CALL);
        if (txtCall.getText().isEmpty()) {
            txtCall.setText(P2ShutDown.getShutDownCommand());
        }
        Label lblStandard = new Label(P2ShutDown.getShutDownCommand());
        Button btnStandard = new Button("Standard setzen");
        btnStandard.setOnAction(a -> txtCall.setText(P2ShutDown.getShutDownCommand()));
        Button btnTest = new Button("Testen");
        btnTest.setOnAction(a -> {
            ProgSave.saveAll();
            P2ShutDown.shutDown(ProgConfig.SYSTEM_SHUT_DOWN_CALL.getValueSafe());
        });
        Button btnHelp = P2Button.helpButton(this.getStageProp(), "Rechner herunterfahren", "Wird das Programm bei noch laufenden Downloads beendet, erscheint der \"Auf Downloads warten\" Dialog. Hier kann dann ausgew\u00e4hlt werden:\n\n-> Nicht beenden\n-> Beenden\n-> Warten\n\nWird \"Warten\" ausgew\u00e4hlt, beendet sich das Programm erst wenn alle Downloads erledigt sind. Nach dem Warten ist es dann m\u00f6glich, einen Systemaufruf abzusetzen. Gedacht ist das, um nach der Wartezeit das Programm zu beenden und den Rechner herunterzufahren. F\u00fcr Linux und Windows bringt das Programm die Standard-Befehle daf\u00fcr mit.\n\nDiese k\u00f6nnen aber auch angepasst werden. So ist es z.B. auch m\u00f6glich, einen ganz anderen Befehl oder ein eigenes Skript nach dem Warten auf die Downloads und dem Programmende, auszuf\u00fchren.\n");
        VBox vBox = new VBox(10.0);
        HBox hBox = new HBox(10.0);
        hBox.getChildren().addAll((Node[])new Node[]{new Label("Standard Befehl:"), lblStandard, P2GuiTools.getHBoxGrower(), btnStandard});
        vBox.getChildren().addAll((Node[])new Node[]{hBox});
        hBox = new HBox(10.0);
        HBox.setHgrow(txtCall, Priority.ALWAYS);
        hBox.getChildren().addAll((Node[])new Node[]{new Label("Eigener Befehl:"), txtCall, btnTest, btnHelp});
        vBox.getChildren().addAll((Node[])new Node[]{P2GuiTools.getVDistance(10), hBox});
        this.getVBoxCont().getChildren().addAll((Node[])new Node[]{vBox});
        this.addOkButton(this.btnOk);
        this.btnOk.setOnAction(a -> this.close());
    }
}

