/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkData;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkFactory;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkLoadSaveFactory;
import de.p2tools.mtplayer.gui.BookmarkTableContextMenu;
import de.p2tools.mtplayer.gui.dialog.BookmarkDelDialog;
import de.p2tools.mtplayer.gui.infoPane.PaneBookmarkInfo;
import de.p2tools.mtplayer.gui.tools.table.Table;
import de.p2tools.mtplayer.gui.tools.table.TableBookmark;
import de.p2tools.mtplayer.gui.tools.table.TableRowBookmark;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.P2TableFactory;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.util.Optional;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class BookmarkDialogController
extends P2DialogExtra {
    private final TableBookmark tableView;
    private final ProgData progData;
    private final PaneBookmarkInfo paneBookmarkInfo;
    private final Label lblSize = new Label();
    private final Button btnDel = new Button("L\u00f6schen");
    private final P2ToggleSwitch tglShow = new P2ToggleSwitch("Infos");

    public BookmarkDialogController(ProgData progData) {
        super(progData.primaryStage, ProgConfig.BOOKMARK_DIALOG_SIZE, "Bookmarks", false, false, P2DialogExtra.DECO.BORDER_SMALL);
        this.progData = progData;
        this.progData.bookmarkDialogController = this;
        this.tableView = new TableBookmark(Table.TABLE_ENUM.BOOKMARK, progData);
        this.paneBookmarkInfo = new PaneBookmarkInfo();
        this.initTable();
        this.init(true);
    }

    @Override
    public void close() {
        Table.saveTable(this.tableView, Table.TABLE_ENUM.BOOKMARK);
        if (this.paneBookmarkInfo.isChanged()) {
            BookmarkLoadSaveFactory.saveBookmark();
        }
        this.progData.bookmarkDialogController = null;
        super.close();
    }

    @Override
    public void make() {
        this.tglShow.selectedProperty().bindBidirectional(ProgConfig.BOOKMARK_DIALOG_SHOW_INFO);
        this.paneBookmarkInfo.visibleProperty().bind(ProgConfig.BOOKMARK_DIALOG_SHOW_INFO);
        this.paneBookmarkInfo.managedProperty().bind(ProgConfig.BOOKMARK_DIALOG_SHOW_INFO);
        this.progData.bookmarkList.addListener((u, o, n) -> this.btnDel.setDisable(this.progData.bookmarkList.isEmpty()));
        this.btnDel.setDisable(this.progData.bookmarkList.isEmpty());
        this.btnDel.setTooltip(new Tooltip("Bookmarks werden gel\u00f6scht und in einem Dialog wird vorher abgefragt, welche."));
        this.btnDel.setOnAction(a -> {
            BookmarkDelDialog b = new BookmarkDelDialog(this.progData, this.getStage());
            if (b.isOk()) {
                BookmarkFactory.deleteFromDialog(this.getStage(), false);
            }
        });
        HBox hBoxSize = new HBox(10.0);
        hBoxSize.getChildren().addAll((Node[])new Node[]{this.btnDel, this.tglShow, P2GuiTools.getHBoxGrower(), new Label("Anzahl: "), this.lblSize});
        hBoxSize.setAlignment(Pos.CENTER_RIGHT);
        VBox vbox = new VBox(10.0);
        vbox.getChildren().addAll((Node[])new Node[]{this.tableView, this.paneBookmarkInfo, hBoxSize});
        VBox.setVgrow(this.tableView, Priority.ALWAYS);
        this.getVBoxCont().getChildren().add(vbox);
        this.getVBoxCont().setPadding(new Insets(10.0));
        this.getVBoxCont().setSpacing(10.0);
        VBox.setVgrow(vbox, Priority.ALWAYS);
        Button btnOk = new Button("Ok");
        btnOk.setOnAction(a -> this.close());
        Button btnHelp = P2Button.helpButton(this.getStage(), "Bookmarks", "Hier werden alle Bookmarks angezeigt. Sie k\u00f6nnen gel\u00f6scht werden, es k\u00f6nnen die Filme angesehen oder gespeichert werden. F\u00fcr rot markierte Bookmarks gibt es keinen Film mehr in der Filmliste.");
        this.addHlpButton(btnHelp);
        this.addOkButton(btnOk);
    }

    private Optional<BookmarkData> getSel(boolean show) {
        Optional<BookmarkData> mtp;
        int selectedTableRow = this.tableView.getSelectionModel().getSelectedIndex();
        if (selectedTableRow >= 0) {
            mtp = Optional.of((BookmarkData)this.tableView.getSelectionModel().getSelectedItem());
        } else {
            if (show) {
                P2Alert.showInfoNoSelection();
            }
            mtp = Optional.empty();
        }
        return mtp;
    }

    private void initTable() {
        Table.setTable(this.tableView);
        this.tableView.setItems(this.progData.bookmarkList.getSortedList());
        this.progData.bookmarkList.getSortedList().comparatorProperty().bind(this.tableView.comparatorProperty());
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tableView.setRowFactory(tableView -> {
            TableRowBookmark row = new TableRowBookmark();
            row.hoverProperty().addListener(observable2 -> {
                BookmarkData bookmarkData = (BookmarkData)row.getItem();
                if (row.isHover() && bookmarkData != null) {
                    this.paneBookmarkInfo.setBookmarkData(bookmarkData);
                } else if (bookmarkData == null) {
                    this.paneBookmarkInfo.setBookmarkData((BookmarkData)tableView.getSelectionModel().getSelectedItem());
                }
            });
            return row;
        });
        this.tableView.hoverProperty().addListener(o -> {
            if (!this.tableView.isHover()) {
                this.paneBookmarkInfo.setBookmarkData((BookmarkData)this.tableView.getSelectionModel().getSelectedItem());
            }
        });
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> Platform.runLater(() -> this.paneBookmarkInfo.setBookmarkData((BookmarkData)this.tableView.getSelectionModel().getSelectedItem())));
        this.tableView.setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                Optional<BookmarkData> optionalFilm = this.getSel(false);
                BookmarkData bookmarkData = optionalFilm.orElse(null);
                ContextMenu contextMenu = new BookmarkTableContextMenu(this.progData, this.tableView).getContextMenu(bookmarkData);
                this.tableView.setContextMenu(contextMenu);
            }
        });
        this.tableView.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (P2TableFactory.SPACE.match((KeyEvent)event)) {
                P2TableFactory.scrollVisibleRangeDown(this.tableView);
                event.consume();
            }
            if (P2TableFactory.SPACE_SHIFT.match((KeyEvent)event) || P2TableFactory.SPACE_ALT.match((KeyEvent)event) || P2TableFactory.SPACE_STRG.match((KeyEvent)event)) {
                P2TableFactory.scrollVisibleRangeUp(this.tableView);
                event.consume();
            }
        });
        this.tableView.getItems().addListener(change -> this.lblSize.setText("" + this.tableView.getItems().size()));
        this.lblSize.setText("" + this.tableView.getItems().size());
    }
}

