/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.dialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkFactory;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import javafx.beans.value.ChangeListener;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

public class BookmarkDelDialog
extends P2DialogExtra {
    private final ProgData progData;
    private final Label lblAge = new Label();
    private final Slider slAge = new Slider();
    private final P2ToggleSwitch tglAll = new P2ToggleSwitch("Alle l\u00f6schen:");
    private final P2ToggleSwitch tglShown = new P2ToggleSwitch("Gesehene:");
    private final P2ToggleSwitch tglAge = new P2ToggleSwitch("Mit Alter:");
    private final Label lblCount = new Label("");
    private final ChangeListener<Boolean> tglChangeListener;
    private final ChangeListener<Number> slChangeListener;
    private boolean isOk = false;

    public BookmarkDelDialog(ProgData progData, Stage stage) {
        super(stage, ProgConfig.BOOKMARK_DIALOG_DEL_SIZE, "Bookmarks l\u00f6schen", true, false, P2DialogExtra.DECO.BORDER_SMALL);
        this.progData = progData;
        this.tglChangeListener = (o, u, n) -> this.setCount();
        this.slChangeListener = (o, u, n) -> {
            this.writeDelAge();
            this.setCount();
        };
        this.init(true);
    }

    @Override
    public void make() {
        this.slAge.setMin(1.0);
        this.slAge.setMax(50.0);
        this.slAge.setShowTickLabels(false);
        this.slAge.setMajorTickUnit(100.0);
        this.slAge.setBlockIncrement(5.0);
        GridPane gridPane1 = new GridPane();
        gridPane1.setHgap(5.0);
        gridPane1.setVgap(5.0);
        gridPane1.setPadding(new Insets(10.0));
        gridPane1.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        int row1 = 0;
        gridPane1.add(this.tglAll, 0, row1, 2, 1);
        gridPane1.add(new Label("   "), 0, ++row1);
        GridPane gridPane2 = new GridPane();
        gridPane2.setHgap(5.0);
        gridPane2.setVgap(5.0);
        gridPane2.setPadding(new Insets(10.0));
        gridPane2.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        int row2 = 0;
        gridPane2.add(this.tglShown, 0, row2, 3, 1);
        gridPane2.add(this.tglAge, 0, ++row2, 3, 1);
        gridPane2.add(new Label(""), 0, ++row2);
        gridPane2.add(this.slAge, 1, row2);
        gridPane2.add(this.lblAge, 2, row2);
        GridPane.setHalignment(this.lblAge, HPos.RIGHT);
        Label lbl = new Label("100 Tage");
        lbl.setVisible(false);
        gridPane2.add(lbl, 2, row2);
        gridPane1.add(gridPane2, 1, row1);
        gridPane2.disableProperty().bind(this.tglAll.selectedProperty());
        this.getVBoxCont().getChildren().add(gridPane1);
        this.getVBoxCont().setPadding(new Insets(10.0));
        HBox hBox = new HBox(10.0);
        hBox.getChildren().addAll((Node[])new Node[]{this.lblCount});
        hBox.setAlignment(Pos.CENTER_RIGHT);
        this.getVBoxCont().getChildren().addAll((Node[])new Node[]{P2GuiTools.getVBoxGrower(), hBox});
        this.slAge.disableProperty().bind(this.tglAge.selectedProperty().not());
        this.lblAge.disableProperty().bind(this.tglAge.selectedProperty().not());
        this.tglAll.selectedProperty().bindBidirectional(ProgConfig.BOOKMARK_DEL_ALL);
        this.tglShown.selectedProperty().bindBidirectional(ProgConfig.BOOKMARK_DEL_SHOWN);
        this.tglAge.selectedProperty().bindBidirectional(ProgConfig.BOOKMARK_DEL_OLD);
        this.slAge.valueProperty().bindBidirectional(ProgConfig.BOOKMARK_DEL_OLD_COUNT_DAYS);
        this.tglAll.selectedProperty().addListener(this.tglChangeListener);
        this.tglShown.selectedProperty().addListener(this.tglChangeListener);
        this.tglAge.selectedProperty().addListener(this.tglChangeListener);
        this.slAge.valueProperty().addListener(this.slChangeListener);
        this.writeDelAge();
        this.setCount();
        Button btnOk = new Button("Ok");
        Button btnCancel = new Button("Abbrechen");
        btnOk.setOnAction(a -> this.quit(true));
        btnOk.disableProperty().bind(this.tglAll.selectedProperty().not().and(this.tglShown.selectedProperty().not()).and(this.tglAge.selectedProperty().not()));
        btnCancel.setOnAction(a -> this.quit(false));
        Button btnHelp = P2Button.helpButton(this.getStage(), "Bookmarks l\u00f6schen", "Hier kann vorgegeben werden, welche Bookmarks gel\u00f6scht werden sollen.\n\n* Alle l\u00f6schen:\n   Es werden alle Bookmarks gel\u00f6scht\n* Gesehene:\n   Bookmarks f\u00fcr Filme die schon gesehen wurden\n* Ohne Film in der Liste:\n   Bookmarks, deren Film nicht mehr in der Filmliste enthalten ist\n* Mit Alter:\n   Bookmarks deren Datum \"Angelegt\" \u00e4lter ist als vorgegeben");
        this.addHlpButton(btnHelp);
        this.addOkCancelButtons(btnOk, btnCancel);
    }

    private void setCount() {
        int count = BookmarkFactory.deleteFromDialog(this.getStage(), true);
        this.lblCount.setText("Anzahl zum L\u00f6schen: " + count);
    }

    private void writeDelAge() {
        this.lblAge.setText(ProgConfig.BOOKMARK_DEL_OLD_COUNT_DAYS.get() + " Tage");
    }

    private void quit(boolean ok) {
        this.tglAll.selectedProperty().removeListener(this.tglChangeListener);
        this.tglShown.selectedProperty().removeListener(this.tglChangeListener);
        this.tglAge.selectedProperty().removeListener(this.tglChangeListener);
        this.slAge.valueProperty().removeListener(this.slChangeListener);
        this.tglAll.selectedProperty().unbindBidirectional(ProgConfig.BOOKMARK_DEL_ALL);
        this.tglShown.selectedProperty().unbindBidirectional(ProgConfig.BOOKMARK_DEL_SHOWN);
        this.tglAge.selectedProperty().unbindBidirectional(ProgConfig.BOOKMARK_DEL_OLD);
        this.slAge.valueProperty().unbindBidirectional(ProgConfig.BOOKMARK_DEL_OLD_COUNT_DAYS);
        this.isOk = ok;
        this.close();
    }

    public boolean isOk() {
        return this.isOk;
    }
}

