/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.panesetdata;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.setdata.ProgramData;
import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.ptable.P2CellCheckBox;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneSetProgram {
    TableView<ProgramData> tableView = new TableView();
    private final GridPane gridPane = new GridPane();
    private final TextField txtName = new TextField();
    private final TextField txtDestName = new TextField();
    private final TextField txtProgPath = new TextField();
    private final TextField txtProgSwitch = new TextField();
    private final TextField txtPrefix = new TextField();
    private final TextField txtSuffix = new TextField();
    private final P2ToggleSwitch tglDown = new P2ToggleSwitch("Downloadmanager: ");
    private ProgramData programData = null;
    private final Stage stage;
    private SetData setData = null;
    private final ObjectProperty<SetData> setDataObjectProperty;

    public PaneSetProgram(Stage stage, ObjectProperty<SetData> setDataObjectProperty) {
        this.stage = stage;
        this.setDataObjectProperty = setDataObjectProperty;
    }

    public void close() {
        this.unbindActTableData();
    }

    public void makePane(Collection<TitledPane> result) {
        VBox vBox = new VBox(10.0);
        vBox.setFillWidth(true);
        vBox.setPadding(new Insets(10.0));
        this.initTable(vBox);
        this.initButton(vBox);
        this.addConfigs(vBox);
        TitledPane tpConfig = new TitledPane("Hilfsprogramme", vBox);
        result.add(tpConfig);
        tpConfig.setMaxHeight(Double.MAX_VALUE);
        VBox.setVgrow(tpConfig, Priority.ALWAYS);
        this.setDataObjectProperty.addListener((u, o, n) -> {
            tpConfig.setDisable(this.setDataObjectProperty.getValue() == null);
            this.bindProgData();
        });
        tpConfig.setDisable(this.setDataObjectProperty.getValue() == null);
        this.bindProgData();
    }

    private void initTable(VBox vBox) {
        TableColumn nameColumn = new TableColumn("Name");
        nameColumn.setCellValueFactory(new PropertyValueFactory("name"));
        TableColumn destNameColumn = new TableColumn("Zieldateiname");
        destNameColumn.setCellValueFactory(new PropertyValueFactory("destName"));
        TableColumn progColumn = new TableColumn("Programm");
        progColumn.setCellValueFactory(new PropertyValueFactory("progPath"));
        TableColumn switchColumn = new TableColumn("Schalter");
        switchColumn.setCellValueFactory(new PropertyValueFactory("progSwitch"));
        TableColumn prefixColumn = new TableColumn("Pr\u00e4fix");
        prefixColumn.setCellValueFactory(new PropertyValueFactory("prefix"));
        TableColumn suffixColumn = new TableColumn("Suffix");
        suffixColumn.setCellValueFactory(new PropertyValueFactory("suffix"));
        TableColumn downManagerColumn = new TableColumn("Downloadmanager");
        downManagerColumn.setCellValueFactory(new PropertyValueFactory("downManager"));
        downManagerColumn.setCellFactory(new P2CellCheckBox<S, T>().cellFactory);
        downManagerColumn.getStyleClass().add("center");
        this.tableView.setMinHeight(100.0);
        this.tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tableView.getColumns().addAll(nameColumn, destNameColumn, progColumn, switchColumn, prefixColumn, suffixColumn, downManagerColumn);
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> Platform.runLater(this::bindActTableData));
        this.tableView.setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                ContextMenu contextMenu = this.getContextMenu();
                this.tableView.setContextMenu(contextMenu);
            }
        });
        VBox.setVgrow(this.tableView, Priority.ALWAYS);
        vBox.getChildren().addAll((Node[])new Node[]{this.tableView});
    }

    private ContextMenu getContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem miUndo = new MenuItem("Gel\u00f6schte wieder anlegen");
        miUndo.setOnAction(a -> ((SetData)this.setDataObjectProperty.getValue()).getProgramList().undoData());
        miUndo.setDisable(((SetData)this.setDataObjectProperty.getValue()).getProgramList().getUndoList().isEmpty());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miUndo});
        return contextMenu;
    }

    private void initButton(VBox vBox) {
        Button btnDel = new Button("");
        btnDel.setGraphic(ProgIcons.ICON_BUTTON_REMOVE.getImageView());
        btnDel.setOnAction(event -> {
            ObservableList sels = this.tableView.getSelectionModel().getSelectedItems();
            if (sels == null || sels.isEmpty()) {
                P2Alert.showInfoNoSelection(this.stage);
            } else {
                ((SetData)this.setDataObjectProperty.getValue()).getProgramList().addDataToUndoList(sels);
                ((SetData)this.setDataObjectProperty.getValue()).getProgramList().removeAll(sels);
                this.tableView.getSelectionModel().clearSelection();
            }
        });
        Button btnNew = new Button("");
        btnNew.setGraphic(ProgIcons.ICON_BUTTON_ADD.getImageView());
        btnNew.setOnAction(event -> {
            ProgramData progData = new ProgramData();
            ((SetData)this.setDataObjectProperty.getValue()).getProgramList().add(progData);
            this.tableView.getSelectionModel().clearSelection();
            this.tableView.getSelectionModel().select(progData);
            this.tableView.scrollTo(progData);
        });
        Button btnUp = new Button("");
        btnUp.setGraphic(ProgIcons.ICON_BUTTON_MOVE_UP.getImageView());
        btnUp.setOnAction(event -> {
            int sel = this.getSelectedLine();
            if (sel >= 0) {
                int newSel = ((SetData)this.setDataObjectProperty.getValue()).getProgramList().moveUp(sel, true);
                this.tableView.getSelectionModel().clearSelection();
                this.tableView.getSelectionModel().select(newSel);
            }
        });
        Button btnDown = new Button("");
        btnDown.setGraphic(ProgIcons.ICON_BUTTON_MOVE_DOWN.getImageView());
        btnDown.setOnAction(event -> {
            int sel = this.getSelectedLine();
            if (sel >= 0) {
                int newSel = ((SetData)this.setDataObjectProperty.getValue()).getProgramList().moveUp(sel, false);
                this.tableView.getSelectionModel().clearSelection();
                this.tableView.getSelectionModel().select(newSel);
            }
        });
        Button btnHelpProg = P2Button.helpButton(this.stage, "Hilfsprogramme", "Hier werden die Programme zum jeweiligen Set eingetragen. Falls mehrere Programme eingetragen sind, bestimmen die Inhalte der Felder [Pr\u00e4fix] und [Suffix], f\u00fcr welche URLs jedes Programm zust\u00e4ndig ist.\n\n-- Zieldateiname --\nKann f\u00fcr jedes Hilfsprogramm eigene Zieldateinamen festlegen. Ist das Feld leer, wird die Vorgabe des Sets (unter \"Speicherziel\") verwendet. Meist muss nichts angegeben werden.\n\n-- Programm --\nIn dem Feld steht NUR das Programm: ('Pfad/Programmdatei', Windows: 'Pfad\\Programmdatei'). Keine Argumente (Schalter, Optionen, etc.)!\n\n-- Schalter --\nIn diesem Feld werden die Argumente (Schalter, Optionen, etc.) des jeweiligen Programms angegeben. Sie sollten in dessen Dokumentation zu finden sein.\n\nVon MTPlayer k\u00f6nnen folgende Parameter genutzt werden:\n\n%f Original-URL des Films\n%a Zielverzeichnis des Downloads\n%b Dateiname des Downloads\n** (= zwei Sterne) Zielpfad (= Zielverzeichnis mit Dateiname)\n'**' ist identisch mit '%a/%b' (Windows: '%a\\%b')\n\nF\u00fcr ffmpeg k\u00f6nnte der Schalter z.B. so aussehen:\n-user_agent \"Mozilla/5.0\" -i %f -c copy -bsf:a aac_adtstoasc **\n\n\nWeiter sind diese Parameter m\u00f6glich (gedacht z.B. f\u00fcr Downloadmanager, oder Buttons die z.B. eine Suchmaschine aufrufen):\n\n%w Website-URL des Film\n%s Sender des Films\n%T Titel des Films\n%t Thema des Films\n\nZ.B. w\u00e4re das ein Google-Aufruf zur Suche nach dem Titel:\n\nProgramm (Linux):   firefox\nProgramm (Windows):   C:\\Program Files\\Mozilla Firefox\\firefox.exe\nSchalter:   http://www.google.de/search?q='%T'\n\n\n-- Restart --\nHiermit kann festgelegt werden, wie sich das Programm bei einem Downloadfehler verhalten soll. Ist \"Restart\" eingeschaltet, wird der Download nochmal gestartet. Ansonsten wird er sofort auf *fehlgeschlagen* gesetzt.\n\n-- Downloadmanager --\nWenn \"Downloadmanager\" eingeschaltet ist, \u00fcbergibt MTPlayer die Film-URL an dieses Programm und registriert f\u00fcr sich den Download als *erfolgreich abgeschlossen*. Das eingerichtete Hilfsprogramm muss sich um den Download komplett selbst k\u00fcmmern, und MTPlayer erh\u00e4lt dar\u00fcber keine R\u00fcckmeldung.\n\nBeispiel f\u00fcr VLC:\nProgramm: '/usr/bin/vlc'\n(Windows: '%PROGRAMFILES%\\VideoLAN\\VLC\\vlc.exe')\nSchalter: '%f :sout=#standard{access=file,mux=ts,dst=**} -I dummy --play-and-exit'\nDateiname: '%t-%T.ts'\n\nHier wird %f durch die URL des Films ersetzt. %t und %T werden durch einen Pfad und Dateinamen ersetzt und in den Programmschalter anstatt der '**' eingesetzt. Als Downloaddatei resultiert:\n'Volumes/Pfad/Thema-Titel.ts' bzw. 'C:\\Pfad\\Thema-Titel.ts'.\n\nBeispiel f\u00fcr ffmpeg (nur Windows):\nDer Pfad wird hier relativ zur Programmdatei von MTPlayer angegeben, weil MTPlayer f\u00fcr Windows das Programm ffmpeg schon im Ordner 'bin' mitbringt:\nProgramm: 'bin\\ffmpeg.exe'\nSchalter: '-i %f -c copy -bsf:a aac_adtstoasc \"**\"'\nDateiname: '%t-%T.mp4'\n\nHier wird %f durch die URL des Films ersetzt. %t und %T werden durch einen Pfad und Dateinamen ersetzt und in den Programmschalter anstatt der '**' eingesetzt. Als Downloaddatei resultiert:\n'C:\\Pfad\\Thema-Titel.mp4'.");
        HBox hBox = new HBox(5.0);
        hBox.getChildren().addAll((Node[])new Node[]{btnNew, btnDel, P2GuiTools.getVDistance(10), btnUp, btnDown, P2GuiTools.getHBoxGrower(), btnHelpProg});
        vBox.getChildren().addAll((Node[])new Node[]{hBox});
    }

    private void addConfigs(VBox vBox) {
        this.gridPane.getStyleClass().add("extra-pane");
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        this.gridPane.setPadding(new Insets(10.0));
        Button btnFile = new Button();
        btnFile.setOnAction(event -> P2DirFileChooser.FileChooserOpenFile(ProgData.getInstance().primaryStage, this.txtProgPath));
        btnFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        btnFile.setTooltip(new Tooltip("Ein Programm zum verarbeiten der URL ausw\u00e4hlen"));
        Button btnHelpDest = P2Button.helpButton(this.stage, "Zieldateiname", "Diese Parameter sind m\u00f6glich:\n\n%D Sendedatum des Films, wenn leer von 'heute'\n%d Sendezeit des Films, wenn leer von 'jetzt'\n%H 'heute', aktuelles Datum im Format JJJJMMTT, z.B. '20090815' am 15.08.2009\n%h 'jetzt', aktuelle Uhrzeit im Format HHMMss, z.B. '152059' um 15:20:59 Uhr\n\n%1 Tag, vom Sendedatum des Films, wenn leer von 'heute'\n%2 Monat, ebenso\n%3 Jahr, ebenso\n\n%4 Stunde, von der Sendezeit des Films, wenn leer von 'jetzt'\n%5 Minute, ebenso\n%6 Sekunde, ebenso\n\n%s Sender des Films\n%T Titel des Films\n%t Thema des Films\n\n%m Dauer des Films in Minuten, z.B.: 25\n%M Dauer des Films in Minuten, z.B.: 025\n\n%N Originaldateiname des Films (der kann sehr kryptisch und lang sein)\n%S Suffix des Originaldateinamens des Films (z.B. 'mp4')\n\n%i Filmnummer (\u00e4ndert sich beim Neuladen der Filmliste!)\n%q Qualit\u00e4t des Films ('HD', 'H', 'L')\n\n%Z Hashwert der URL, z.B.: '1433245578'\n%z Hashwert der URL, angeh\u00e4ngtes Suffix (entspricht '%Z.%S'), z.B.: '1433245578.mp4'\n\n\nIm Set kann eine maximale L\u00e4nge eines \"Elements\". z.B. %T und die maximale L\u00e4nge des gesamten Namens vorgegeben werden. Ist ein \"Element\" oder der gesamte Name l\u00e4nger, wird gek\u00fcrzt.\n\nBeispiele:\nAm 10.05.2021 liefert '%H__%t__%T' z.B. '20210510__Natur__Wildes Shetland' (kein Suffix)\nund '%H__%t__%T.%S' liefert z.B. '20210510__Natur__Wildes Shetland.xxx' (mit dem Originalsuffix)");
        Button btnHelpSwitch = P2Button.helpButton(this.stage, "Programmschalter", "-- Schalter --\nIn diesem Feld werden die Argumente (Schalter, Optionen, etc.) des jeweiligen Programms angegeben. Sie sollten in dessen Dokumentation zu finden sein.\n\nVon MTPlayer k\u00f6nnen folgende Parameter genutzt werden:\n\n%f Original-URL des Films\n%a Zielverzeichnis des Downloads\n%b Dateiname des Downloads\n** (= zwei Sterne) Zielpfad (= Zielverzeichnis mit Dateiname)\n'**' ist identisch mit '%a/%b' (Windows: '%a\\%b')\n\nF\u00fcr ffmpeg k\u00f6nnte der Schalter z.B. so aussehen:\n-user_agent \"Mozilla/5.0\" -i %f -c copy -bsf:a aac_adtstoasc **\n\n\nWeiter sind diese Parameter m\u00f6glich (gedacht z.B. f\u00fcr Downloadmanager, oder Buttons die z.B. eine Suchmaschine aufrufen):\n\n%w Website-URL des Film\n%s Sender des Films\n%T Titel des Films\n%t Thema des Films\n\nZ.B. w\u00e4re das ein Google-Aufruf zur Suche nach dem Titel:\n\nProgramm (Linux):   firefox\nProgramm (Windows):   C:\\Program Files\\Mozilla Firefox\\firefox.exe\nSchalter:   http://www.google.de/search?q='%T'");
        int row = 0;
        this.gridPane.add(new Label("Name: "), 0, row);
        this.gridPane.add(this.txtName, 1, row, 3, 1);
        this.gridPane.add(new Label("Zieldateiname: "), 0, ++row);
        this.gridPane.add(this.txtDestName, 1, row, 3, 1);
        this.gridPane.add(btnHelpDest, 4, row);
        this.gridPane.add(new Label("Programm: "), 0, ++row);
        this.gridPane.add(this.txtProgPath, 1, row, 3, 1);
        this.gridPane.add(btnFile, 4, row);
        this.gridPane.add(new Label("Schalter: "), 0, ++row);
        this.gridPane.add(this.txtProgSwitch, 1, row, 3, 1);
        this.gridPane.add(btnHelpSwitch, 4, row);
        this.gridPane.add(new Label("Pr\u00e4fix: "), 0, ++row);
        this.gridPane.add(this.txtPrefix, 1, row);
        this.gridPane.add(new Label("Suffix: "), 2, row);
        this.gridPane.add(this.txtSuffix, 3, row);
        this.gridPane.add(this.tglDown, 0, ++row, 2, 1);
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        this.gridPane.setDisable(true);
        vBox.getChildren().add(this.gridPane);
    }

    private int getSelectedLine() {
        int sel = this.tableView.getSelectionModel().getSelectedIndex();
        if (sel < 0) {
            P2Alert.showInfoNoSelection(this.stage);
        }
        return sel;
    }

    private void bindActTableData() {
        ProgramData programDataAct = (ProgramData)this.tableView.getSelectionModel().getSelectedItem();
        if (programDataAct == this.programData) {
            return;
        }
        this.unbindActTableData();
        this.programData = programDataAct;
        this.gridPane.setDisable(this.programData == null);
        if (this.programData != null) {
            this.txtName.textProperty().bindBidirectional(this.programData.nameProperty());
            this.txtDestName.textProperty().bindBidirectional(this.programData.destNameProperty());
            this.txtProgPath.textProperty().bindBidirectional(this.programData.progPathProperty());
            this.txtProgSwitch.textProperty().bindBidirectional(this.programData.progSwitchProperty());
            this.txtPrefix.textProperty().bindBidirectional(this.programData.prefixProperty());
            this.txtSuffix.textProperty().bindBidirectional(this.programData.suffixProperty());
            this.tglDown.selectedProperty().bindBidirectional(this.programData.downManagerProperty());
        }
    }

    private void unbindActTableData() {
        if (this.programData != null) {
            this.txtName.textProperty().unbindBidirectional(this.programData.nameProperty());
            this.txtDestName.textProperty().unbindBidirectional(this.programData.destNameProperty());
            this.txtProgPath.textProperty().unbindBidirectional(this.programData.progPathProperty());
            this.txtProgSwitch.textProperty().unbindBidirectional(this.programData.progSwitchProperty());
            this.txtPrefix.textProperty().unbindBidirectional(this.programData.prefixProperty());
            this.txtSuffix.textProperty().unbindBidirectional(this.programData.suffixProperty());
            this.txtName.setText("");
            this.txtDestName.setText("");
            this.txtProgPath.setText("");
            this.txtProgSwitch.setText("");
            this.txtPrefix.setText("");
            this.txtSuffix.setText("");
            this.tglDown.selectedProperty().unbindBidirectional(this.programData.downManagerProperty());
        }
    }

    private void bindProgData() {
        this.unBindProgData();
        this.setData = (SetData)this.setDataObjectProperty.getValue();
        if (this.setData != null) {
            this.tableView.setItems(((SetData)this.setDataObjectProperty.getValue()).getProgramList());
            if (this.tableView.getItems().size() > 0) {
                this.tableView.getSelectionModel().select(0);
            }
        }
    }

    private void unBindProgData() {
        this.tableView.setItems(FXCollections.observableArrayList());
        this.setData = null;
    }
}

