/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.configdialog.paneblacklist;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.data.blackdata.BlackData;
import de.p2tools.mtplayer.controller.data.blackdata.BlackList;
import de.p2tools.mtplayer.controller.data.blackdata.BlackListFilter;
import de.p2tools.mtplayer.controller.worker.ThemeListFactory;
import de.p2tools.p2lib.guitools.P2ButtonClearFilterFactory;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.P2MenuButton;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import de.p2tools.p2lib.mediathek.filter.Filter;
import de.p2tools.p2lib.mediathek.filter.FilterCheck;
import java.util.function.Predicate;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class PanelFilterGrid {
    private final BlackList list;
    private final P2MenuButton mbFilterChannel;
    private final StringProperty mbFilterChannelProp = new SimpleStringProperty();
    private final TextField txtFilterThema = new TextField();
    private final TextField txtFilterTitel = new TextField();
    private final TextField txtFilterThemaTitel = new TextField();
    private final TextField txtFilterSomewhere = new TextField();
    private final P2ToggleSwitch tglFilterThemeExact = new P2ToggleSwitch("Thema exakt");
    private final P2ToggleSwitch tglFilterActive = new P2ToggleSwitch("Aktiv");
    public final RadioButton rbFilm = new RadioButton("Film");
    public final RadioButton rbAudio = new RadioButton("Audio");
    public final RadioButton rbFilmAudio = new RadioButton("Film/Audio");
    private final Button btnClearFilter = P2ButtonClearFilterFactory.getPButtonClear();
    private final TableView<BlackData> tableView;
    private final BlackListFilter blackListFilterBlackList;

    public PanelFilterGrid(TableView<BlackData> tableView, BlackList list, BlackListFilter blackListFilterBlackList) {
        this.tableView = tableView;
        this.list = list;
        this.blackListFilterBlackList = blackListFilterBlackList;
        this.mbFilterChannel = new P2MenuButton(this.mbFilterChannelProp, ThemeListFactory.allChannelListFilm);
        this.bind();
        this.addPredicate();
    }

    private void bind() {
        this.rbFilmAudio.setSelected(this.blackListFilterBlackList.getList() == 0);
        this.rbFilm.setSelected(this.blackListFilterBlackList.getList() == 1);
        this.rbAudio.setSelected(this.blackListFilterBlackList.getList() == 2);
        this.mbFilterChannelProp.bindBidirectional(this.blackListFilterBlackList.channelProperty());
        this.txtFilterThema.textProperty().bindBidirectional(this.blackListFilterBlackList.themeProperty());
        this.txtFilterTitel.textProperty().bindBidirectional(this.blackListFilterBlackList.titleProperty());
        this.txtFilterThemaTitel.textProperty().bindBidirectional(this.blackListFilterBlackList.themeTitleProperty());
        this.txtFilterSomewhere.textProperty().bindBidirectional(this.blackListFilterBlackList.somewhereProperty());
        this.tglFilterThemeExact.setAllowIndeterminate(true);
        this.tglFilterActive.setAllowIndeterminate(true);
        this.tglFilterThemeExact.indeterminateProperty().bindBidirectional(this.blackListFilterBlackList.themeExactIndeterminateProperty());
        this.tglFilterThemeExact.selectedProperty().bindBidirectional(this.blackListFilterBlackList.themeExactProperty());
        this.tglFilterActive.indeterminateProperty().bindBidirectional(this.blackListFilterBlackList.filterActiveIndeterminateProperty());
        this.tglFilterActive.selectedProperty().bindBidirectional(this.blackListFilterBlackList.filterActiveProperty());
    }

    public void close() {
        if (this.rbFilmAudio.isSelected()) {
            this.blackListFilterBlackList.setList(0);
        } else if (this.rbFilm.isSelected()) {
            this.blackListFilterBlackList.setList(1);
        } else {
            this.blackListFilterBlackList.setList(2);
        }
        this.mbFilterChannelProp.unbindBidirectional(this.blackListFilterBlackList.channelProperty());
        this.txtFilterThema.textProperty().unbindBidirectional(this.blackListFilterBlackList.themeProperty());
        this.txtFilterTitel.textProperty().unbindBidirectional(this.blackListFilterBlackList.titleProperty());
        this.txtFilterThemaTitel.textProperty().unbindBidirectional(this.blackListFilterBlackList.themeTitleProperty());
        this.txtFilterSomewhere.textProperty().unbindBidirectional(this.blackListFilterBlackList.somewhereProperty());
        this.tglFilterThemeExact.indeterminateProperty().unbindBidirectional(this.blackListFilterBlackList.themeExactIndeterminateProperty());
        this.tglFilterThemeExact.selectedProperty().unbindBidirectional(this.blackListFilterBlackList.themeExactProperty());
        this.tglFilterActive.indeterminateProperty().unbindBidirectional(this.blackListFilterBlackList.filterActiveIndeterminateProperty());
        this.tglFilterActive.selectedProperty().unbindBidirectional(this.blackListFilterBlackList.filterActiveProperty());
    }

    SplitPane addFilterGrid(VBox vBox, boolean controlBlackListNotFilmFilter) {
        SplitPane splitPane = new SplitPane();
        boolean SPACE_TITLE = true;
        int SPACE_VBOX = 5;
        VBox vb1 = new VBox(5.0);
        vb1.setAlignment(Pos.TOP_LEFT);
        vb1.setPadding(new Insets(10.0));
        vb1.getStyleClass().add("extra-pane");
        Label label = new Label("Blacklist-Eintrag suchen:");
        vb1.getChildren().add(label);
        vb1.getChildren().add(P2GuiTools.getVDistance(5));
        vb1.getChildren().add(this.tglFilterActive);
        HBox hBox = new HBox(2.0);
        hBox.getChildren().addAll((Node[])new Node[]{this.rbFilmAudio, this.rbFilm, this.rbAudio});
        vb1.getChildren().add(hBox);
        VBox vb = new VBox(1.0);
        vb.getChildren().addAll((Node[])new Node[]{new Label("Sender"), this.mbFilterChannel});
        vb1.getChildren().add(vb);
        HBox.setHgrow(vb, Priority.ALWAYS);
        vb = new VBox(1.0);
        vb.getChildren().addAll((Node[])new Node[]{new Label("Thema"), this.txtFilterThema, P2GuiTools.getVDistance(2), this.tglFilterThemeExact});
        vb1.getChildren().addAll((Node[])new Node[]{vb, P2GuiTools.getVDistance(1)});
        HBox.setHgrow(vb, Priority.ALWAYS);
        vb = new VBox(1.0);
        vb.getChildren().addAll((Node[])new Node[]{new Label("Titel"), this.txtFilterTitel});
        vb1.getChildren().add(vb);
        HBox.setHgrow(vb, Priority.ALWAYS);
        vb = new VBox(1.0);
        vb.getChildren().addAll((Node[])new Node[]{new Label("Thema-Titel"), this.txtFilterThemaTitel});
        vb1.getChildren().add(vb);
        HBox.setHgrow(vb, Priority.ALWAYS);
        VBox vb2 = new VBox();
        vb2.setAlignment(Pos.TOP_LEFT);
        vb2.setPadding(new Insets(5.0));
        vb2.getStyleClass().add("extra-pane");
        vb2.getChildren().addAll((Node[])new Node[]{new Label("In allen Feldern suchen:"), this.txtFilterSomewhere});
        VBox vb3 = new VBox();
        vb3.setAlignment(Pos.CENTER_RIGHT);
        vb3.setPadding(new Insets(5.0));
        vb3.getStyleClass().add("extra-pane");
        vb3.getChildren().addAll((Node[])new Node[]{this.btnClearFilter});
        VBox vAll = new VBox(5.0);
        vAll.getChildren().addAll((Node[])new Node[]{vb1, vb2, vb3});
        this.tableView.setStyle("-fx-border-width: 1px; -fx-border-color: -text-color-blue;");
        splitPane.getItems().addAll((Node[])new Node[]{this.tableView, vAll});
        SplitPane.setResizableWithParent(vAll, false);
        SplitPane.setResizableWithParent(this.tableView, false);
        if (controlBlackListNotFilmFilter) {
            ((SplitPane.Divider)splitPane.getDividers().get(0)).positionProperty().bindBidirectional(ProgConfig.CONFIG_DIALOG_BLACKLIST_SPLITPANE);
        } else {
            ((SplitPane.Divider)splitPane.getDividers().get(0)).positionProperty().bindBidirectional(ProgConfig.CONFIG_DIALOG_FILMLIST_FILTER_SPLITPANE);
        }
        VBox.setVgrow(splitPane, Priority.ALWAYS);
        vBox.getChildren().add(splitPane);
        this.makeFilter();
        return splitPane;
    }

    private void makeFilter() {
        ToggleGroup toggleGroupList = new ToggleGroup();
        this.rbFilmAudio.setToggleGroup(toggleGroupList);
        this.rbFilm.setToggleGroup(toggleGroupList);
        this.rbAudio.setToggleGroup(toggleGroupList);
        toggleGroupList.selectedToggleProperty().addListener((u, o, n) -> this.addPredicate());
        this.mbFilterChannelProp.addListener((u, o, n) -> this.addPredicate());
        this.txtFilterThema.textProperty().addListener((u, o, n) -> this.addPredicate());
        this.txtFilterTitel.textProperty().addListener((u, o, n) -> this.addPredicate());
        this.txtFilterThemaTitel.textProperty().addListener((u, o, n) -> this.addPredicate());
        this.txtFilterSomewhere.textProperty().addListener((u, o, n) -> this.addPredicate());
        this.tglFilterThemeExact.selectedProperty().addListener((u, o, n) -> this.addPredicate());
        this.tglFilterThemeExact.indeterminateProperty().addListener((u, o, n) -> this.addPredicate());
        this.tglFilterActive.selectedProperty().addListener((u, o, n) -> this.addPredicate());
        this.tglFilterActive.indeterminateProperty().addListener((u, o, n) -> this.addPredicate());
        this.btnClearFilter.setOnAction(a -> {
            this.rbFilmAudio.setSelected(true);
            this.mbFilterChannelProp.setValue("");
            this.txtFilterThema.clear();
            this.tglFilterThemeExact.setSelected(false);
            this.tglFilterThemeExact.setIndeterminate(true);
            this.txtFilterTitel.clear();
            this.txtFilterThemaTitel.clear();
            this.txtFilterSomewhere.clear();
            this.tglFilterActive.setSelected(false);
            this.tglFilterActive.setIndeterminate(true);
        });
    }

    private void addPredicate() {
        Filter filter;
        Predicate<BlackData> predicate = blackData -> true;
        if (this.rbFilm.isSelected()) {
            predicate = predicate.and(blackData -> blackData.getList() == 1);
        } else if (this.rbAudio.isSelected()) {
            predicate = predicate.and(blackData -> blackData.getList() == 2);
        }
        if (!this.mbFilterChannelProp.getValueSafe().isEmpty()) {
            filter = new Filter(this.mbFilterChannelProp.getValueSafe(), true);
            predicate = predicate.and(blackData -> FilterCheck.check(filter, blackData.getChannel()));
        }
        if (!this.txtFilterThema.getText().isEmpty()) {
            filter = new Filter(this.txtFilterThema.getText(), true);
            predicate = predicate.and(blackData -> FilterCheck.check(filter, blackData.getTheme()));
        }
        if (!this.txtFilterTitel.getText().isEmpty()) {
            filter = new Filter(this.txtFilterTitel.getText(), true);
            predicate = predicate.and(blackData -> FilterCheck.check(filter, blackData.getTitle()));
        }
        if (!this.txtFilterThemaTitel.getText().isEmpty()) {
            filter = new Filter(this.txtFilterThemaTitel.getText(), true);
            predicate = predicate.and(blackData -> FilterCheck.check(filter, blackData.getThemeTitle()));
        }
        if (!this.txtFilterSomewhere.getText().isEmpty()) {
            filter = new Filter(this.txtFilterSomewhere.getText(), true);
            predicate = predicate.and(blackData -> FilterCheck.check(filter, blackData.getChannel()) || FilterCheck.check(filter, blackData.getTheme()) || FilterCheck.check(filter, blackData.getTitle()) || FilterCheck.check(filter, blackData.getThemeTitle()));
        }
        if (!this.tglFilterThemeExact.isIndeterminate()) {
            predicate = predicate.and(blackData -> {
                if (this.tglFilterThemeExact.isSelected()) {
                    return blackData.isThemeExact();
                }
                return !blackData.isThemeExact();
            });
        }
        if (!this.tglFilterActive.isIndeterminate()) {
            predicate = predicate.and(blackData -> {
                if (this.tglFilterActive.isSelected()) {
                    return blackData.isActive();
                }
                return !blackData.isActive();
            });
        }
        this.list.filteredListSetPred(predicate);
    }
}

